/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.groomer.entity;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.thinkgem.jeesite.common.persistence.DataEntity;
import com.thinkgem.jeesite.common.utils.excel.annotation.ExcelField;
import org.hibernate.validator.constraints.Length;
import org.springframework.web.multipart.MultipartFile;

import java.util.Date;
import java.util.List;

/**
 * 美容课程表Entity
 *
 * @author cxt
 * @version 2017-06-19
 */
public class GroomerCourse extends DataEntity<GroomerCourse> {

	private static final long serialVersionUID = 1L;
	@ExcelField(title = "学校", align = 2, sort = 4)
	private String schoolId; // 关联学校id
	@ExcelField(title = "课程编号", align = 2, sort = 1)
	private String code; //
	@ExcelField(title = "课程名称", align = 2, sort = 2)
	private String courseName; // 课程名称
	@ExcelField(title = "课程类型", align = 2, sort = 3)
	private String type; //
	private String cover; //
	private String introduce; //
	private String video; //
	@ExcelField(title = "课程状态", align = 2, sort = 12)
	private String states; //
	@ExcelField(title = "课程价格", align = 2, sort = 6)
	private String price; //
	@ExcelField(title = "报名结束时间", align = 2, sort = 9)
	private Date registrationEndTime; //
	@ExcelField(title = "报名开始时间", align = 2, sort = 8)
	private Date registrationStarteTime; //
	@ExcelField(title = "课程等级", align = 2, sort = 5)
	private String diplomaLevel; // 结业证书类型
	@ExcelField(title = "开始时间", align = 2, sort = 10)
	private Date startDate; // 开始时间
	@ExcelField(title = "结束时间", align = 2, sort = 11)
	private Date endDate; // 结束时间
	@ExcelField(title = "课程讲师", align = 2, sort = 7)
	private String teacher; // 授课教师
	private String teacherId;
	private String courseDetails; //
	private Date launchTime; //
	private String playTimes; //
	private String havaDiploma; // 页面判断是否能删除的标记 有结业记录不允许删除

	private String reviewRemarks;
	private Date beginCreateDate; // 开始 create_date
	private Date endCreateDate; // 结束 create_date
	private Date beginLaunchTime; // 开始 create_date
	private Date endLaunchTime; // 结束 create_date
	private String pic1; //
	private String pic2; //
	private String pic3;
	// app排序规则
	List<String> levelOrderBy;
	private String schoolName; // 关联学校id
	private int signUpcount;// 报名人数
	private String province;
	private String city;
	private String videoUrl;
	private String desclevel;

	//显示条件
	private String[] statesArr;
	
	private String excludeType;
	
	private String excludeState;

	public String[] getStatesArr() {
		return statesArr;
	}

	public void setStatesArr(String[] statesArr) {
		this.statesArr = statesArr;
	}

	public String getDesclevel() {
		return desclevel;
	}

	public void setDesclevel(String desclevel) {
		this.desclevel = desclevel;
	}

	public String getPlayTimes() {
		return playTimes;
	}

	public void setPlayTimes(String playTimes) {
		this.playTimes = playTimes;
	}

	public String getVideoUrl() {
		return videoUrl;
	}

	public void setVideoUrl(String videoUrl) {
		this.videoUrl = videoUrl;
	}

	private MultipartFile videoFile; // 前台传递文件用

	public MultipartFile getVideoFile() {
		return videoFile;
	}

	public void setVideoFile(MultipartFile videoFile) {
		this.videoFile = videoFile;
	}

	public String getTeacherId() {
		return teacherId;
	}

	public void setTeacherId(String teacherId) {
		this.teacherId = teacherId;
	}

	public Date getLaunchTime() {
		return launchTime;
	}

	public void setLaunchTime(Date launchTime) {
		this.launchTime = launchTime;
	}

	public Date getBeginLaunchTime() {
		return beginLaunchTime;
	}

	public void setBeginLaunchTime(Date beginLaunchTime) {
		this.beginLaunchTime = beginLaunchTime;
	}

	public Date getEndLaunchTime() {
		return endLaunchTime;
	}

	public void setEndLaunchTime(Date endLaunchTime) {
		this.endLaunchTime = endLaunchTime;
	}

	public String getReviewRemarks() {
		return reviewRemarks;
	}

	public void setReviewRemarks(String reviewRemarks) {
		this.reviewRemarks = reviewRemarks;
	}

	public String getPic1() {
		return pic1;
	}

	public void setPic1(String pic1) {
		this.pic1 = pic1;
	}

	public String getPic2() {
		return pic2;
	}

	public void setPic2(String pic2) {
		this.pic2 = pic2;
	}

	public String getPic3() {
		return pic3;
	}

	public void setPic3(String pic3) {
		this.pic3 = pic3;
	}

	public String getCourseDetails() {
		return courseDetails;
	}

	public void setCourseDetails(String courseDetails) {
		this.courseDetails = courseDetails;
	}

	public String getCode() {
		return code;
	}

	public void setCode(String code) {
		this.code = code;
	}

	public String getType() {
		return type;
	}

	public void setType(String type) {
		this.type = type;
	}

	public String getCover() {
		return cover;
	}

	public void setCover(String cover) {
		this.cover = cover;
	}

	public String getIntroduce() {
		return introduce;
	}

	public void setIntroduce(String introduce) {
		this.introduce = introduce;
	}

	public String getVideo() {
		return video;
	}

	public void setVideo(String video) {
		this.video = video;
	}

	public String getStates() {
		return states;
	}

	public void setStates(String states) {
		this.states = states;
	}

	public String getPrice() {
		return price;
	}

	public void setPrice(String price) {
		this.price = price;
	}

	public Date getRegistrationStarteTime() {
		return registrationStarteTime;
	}

	public void setRegistrationStarteTime(Date registrationStarteTime) {
		this.registrationStarteTime = registrationStarteTime;
	}

	public Date getRegistrationEndTime() {
		return registrationEndTime;
	}

	public void setRegistrationEndTime(Date registrationEndTime) {
		this.registrationEndTime = registrationEndTime;
	}

	public Date getBeginCreateDate() {
		return beginCreateDate;
	}

	public void setBeginCreateDate(Date beginCreateDate) {
		this.beginCreateDate = beginCreateDate;
	}

	public Date getEndCreateDate() {
		return endCreateDate;
	}

	public void setEndCreateDate(Date endCreateDate) {
		this.endCreateDate = endCreateDate;
	}

	public GroomerCourse() {
		super();
	}

	public GroomerCourse(String id) {
		super(id);
	}

	@Length(min = 0, max = 50, message = "关联学校id长度必须介于 0 和 50 之间")
	public String getSchoolId() {
		return schoolId;
	}

	public void setSchoolId(String schoolId) {
		this.schoolId = schoolId;
	}

	@Length(min = 0, max = 100, message = "课程名称长度必须介于 0 和 100 之间")
	public String getCourseName() {
		return courseName;
	}

	public void setCourseName(String courseName) {
		this.courseName = courseName;
	}

	@Length(min = 0, max = 50, message = "结业证书类型长度必须介于 0 和 50 之间")
	public String getDiplomaLevel() {
		return diplomaLevel;
	}

	public void setDiplomaLevel(String diplomaLevel) {
		this.diplomaLevel = diplomaLevel;
	}

	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	public Date getStartDate() {
		return startDate;
	}

	public void setStartDate(Date startDate) {
		this.startDate = startDate;
	}

	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	public Date getEndDate() {
		return endDate;
	}

	public void setEndDate(Date endDate) {
		this.endDate = endDate;
	}

	@Length(min = 0, max = 50, message = "授课教师长度必须介于 0 和 50 之间")
	public String getTeacher() {
		return teacher;
	}

	public void setTeacher(String teacher) {
		this.teacher = teacher;
	}

	public String getHavaDiploma() {
		return havaDiploma;
	}

	public void setHavaDiploma(String havaDiploma) {
		this.havaDiploma = havaDiploma;
	}

	public List<String> getLevelOrderBy() {
		return levelOrderBy;
	}

	public void setLevelOrderBy(List<String> levelOrderBy) {
		this.levelOrderBy = levelOrderBy;
	}

	public String getSchoolName() {
		return schoolName;
	}

	public void setSchoolName(String schoolName) {
		this.schoolName = schoolName;
	}

	public int getSignUpcount() {
		return signUpcount;
	}

	public void setSignUpcount(int signUpcount) {
		this.signUpcount = signUpcount;
	}

	public String getProvince() {
		return province;
	}

	public void setProvince(String province) {
		this.province = province;
	}

	public String getCity() {
		return city;
	}

	public void setCity(String city) {
		this.city = city;
	}

	public String getExcludeType() {
		return excludeType;
	}

	public void setExcludeType(String excludeType) {
		this.excludeType = excludeType;
	}

	public String getExcludeState() {
		return excludeState;
	}

	public void setExcludeState(String excludeState) {
		this.excludeState = excludeState;
	}
	
}