/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.finance.dao;

import java.util.List;

import org.apache.ibatis.annotations.Param;

import com.cku.oa.finance.entity.PaymentOrderRefund;
import com.thinkgem.jeesite.common.persistence.CrudDao;
import com.thinkgem.jeesite.common.persistence.annotation.MyBatisDao;

/**
 * 退费记录DAO接口
 * @author Sunny
 * @version 2021-06-17
 */
@MyBatisDao
public interface PaymentOrderRefundDao extends CrudDao<PaymentOrderRefund> {
	
	int insertBatch(@Param("dataList") List<PaymentOrderRefund> paymentOrderRefunds);
	
	int updateProcessByIds(@Param("data") PaymentOrderRefund data,@Param("dataList") List<String> refundOrderIds);
	
	int updateProcess(@Param("data") PaymentOrderRefund data);
	
	List<PaymentOrderRefund> findByIds(@Param("dataList") List<String> refundOrderIds);
	
	List<PaymentOrderRefund> findByOrderCodes(@Param("dataList") List<String> refundOrderCodes);
	
}