package com.cku.oa.dog.web;

import com.cku.core.ResultDto;
import com.cku.core.ZAErrorCode;
import com.cku.core.ZAException;
import com.cku.oa.dog.entity.DogChipMemberLock;
import com.cku.oa.dog.service.DogChipMemberLockService;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.utils.StringUtils;
import com.thinkgem.jeesite.common.web.BaseController;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * 犬只芯片会员锁定Controller
 *
 * @author yuanshuai
 * @version 2021-03-02
 */
@Controller
@RequestMapping(value = "${adminPath}/dog/dogChipMemberLock")
public class DogChipMemberLockController extends BaseController {

	@Autowired
	private DogChipMemberLockService dogChipMemberLockService;

	@ModelAttribute
	public DogChipMemberLock get(@RequestParam(required = false) String id) {
		DogChipMemberLock entity = null;
		if (StringUtils.isNotBlank(id)) {
			entity = dogChipMemberLockService.get(id);
		}
		if (entity == null) {
			entity = new DogChipMemberLock();
		}
		return entity;
	}

	@RequiresPermissions("dog:dogChipMemberLock:view")
	@RequestMapping(value = {"list", ""})
	public String list(DogChipMemberLock dogChipMemberLock, HttpServletRequest request, HttpServletResponse response, Model model) {
		Page<DogChipMemberLock> page = dogChipMemberLockService.findPage(new Page<DogChipMemberLock>(request, response), dogChipMemberLock);
		model.addAttribute("page", page);
		return "oa/dog/dogChipMemberLock/dogChipMemberLockList";
	}

	@RequiresPermissions("dog:dogChipMemberLock:view")
	@RequestMapping(value = "form")
	public String form(DogChipMemberLock dogChipMemberLock, Model model) {
		model.addAttribute("dogChipMemberLock", dogChipMemberLock);
		return "oa/dog/dogChipMemberLock/dogChipMemberLockForm";
	}

	@RequiresPermissions("dog:dogChipMemberLock:edit")
	@RequestMapping(value = "save")
	@ResponseBody
	public ResultDto<String> save(DogChipMemberLock dogChipMemberLock) {
		try {
			restBeanValidator(dogChipMemberLock);
			dogChipMemberLockService.saveData(dogChipMemberLock);
		} catch (ZAException e) {
			e.printStackTrace();
			return ResultDto.error(ZAErrorCode.ZA_VALID_FAILED, "保存犬只芯片会员锁定失败：" + e.getMessage());
		}
		return ResultDto.success("保存犬只芯片会员锁定成功");
	}
}