package com.cku.oa.dog.util;

import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.TagSupport;
import java.util.Calendar;
import java.util.Date;

/**
 * Created by laiguanglong on 2018/5/11.
 */
public class EnglishDateTag extends TagSupport {

    private Date value;

    @Override
    public int doStartTag() throws JspException {
        if (value != null) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(value);
            int year = calendar.get(Calendar.YEAR);
            int month = calendar.get(Calendar.MONTH) + 1;
            int date = calendar.get(Calendar.DATE);
            String monthEnglish = "";

            switch (month) {
                case 1:
                    monthEnglish = "JAN";
                    break;
                case 2:
                    monthEnglish = "FEB";
                    break;
                case 3:
                    monthEnglish = "MAR";
                    break;
                case 4:
                    monthEnglish = "APR";
                    break;
                case 5:
                    monthEnglish = "MAY";
                    break;
                case 6:
                    monthEnglish = "JUNE";
                    break;
                case 7:
                    monthEnglish = "JULY";
                    break;
                case 8:
                    monthEnglish = "AUG";
                    break;
                case 9:
                    monthEnglish = "SEPT";
                    break;
                case 10:
                    monthEnglish = "OCT";
                    break;
                case 11:
                    monthEnglish = "NOV";
                    break;
                case 12:
                    monthEnglish = "DEC";
                    break;
                default:
                    break;
            }
            String targetTime = year + "-" + monthEnglish + "-" + String.format("%02d", date);
            try {
                super.pageContext.getOut().write(targetTime);
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
        return super.doStartTag();
    }

    public Date getValue() {
        return value;
    }

    public void setValue(Date value) {
        this.value = value;
    }
}
