package com.cku.oa.contest.web;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.cku.oa.contest.entity.Language;
import com.cku.oa.contest.service.LanguageService;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

import com.thinkgem.jeesite.common.config.Global;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.web.BaseController;
import com.thinkgem.jeesite.common.utils.StringUtils;
import com.cku.oa.contest.entity.ContestBreed;
import com.cku.oa.contest.service.ContestBreedService;

/**
 * 犬展活动区域犬种Controller
 * @author yuanshuai
 * @version 2020-10-12
 */
@Controller
@RequestMapping(value = "${adminPath}/contest/contestBreed")
public class ContestBreedController extends BaseController {

	@Autowired
	private ContestBreedService contestBreedService;
	@Autowired
	private LanguageService languageService;

	@ModelAttribute
	public ContestBreed get(@RequestParam(required=false) String id) {
		ContestBreed entity = null;
		if (StringUtils.isNotBlank(id)){
			entity = contestBreedService.get(id);
		}
		if (entity == null){
			entity = new ContestBreed();
		}
		return entity;
	}
	
	@RequiresPermissions("contest:contestBreed:view")
	@RequestMapping(value = {"list", ""})
	public String list(ContestBreed contestBreed, HttpServletRequest request, HttpServletResponse response, Model model) {
		Page<ContestBreed> page = contestBreedService.findPage(new Page<>(request, response), contestBreed);
		model.addAttribute("page", page);
		model.addAttribute("languageList", languageService.findList(new Language()));
		return "oa/contest/contestBreedList";
	}

	@RequiresPermissions("contest:contestBreed:view")
	@RequestMapping(value = "form")
	public String form(ContestBreed contestBreed, Model model) {
		model.addAttribute("contestBreed", contestBreed);
		model.addAttribute("languageList", languageService.findList(new Language()));
		return "oa/contest/contestBreedForm";
	}

	@RequiresPermissions("contest:contestBreed:edit")
	@RequestMapping(value = "save")
	public String save(ContestBreed contestBreed, Model model, RedirectAttributes redirectAttributes) {
		if (!beanValidator(model, contestBreed)){
			return form(contestBreed, model);
		}
		contestBreedService.save(contestBreed);
		addMessage(redirectAttributes, "保存犬展活动区域犬种成功");
		return "redirect:"+Global.getAdminPath()+"/contest/contestBreed/?repage";
	}
	
	@RequiresPermissions("contest:contestBreed:del")
	@RequestMapping(value = "delete")
	public String delete(ContestBreed contestBreed, RedirectAttributes redirectAttributes) {
		contestBreedService.delete(contestBreed);
		addMessage(redirectAttributes, "删除犬展活动区域犬种成功");
		return "redirect:"+Global.getAdminPath()+"/contest/contestBreed/?repage";
	}

}