<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp" %>
<html>
<head>
    <title>寻宠寻主审核页</title>
    <meta name="decorator" content="default"/>
    <script type="text/javascript">
        $(document).ready(function () {
            //$("#name").focus();
            $("#inputForm").validate({
                submitHandler: function (form) {
                    var reviewState = $("input[name='reviewState']:checked").val();
                    var reviewRemark;
                    $("input:checkbox[name='reviewRemarks']:checked").each(function () {
                            reviewRemark=$(this).val();
                    });
                    var otherReviewRemark = $("input:text[id='reviewRemarks']").val();
                    if(reviewState == "2" && isNull(reviewRemark)&& isNull(otherReviewRemark)){
                        alert("审核未通过原因不能为空！！！");
                        return ;
                    }
                    loading('正在提交，请稍等...');
                    form.submit();
                },
                errorContainer: "#messageBox",
                errorPlacement: function (error, element) {
                    $("#messageBox").text("输入有误，请先更正。");
                    if (element.is(":checkbox") || element.is(":radio") || element.parent().is(".input-append")) {
                        error.appendTo(element.parent().parent());
                    } else {
                        error.insertAfter(element);
                    }
                }
            });
        });
        function isNull(str){
            if("undefined" == str || null == str
                || str == "" || undefined == str){
                return true;
            }else{
                return false;
            }
        }
        function  changeReviewState(statesName,remarkName){
            var remark = $("input[name='"+remarkName+"']:checked").val();
            if(null != remark && remark != ""){
                $("#"+remarkName).removeAttr("disabled");
                $("[name='"+statesName+"']:eq(1)").attr("checked","");
            }else{
                $("[name='"+statesName+"']:eq(0)").attr("checked","");
            }
        }
        function  otherReview(statesName,remarkName,otherRemark){
            $("#"+remarkName).removeAttr("disabled");
            $("[name='"+statesName+"']:eq(1)").attr("checked","");
            $("input[name='"+otherRemark+"']").attr("checked",true);
        }
        function disabledRemarks(statesName,remarkName) {
            var states = $("input[name='"+statesName+"']:checked").val();
            if(states == "1"){
                $("input[name='"+remarkName+"']").attr("checked",false);
                $('#'+remarkName).val("");
                //$('#'+remarkName).attr("disabled",true);
            }else{
                $('#'+remarkName).attr("disabled",false);
            }
        }
        function disabledRemarks1(statesName,remarkName,otherRemark) {
            var states = $("input[name='"+statesName+"']:checked").val();
            if(states == "1"){
                $("input[name='"+remarkName+"']").attr("checked",false);
                $('#'+remarkName).val("");
                $("input[name='"+otherRemark+"']").attr("checked",false);
                //$('#'+remarkName).attr("disabled",true);
            }else{
                $('#'+remarkName).attr("disabled",false);
            }
        }
    </script>
</head>
<body>
<ul class="nav nav-tabs">
    <li><a href="${ctx}/petLostAndFound/">寻宠寻主列表</a></li>
    <li class="active"><a href="#">审核</a></li>
</ul>
<br/>
<form:form id="inputForm" modelAttribute="petLostAndFound" action="${ctx}/petLostAndFound/savaReview"
           method="post" class="form-horizontal">
    <form:hidden path="id"/>
    <sys:message content="${message}"/>
    <div class="control-group">
        <label class="control-label">编号：</label>
        <div class="controls">
                ${petLostAndFound.lostAndFoundCode}
        </div>
    </div>
    <div class="control-group">
        <label class="control-label">寻宠/寻主：</label>
        <div class="controls">
                ${fns:getDictLabel(petLostAndFound.lostAndFoundType, 'lost_and_found_type', '')}
        </div>
    </div>
    <div class="control-group">
        <label class="control-label">宠物名：</label>
        <div class="controls">
                ${petLostAndFound.petName}
        </div>
    </div>
    <div class="control-group">
        <label class="control-label">性别：</label>
        <div class="controls">
                ${fns:getDictLabel(petLostAndFound.petGender, 'pet_gender', '')}
        </div>
    </div>
    <div class="control-group">
        <label class="control-label">宠物种类：</label>
        <div class="controls">
                ${fns:getDictLabel(petLostAndFound.petType, 'pet_type', '')}
        </div>
    </div>
    <div class="control-group">
        <label class="control-label">颜色：</label>
        <div class="controls">
                ${petLostAndFound.petCoatColor}
        </div>
    </div>
    <div class="control-group">
        <label class="control-label">城市：</label>
        <div class="controls">
                ${petLostAndFound.city}
        </div>
    </div>
    <div class="control-group">
        <label class="control-label">地点：</label>
        <div class="controls">
                ${petLostAndFound.location}
        </div>
    </div>
    <div class="control-group">
        <label class="control-label">日期：</label>
        <div class="controls">
            <fmt:formatDate value="${petLostAndFound.time}" pattern="yyyy-MM-dd HH:mm"/>
        </div>
    </div>
    <div class="control-group">
        <label class="control-label">联系人：</label>
        <div class="controls">
                ${petLostAndFound.linkman}
        </div>
    </div>
    <div class="control-group">
        <label class="control-label">联系电话：</label>
        <div class="controls">
                ${petLostAndFound.phone}
        </div>
    </div>
    <div class="control-group">
        <label class="control-label">详细信息：</label>
        <div class="controls">
                ${petLostAndFound.remarks}
        </div>
    </div>
    <div  class="control-group" style="width: 100%">
        <div style="width: 100%;float: left;height: 200px">
            <label class="control-label">照片：</label>
            <div style="width:620px;float: left">
                <c:forEach items="${pictures}" var="picture">
                    <img id="test4" style="margin-left: 20px;height: 180px;width: 180px" class="imgs" src="${pageContext.request.contextPath}/pub/file/image/${picture}">
                 </c:forEach>
            </div>
            <div style="width: 40%;float: left">
                <input type="radio" name="reviewState" value="1" checked = "checked" onclick="disabledRemarks1('reviewState','reviewRemarks','otherReviewRemark')" >合格
                &nbsp; &nbsp;&nbsp;<input type="radio" name="reviewState" value="2"  onclick="disabledRemarks('reviewState','reviewRemarks')">不合格
                <p></p>
                <label> 不合格原因：</label>
                <p></p>
                <input type="checkbox" name="reviewRemarks" value="图片有敏感信息" onclick="changeReviewState('reviewState','reviewRemarks')">图片有敏感信息
                &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                <input type="checkbox" name="reviewRemarks" value="文字有敏感信息" onclick="changeReviewState('reviewState','reviewRemarks')">文字有敏感信息
                <p></p>
                <p></p>
                <input type="checkbox" name="reviewRemarks" value="图片包含手机号等联系方式" onclick="changeReviewState('reviewState','reviewRemarks')">图片包含手机号等联系方式
                &nbsp; &nbsp;&nbsp;<input type="checkbox" name="reviewRemarks" value="文字包含手机号等联系方式" onclick="changeReviewState('reviewState','reviewRemarks')">文字包含手机号等联系方式
                <p></p>
                <input style="vertical-align: top;margin-top: 3px" type="checkbox" name="otherReviewRemark"  onclick="otherReview('reviewState','reviewRemarks','otherReviewRemark')"><label style="vertical-align: top">其他:</label>
                <input style="height: 50px" name="reviewRemarks" value="" id="reviewRemarks"  maxlength="100" autocomplete="off"  onclick="otherReview('reviewState','reviewRemarks','otherReviewRemark')"/>
            </div>
        </div>
    </div>
    <div class="form-actions">
        &nbsp; &nbsp;&nbsp; <input id="btnSubmit"  type="submit" value="提 交"/>&nbsp;
    </div>
</form:form>
</body>
</html>