package com.thinkgem.jeesite.common.utils;

import net.sf.json.JSONArray;
import net.sf.json.JSONNull;
import net.sf.json.JSONObject;
import net.sf.json.JsonConfig;
import net.sf.json.processors.JsonValueProcessor;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;

public class JSONUtils {
    /**
     * 转换为json
     */
    public static String toJSON(Object o) {
        if (o instanceof List) {
            return JSONArray.fromObject(o).toString();
        } else {
            return JSONObject.fromObject(o).toString();
        }
    }

    public static JSONObject firstOrDefault(JSONArray r) {
        if (r.size() > 0) {
            return r.getJSONObject(0);
        }

        return null;
    }

    private static Integer _toInt(Object o, Integer def) {
        if (o == null) {
            return def;
        }

        if (o instanceof Integer) {
            return (Integer) o;
        }

        if (o instanceof String) {
            return Integer.parseInt((String) o);
        }

        if (o instanceof Long) {
            Long l = (Long) o;
            return l.intValue();
        }

        if (o instanceof Double) {
            Double d = (Double) o;
            return d.intValue();
        }

        if (o instanceof Boolean) {
            Boolean b = (Boolean) o;
            return b.booleanValue() ? 1 : 0;
        }

        return def;
    }

    private static Long _toLong(Object o, Long def) {
        if (o == null) {
            return def;
        }

        if (o instanceof Long) {
            return (Long) o;
        }

        if (o instanceof String) {
            return Long.parseLong((String) o);
        }

        if (o instanceof Integer) {
            Integer i = (Integer) o;
            return i.longValue();
        }

        if (o instanceof Double) {
            Double d = (Double) o;
            return d.longValue();
        }

        if (o instanceof Boolean) {
            Boolean b = (Boolean) o;
            return b.booleanValue() ? 1L : 0L;
        }

        return def;
    }

    private static Double _toDouble(Object o, Double def) {
        if (o == null) {
            return def;
        }

        if (o instanceof Double) {
            return (Double) o;
        }

        if (o instanceof String) {
            return Double.parseDouble((String) o);
        }

        if (o instanceof Integer) {
            Integer i = (Integer) o;
            return i.doubleValue();
        }

        if (o instanceof Long) {
            Long l = (Long) o;
            return l.doubleValue();
        }

        if (o instanceof Boolean) {
            Boolean b = (Boolean) o;
            return b.booleanValue() ? 1.0 : 0.0;
        }

        return def;
    }

    public static Integer tryGetInt(JSONObject json, String key) {
        Object o = json.get(key);

        return _toInt(o, null);
    }

    public static Integer tryGetInt(JSONObject json, String key, Integer defVal) {
        Object o = json.get(key);

        return _toInt(o, defVal);
    }

    public static Integer tryGetInt(JSONArray json, int index) {
        Object o = json.get(index);

        return _toInt(o, null);
    }

    public static Long tryGetLong(JSONObject json, String key) {
        Object o = json.get(key);

        return _toLong(o, null);
    }

    public static Long tryGetLong(JSONArray json, int index) {
        Object o = json.get(index);

        return _toLong(o, null);
    }

    public static Double tryGetDouble(JSONObject json, String key) {
        Object o = json.get(key);

        return _toDouble(o, null);
    }

    public static Double tryGetDouble(JSONArray json, int index) {
        Object o = json.get(index);

        return _toDouble(o, null);
    }

    public static String tryGetString(JSONObject json, String key) {
        Object o = json.get(key);
        if (o == null || o instanceof JSONNull) {
            return null;
        }

        return o.toString();
    }

    public static String tryGetString(JSONArray json, int index) {
        Object o = json.get(index);
        if (o == null || o instanceof JSONNull) {
            return null;
        }

        return o.toString();
    }

    public static Object tryGetObject(JSONObject json, String key) {
        Object o = json.get(key);
        if (o == null || o instanceof JSONNull) {
            return null;
        }

        return o;
    }

    public static Object tryGetObject(JSONArray json, int index) {
        Object o = json.get(index);
        if (o == null || o instanceof JSONNull) {
            return null;
        }

        return o;
    }

    public static JSONObject tryGetJSONObject(JSONObject json, String key) {
        Object o = json.get(key);
        if (o == null || o instanceof JSONNull) {
            return null;
        }

        return (JSONObject) o;
    }

    public static JSONObject tryGetJSONObject(JSONArray json, int index) {
        Object o = json.get(index);
        if (o == null || o instanceof JSONNull) {
            return null;
        }

        return (JSONObject) o;
    }

    public static JSONArray tryGetList(JSONObject json, String key) {
        Object o = json.get(key);
        if (o == null || o instanceof JSONNull) {
            return null;
        }

        return (JSONArray) o;
    }

    public static JSONArray tryGetList(JSONArray json, int index) {
        Object o = json.get(index);
        if (o == null || o instanceof JSONNull) {
            return null;
        }

        return (JSONArray) o;
    }

    public static List<JSONObject> arrCvt(JSONArray arr) {
        ArrayList<JSONObject> ls = new ArrayList<JSONObject>();
        for (int i = 0; i < arr.size(); ++i) {
            ls.add(arr.getJSONObject(i));
        }

        return ls;
    }

    public static JSONObject toJSONX(String key, Object val) {
        JSONObject jo = new JSONObject();
        jo.put(key, val);
        return jo;
    }

    public static Object convertObject(Object _data) {
        if (_data instanceof List) {
            List<?> l = (List<?>) _data;
            JSONArray arr = new JSONArray();
            for (Object o : l) {
                arr.add(convertObject(o));
            }

            return arr;
        } else {
            if (_data instanceof String || _data instanceof Long || _data instanceof Integer ||
                    _data instanceof Double || _data instanceof Boolean) {
                return _data;
            } else {
                JsonConfig jc = new JsonConfig();
                jc.registerJsonValueProcessor(Date.class, new JsonDateValueProcessor());
                // exclude null values.
//				jc.setJsonPropertyFilter(new PropertyFilter() { 
//					public boolean apply(Object source, String name, Object value)
//					{
//						return value == null;
//					}
//				});

                return JSONObject.fromObject(_data, jc);
            }
        }
    }

    public static class JsonDateValueProcessor implements JsonValueProcessor {
        private String format = "yyyy-MM-dd HH:mm:ss";

        public JsonDateValueProcessor() {
            super();
        }

        public JsonDateValueProcessor(String format) {
            super();
            this.format = format;
        }

        public Object processArrayValue(Object paramObject,
                                        JsonConfig paramJsonConfig) {
            return process(paramObject);
        }

        public Object processObjectValue(String paramString, Object paramObject,
                                         JsonConfig paramJsonConfig) {
            return process(paramObject);
        }


        private Object process(Object value) {
            if (value instanceof Date) {
                SimpleDateFormat sdf = new SimpleDateFormat(format, Locale.CHINA);
                return sdf.format(value);
            }
            return value == null ? "" : value.toString();
        }

    }
}
