package com.cab.passport.petstore.wx;

import com.google.common.collect.Maps;
import com.thinkgem.jeesite.common.utils.PropertiesLoader;
import com.thinkgem.jeesite.common.utils.StringUtils;

import java.util.Map;

public final class WechatConstant {

    private WechatConstant() {

    }

    private static PropertiesLoader loader = new PropertiesLoader("wechat.properties");

    /**
     * 保存全局属性值
     */
    private static Map<String, String> map = Maps.newHashMap();

    /**
     * @param key 参数名
     * @return 参数值
     * @description: 获取变量
     * @author: laiguanglong
     * @date: 2018/5/15 12:21
     */
    public static String getConfig(String key) {
        String value = map.get(key);
        if (value == null) {
            value = loader.getProperty(key);
            map.put(key, value != null ? value : StringUtils.EMPTY);
        }
        return value;
    }

    public static void putConfig(String key, String value) {
        map.put(key, value);
    }
}
