/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cab.passport.petstore.web;

import com.cab.passport.petstore.entity.PetStore;
import com.cab.passport.petstore.service.PetStoreService;
import com.thinkgem.jeesite.common.config.Global;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.web.BaseController;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * 宠物店Controller
 *
 * @author lgl
 * @version 2018-12-18
 */
@Controller
@RequestMapping(value = "${adminPath}/petStore")
public class PetStoreController extends BaseController {

    @Autowired
    private PetStoreService petStoreService;

    private static final String REPAGE = "redirect:" + Global.getAdminPath() + "/petStore/?repage";

    private static final String AUTHORITY_PRDFIX = "petStore:";

    @ModelAttribute
    public PetStore get(@RequestParam(required = false) String id) {
        PetStore entity = null;
        if (StringUtils.isNotBlank(id)) {
            entity = petStoreService.get(id);
        }
        if (entity == null) {
            entity = new PetStore();
        }
        return entity;
    }

    @RequiresPermissions(AUTHORITY_PRDFIX + "view")
    @RequestMapping(value = {"list", ""})
    public String list(PetStore petStore, HttpServletRequest request, HttpServletResponse response, Model model) {
        Page<PetStore> page = petStoreService.findPage(new Page<PetStore>(request, response), petStore);
        model.addAttribute("page", page);
        if(StringUtils.isNotBlank(petStore.getRefererCode())){
            model.addAttribute("refererCode", petStore.getRefererCode());
            model.addAttribute("refererName", petStore.getRefererName());
        }
        return "petStore/petStoreList";
    }

    @RequiresPermissions(AUTHORITY_PRDFIX + "view")
    @RequestMapping(value = "form")
    public String form(PetStore petStore, Model model) {
        if (StringUtils.isNotBlank(petStore.getMainProject())) {
            petStoreService.setMainProject(petStore);
        }
        petStoreService.setStatisticsInfo(petStore);
        model.addAttribute("petStore", petStore);
        return "petStore/petStoreForm";
    }

    @RequiresPermissions(AUTHORITY_PRDFIX + "view")
    @RequestMapping(value = "save")
    public String save(PetStore petStore, Model model, RedirectAttributes redirectAttributes) {
        petStoreService.edit(petStore);
        addMessage(redirectAttributes, "保存宠物店成功");
        return REPAGE;
    }

    @RequiresPermissions(AUTHORITY_PRDFIX + "edit")
    @RequestMapping(value = "delete")
    public String delete(PetStore petStore, RedirectAttributes redirectAttributes) {
        petStoreService.delete(petStore);
        addMessage(redirectAttributes, "删除宠物店成功");
        return REPAGE;
    }

    @RequestMapping(value = "exportExcel")
    public void exportExcel(PetStore petStore, HttpServletResponse response, RedirectAttributes redirectAttributes) {
        try {
            petStoreService.exportExcel(petStore, response);
        } catch (Exception e) {
            addMessage(redirectAttributes, "导出信息失败！失败信息：" + e.getMessage());
        }
    }
}