/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cab.passport.embedchipclub.web;

import com.cab.passport.embedchipclub.entity.EmbedChipClub;
import com.cab.passport.embedchipclub.service.EmbedChipClubService;
import com.thinkgem.jeesite.common.config.Global;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.utils.StringUtils;
import com.thinkgem.jeesite.common.web.BaseController;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * 埋置芯片俱乐部Controller
 *
 * @author lgl
 * @version 2018-10-31
 */
@Controller
@RequestMapping(value = "${adminPath}/embedchipclub/embedChipClub")
public class EmbedChipClubController extends BaseController {

    @Autowired
    private EmbedChipClubService embedChipClubService;

    @ModelAttribute
    public EmbedChipClub get(@RequestParam(required = false) String id) {
        EmbedChipClub entity = null;
        if (StringUtils.isNotBlank(id)) {
            entity = embedChipClubService.get(id);
        }
        if (entity == null) {
            entity = new EmbedChipClub();
        }
        return entity;
    }

    @RequiresPermissions("embedchipclub:embedChipClub:view")
    @RequestMapping(value = {"list", ""})
    public String list(EmbedChipClub embedChipClub, HttpServletRequest request, HttpServletResponse response, Model model) {
        Page<EmbedChipClub> page = embedChipClubService.findPage(new Page<EmbedChipClub>(request, response), embedChipClub);
        model.addAttribute("page", page);
        return "passport/embedchipclub/embedChipClubList";
    }

    @RequiresPermissions("embedchipclub:embedChipClub:view")
    @RequestMapping(value = "form")
    public String form(EmbedChipClub embedChipClub, Model model) {
        model.addAttribute("embedChipClub", embedChipClub);
        return "passport/embedchipclub/embedChipClubForm";
    }

    @RequiresPermissions("embedchipclub:embedChipClub:edit")
    @RequestMapping(value = "save")
    public String save(EmbedChipClub embedChipClub, Model model, RedirectAttributes redirectAttributes) {
        if (!beanValidator(model, embedChipClub)) {
            return form(embedChipClub, model);
        }
        embedChipClubService.save(embedChipClub);
        addMessage(redirectAttributes, "保存埋置芯片俱乐部成功");
        return "redirect:" + Global.getAdminPath() + "/embedchipclub/embedChipClub/?repage";
    }

    @RequiresPermissions("embedchipclub:embedChipClub:edit")
    @RequestMapping(value = "delete")
    public String delete(EmbedChipClub embedChipClub, RedirectAttributes redirectAttributes) {
        embedChipClubService.delete(embedChipClub);
        addMessage(redirectAttributes, "删除埋置芯片俱乐部成功");
        return "redirect:" + Global.getAdminPath() + "/embedchipclub/embedChipClub/?repage";
    }

}