/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cab.passport.sys.payment.web;

import com.cab.passport.sys.payment.dao.PaymentOrderDetailDao;
import com.cab.passport.sys.payment.entity.PaymentOrder;
import com.cab.passport.sys.payment.service.PaymentOrderService;
import com.thinkgem.jeesite.common.utils.StringUtils;
import com.thinkgem.jeesite.common.web.BaseController;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * 订单Controller
 *
 * @author lyy
 * @version 2016-08-04
 */
@Controller
@RequestMapping(value = "${adminPath}/finance/paymentOrder")
public class PaymentOrderController extends BaseController {

	@Autowired
	private PaymentOrderService paymentOrderService;
	@Autowired
	private PaymentOrderDetailDao paymentOrderDetailDao;

	@ModelAttribute
	public PaymentOrder get(@RequestParam(required = false) String id,
							@RequestParam(required = false) String orderCode) {
		PaymentOrder entity = null;
		if (StringUtils.isNotBlank(id) || StringUtils.isNotBlank(orderCode)) {
			entity = paymentOrderService.get(id, orderCode);
		}
		if (entity == null) {
			entity = new PaymentOrder();
		}
		return entity;
	}


}