/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.validation.validator.impl;

import java.util.List;
import org.activiti.bpmn.model.BaseElement;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.Process;
import org.activiti.bpmn.model.SequenceFlow;
import org.activiti.validation.ValidationError;
import org.activiti.validation.validator.ProcessLevelValidator;
import org.apache.commons.lang3.StringUtils;

public class SequenceflowValidator
extends ProcessLevelValidator {
    @Override
    protected void executeValidation(BpmnModel bpmnModel, Process process, List<ValidationError> errors) {
        List sequenceFlows = process.findFlowElementsOfType(SequenceFlow.class);
        for (SequenceFlow sequenceFlow : sequenceFlows) {
            String sourceRef = sequenceFlow.getSourceRef();
            String targetRef = sequenceFlow.getTargetRef();
            if (StringUtils.isEmpty((CharSequence)sourceRef)) {
                this.addError(errors, "activiti-seq-flow-invalid-src", process, (BaseElement)sequenceFlow, "Invalid source for sequenceflow");
            }
            if (StringUtils.isEmpty((CharSequence)targetRef)) {
                this.addError(errors, "activiti-seq-flow-invalid-target", process, (BaseElement)sequenceFlow, "Invalid target for sequenceflow");
            }
            FlowElement source = process.getFlowElementRecursive(sourceRef);
            FlowElement target = process.getFlowElementRecursive(targetRef);
            if (source == null) {
                this.addError(errors, "activiti-seq-flow-invalid-src", process, (BaseElement)sequenceFlow, "Invalid source for sequenceflow");
            }
            if (target != null) continue;
            this.addError(errors, "activiti-seq-flow-invalid-target", process, (BaseElement)sequenceFlow, "Invalid target for sequenceflow");
        }
    }
}

