/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlgraphics.xmp;

import org.apache.xmlgraphics.util.QName;
import org.apache.xmlgraphics.util.XMLizable;
import org.apache.xmlgraphics.xmp.XMPArray;
import org.apache.xmlgraphics.xmp.XMPArrayType;
import org.apache.xmlgraphics.xmp.XMPComplexValue;
import org.apache.xmlgraphics.xmp.XMPSchema;
import org.apache.xmlgraphics.xmp.XMPSchemaRegistry;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class XMPProperty
implements XMLizable {
    private QName name;
    private Object value;
    private String xmllang;

    public XMPProperty(QName name, Object value) {
        this.name = name;
        this.value = value;
    }

    public QName getName() {
        return this.name;
    }

    public String getNamespace() {
        return this.getName().getNamespaceURI();
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public Object getValue() {
        return this.value;
    }

    public void setXMLLang(String lang) {
        this.xmllang = lang;
    }

    public String getXMLLang() {
        return this.xmllang;
    }

    public XMPArray getArrayValue() {
        return this.value instanceof XMPArray ? (XMPArray)this.value : null;
    }

    public void convertSimpleValueToArray(XMPArrayType type) {
        if (this.getArrayValue() == null) {
            XMPArray array = new XMPArray(type);
            if (this.getXMLLang() != null) {
                array.add(this.getValue().toString(), this.getXMLLang());
            } else {
                array.add(this.getValue());
            }
            this.setValue(array);
            this.setXMLLang(null);
        }
    }

    private String getEffectiveQName() {
        String prefix = this.getName().getPrefix();
        if (prefix == null || "".equals(prefix)) {
            XMPSchema schema = XMPSchemaRegistry.getInstance().getSchema(this.getNamespace());
            prefix = schema.getPreferredPrefix();
        }
        return prefix + ":" + this.getName().getLocalName();
    }

    public void toSAX(ContentHandler handler) throws SAXException {
        AttributesImpl atts = new AttributesImpl();
        String qName = this.getEffectiveQName();
        handler.startElement(this.getName().getNamespaceURI(), this.getName().getLocalName(), qName, atts);
        if (this.value instanceof XMPComplexValue) {
            XMPComplexValue cv = (XMPComplexValue)this.value;
            Object obj = cv.getSimpleValue();
            if (obj != null) {
                char[] chars = obj.toString().toCharArray();
                handler.characters(chars, 0, chars.length);
            } else {
                cv.toSAX(handler);
            }
        } else {
            char[] chars = this.value.toString().toCharArray();
            handler.characters(chars, 0, chars.length);
        }
        handler.endElement(this.getName().getNamespaceURI(), this.getName().getLocalName(), qName);
    }
}

