/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.editor.language.json.converter;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.activiti.bpmn.model.BaseElement;
import org.activiti.bpmn.model.CallActivity;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.IOParameter;
import org.activiti.editor.language.json.converter.BaseBpmnJsonConverter;
import org.apache.commons.lang3.StringUtils;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.node.ArrayNode;
import org.codehaus.jackson.node.ObjectNode;

public class CallActivityJsonConverter
extends BaseBpmnJsonConverter {
    public static void fillTypes(Map<String, Class<? extends BaseBpmnJsonConverter>> convertersToBpmnMap, Map<Class<? extends BaseElement>, Class<? extends BaseBpmnJsonConverter>> convertersToJsonMap) {
        CallActivityJsonConverter.fillJsonTypes(convertersToBpmnMap);
        CallActivityJsonConverter.fillBpmnTypes(convertersToJsonMap);
    }

    public static void fillJsonTypes(Map<String, Class<? extends BaseBpmnJsonConverter>> convertersToBpmnMap) {
        convertersToBpmnMap.put("CallActivity", CallActivityJsonConverter.class);
    }

    public static void fillBpmnTypes(Map<Class<? extends BaseElement>, Class<? extends BaseBpmnJsonConverter>> convertersToJsonMap) {
        convertersToJsonMap.put(CallActivity.class, CallActivityJsonConverter.class);
    }

    @Override
    protected String getStencilId(FlowElement flowElement) {
        return "CallActivity";
    }

    @Override
    protected void convertElementToJson(ObjectNode propertiesNode, FlowElement flowElement) {
        CallActivity callActivity = (CallActivity)flowElement;
        if (StringUtils.isNotEmpty((CharSequence)callActivity.getCalledElement())) {
            propertiesNode.put("callactivitycalledelement", callActivity.getCalledElement());
        }
        this.addJsonParameters("callactivityinparameters", callActivity.getInParameters(), propertiesNode);
        this.addJsonParameters("callactivityoutparameters", callActivity.getOutParameters(), propertiesNode);
    }

    private void addJsonParameters(String propertyName, List<IOParameter> parameterList, ObjectNode propertiesNode) {
        ObjectNode parametersNode = this.objectMapper.createObjectNode();
        ArrayNode itemsNode = this.objectMapper.createArrayNode();
        for (IOParameter parameter : parameterList) {
            ObjectNode parameterItemNode = this.objectMapper.createObjectNode();
            if (StringUtils.isNotEmpty((CharSequence)parameter.getSource())) {
                parameterItemNode.put("ioparameter_source", parameter.getSource());
            } else {
                parameterItemNode.putNull("ioparameter_source");
            }
            if (StringUtils.isNotEmpty((CharSequence)parameter.getTarget())) {
                parameterItemNode.put("ioparameter_target", parameter.getTarget());
            } else {
                parameterItemNode.putNull("ioparameter_target");
            }
            if (StringUtils.isNotEmpty((CharSequence)parameter.getSourceExpression())) {
                parameterItemNode.put("ioparameter_sourceexpression", parameter.getSourceExpression());
            } else {
                parameterItemNode.putNull("ioparameter_sourceexpression");
            }
            itemsNode.add((JsonNode)parameterItemNode);
        }
        parametersNode.put("totalCount", itemsNode.size());
        parametersNode.put("items", (JsonNode)itemsNode);
        propertiesNode.put(propertyName, (JsonNode)parametersNode);
    }

    @Override
    protected FlowElement convertJsonToElement(JsonNode elementNode, JsonNode modelNode, Map<String, JsonNode> shapeMap) {
        CallActivity callActivity = new CallActivity();
        if (StringUtils.isNotEmpty((CharSequence)this.getPropertyValueAsString("callactivitycalledelement", elementNode))) {
            callActivity.setCalledElement(this.getPropertyValueAsString("callactivitycalledelement", elementNode));
        }
        callActivity.getInParameters().addAll(this.convertToIOParameters("callactivityinparameters", elementNode));
        callActivity.getOutParameters().addAll(this.convertToIOParameters("callactivityoutparameters", elementNode));
        return callActivity;
    }

    private List<IOParameter> convertToIOParameters(String propertyName, JsonNode elementNode) {
        JsonNode itemsArrayNode;
        ArrayList<IOParameter> ioParameters = new ArrayList<IOParameter>();
        JsonNode parametersNode = this.getProperty(propertyName, elementNode);
        if (parametersNode != null && (itemsArrayNode = parametersNode.get("items")) != null) {
            for (JsonNode itemNode : itemsArrayNode) {
                JsonNode sourceNode = itemNode.get("ioparameter_source");
                JsonNode sourceExpressionNode = itemNode.get("ioparameter_sourceexpression");
                if ((sourceNode == null || !StringUtils.isNotEmpty((CharSequence)sourceNode.asText())) && (sourceExpressionNode == null || !StringUtils.isNotEmpty((CharSequence)sourceExpressionNode.asText()))) continue;
                IOParameter parameter = new IOParameter();
                if (StringUtils.isNotEmpty((CharSequence)this.getValueAsString("ioparameter_source", itemNode))) {
                    parameter.setSource(this.getValueAsString("ioparameter_source", itemNode));
                }
                if (StringUtils.isNotEmpty((CharSequence)this.getValueAsString("ioparameter_sourceexpression", itemNode))) {
                    parameter.setSourceExpression(this.getValueAsString("ioparameter_sourceexpression", itemNode));
                }
                if (StringUtils.isNotEmpty((CharSequence)this.getValueAsString("ioparameter_target", itemNode))) {
                    parameter.setTarget(this.getValueAsString("ioparameter_target", itemNode));
                }
                ioParameters.add(parameter);
            }
        }
        return ioParameters;
    }
}

