/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.editor.language.json.converter;

import java.util.List;
import java.util.Map;
import org.activiti.bpmn.model.BaseElement;
import org.activiti.bpmn.model.BoundaryEvent;
import org.activiti.bpmn.model.ErrorEventDefinition;
import org.activiti.bpmn.model.Event;
import org.activiti.bpmn.model.EventDefinition;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.GraphicInfo;
import org.activiti.bpmn.model.SignalEventDefinition;
import org.activiti.editor.language.json.converter.BaseBpmnJsonConverter;
import org.activiti.editor.language.json.converter.BpmnJsonConverterUtil;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.node.ArrayNode;
import org.codehaus.jackson.node.ObjectNode;

public class BoundaryEventJsonConverter
extends BaseBpmnJsonConverter {
    public static void fillTypes(Map<String, Class<? extends BaseBpmnJsonConverter>> convertersToBpmnMap, Map<Class<? extends BaseElement>, Class<? extends BaseBpmnJsonConverter>> convertersToJsonMap) {
        BoundaryEventJsonConverter.fillJsonTypes(convertersToBpmnMap);
        BoundaryEventJsonConverter.fillBpmnTypes(convertersToJsonMap);
    }

    public static void fillJsonTypes(Map<String, Class<? extends BaseBpmnJsonConverter>> convertersToBpmnMap) {
        convertersToBpmnMap.put("BoundaryTimerEvent", BoundaryEventJsonConverter.class);
        convertersToBpmnMap.put("BoundaryErrorEvent", BoundaryEventJsonConverter.class);
        convertersToBpmnMap.put("BoundarySignalEvent", BoundaryEventJsonConverter.class);
    }

    public static void fillBpmnTypes(Map<Class<? extends BaseElement>, Class<? extends BaseBpmnJsonConverter>> convertersToJsonMap) {
        convertersToJsonMap.put(BoundaryEvent.class, BoundaryEventJsonConverter.class);
    }

    @Override
    protected String getStencilId(FlowElement flowElement) {
        BoundaryEvent boundaryEvent = (BoundaryEvent)flowElement;
        List eventDefinitions = boundaryEvent.getEventDefinitions();
        if (eventDefinitions.size() != 1) {
            return "BoundaryTimerEvent";
        }
        EventDefinition eventDefinition = (EventDefinition)eventDefinitions.get(0);
        if (eventDefinition instanceof ErrorEventDefinition) {
            return "BoundaryErrorEvent";
        }
        if (eventDefinition instanceof SignalEventDefinition) {
            return "BoundarySignalEvent";
        }
        return "BoundaryTimerEvent";
    }

    @Override
    protected void convertElementToJson(ObjectNode propertiesNode, FlowElement flowElement) {
        BoundaryEvent boundaryEvent = (BoundaryEvent)flowElement;
        ArrayNode dockersArrayNode = this.objectMapper.createArrayNode();
        ObjectNode dockNode = this.objectMapper.createObjectNode();
        GraphicInfo graphicInfo = this.model.getGraphicInfo(boundaryEvent.getId());
        GraphicInfo parentGraphicInfo = this.model.getGraphicInfo(boundaryEvent.getAttachedToRef().getId());
        dockNode.put("x", graphicInfo.getX() + graphicInfo.getWidth() - parentGraphicInfo.getX());
        dockNode.put("y", graphicInfo.getY() - parentGraphicInfo.getY());
        dockersArrayNode.add((JsonNode)dockNode);
        this.flowElementNode.put("dockers", (JsonNode)dockersArrayNode);
        if (!boundaryEvent.isCancelActivity()) {
            propertiesNode.put("cancelactivity", "No");
        }
        this.addEventProperties((Event)boundaryEvent, propertiesNode);
    }

    @Override
    protected FlowElement convertJsonToElement(JsonNode elementNode, JsonNode modelNode, Map<String, JsonNode> shapeMap) {
        BoundaryEvent boundaryEvent = new BoundaryEvent();
        String stencilId = BpmnJsonConverterUtil.getStencilId(elementNode);
        if ("BoundaryTimerEvent".equals(stencilId)) {
            boundaryEvent.setCancelActivity(this.getPropertyValueAsBoolean("cancelactivity", elementNode));
            this.convertJsonToTimerDefinition(elementNode, (Event)boundaryEvent);
        } else if ("BoundaryErrorEvent".equals(stencilId)) {
            this.convertJsonToErrorDefinition(elementNode, (Event)boundaryEvent);
        } else if ("BoundarySignalEvent".equals(stencilId)) {
            boundaryEvent.setCancelActivity(this.getPropertyValueAsBoolean("cancelactivity", elementNode));
            this.convertJsonToSignalDefinition(elementNode, (Event)boundaryEvent);
        }
        boundaryEvent.setAttachedToRefId(this.lookForAttachedRef(elementNode.get("resourceId").asText(), modelNode.get("childShapes")));
        return boundaryEvent;
    }

    private String lookForAttachedRef(String boundaryEventId, JsonNode childShapesNode) {
        String attachedRefId = null;
        if (childShapesNode != null) {
            for (JsonNode childNode : childShapesNode) {
                ArrayNode outgoingNode = (ArrayNode)childNode.get("outgoing");
                if (outgoingNode != null && outgoingNode.size() > 0) {
                    for (JsonNode outgoingChildNode : outgoingNode) {
                        JsonNode resourceNode = outgoingChildNode.get("resourceId");
                        if (resourceNode == null || !boundaryEventId.equals(resourceNode.asText())) continue;
                        attachedRefId = BpmnJsonConverterUtil.getElementId(childNode);
                        break;
                    }
                    if (attachedRefId != null) break;
                }
                if ((attachedRefId = this.lookForAttachedRef(boundaryEventId, childNode.get("childShapes"))) == null) continue;
                break;
            }
        }
        return attachedRefId;
    }
}

