<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp" %>
<html>
<head>
    <title>宠物店管理</title>
    <meta name="decorator" content="default"/>
    <script type="text/javascript">
        $(document).ready(function () {

        });
        function page(n, s) {
            $("#pageNo").val(n);
            $("#pageSize").val(s);
            $("#searchForm").submit();
            return false;
        }
        function excelAdd() {
            if(${page.count==0}){
                alert("查询结果为空，无法导出");
                return;
            }
            var ss="${refererCode}";
            var parameter = "petStore.petStoreOwnerNameLike=" + $("#petStoreOwnerNameLike").val()
                    + "&petStore.petStoreOwnerMobileLike=" + $("#petStoreOwnerMobileLike").val()
                    + "&petStore.petStoreNameLike=" + $("#petStoreNameLike").val()
                    + "&petStore.petStoreCityLike=" + $("#petStoreCityLike").val()
                    + "&petStore.activationTimeStart=" + $("#activationTimeStart").val()
                    + "&petStore.activationTimeEnd=" + $("#activationTimeEnd").val()
                    +"petStore.refererCode="+ss;
            $("#searchForm").attr("action", "${ctx}/petStore/exportExcel?" + parameter);
            $("#searchForm").submit();
            $("#searchForm").attr("action", "${ctx}/petStore/");
        }
    </script>
</head>
<body>
<ul class="nav nav-tabs">
    <c:if test="${empty refererCode }">
        <li class="active"><a href="${ctx}/petStore/">用户列表</a></li>
    </c:if>
    <c:if test="${not empty refererCode }">
        <li class="active"><a href="${ctx}/referrer/referrer/">推荐人列表</a></li>
        <li class="active"><a href="${ctx}/petStore/list?refererCode=${refererCode}&refererName=${refererName}">${refererName}:${refererCode}</a></li>
    </c:if>
</ul>
<form:form id="searchForm" modelAttribute="petStore" action="${ctx}/petStore/" method="post"
           class="breadcrumb form-search">
    <input id="pageNo" name="pageNo" type="hidden" value="${page.pageNo}"/>
    <input id="pageSize" name="pageSize" type="hidden" value="${page.pageSize}"/>
    <ul class="ul-form">
        <li><label>用户名：</label>
            <form:input path="petStoreOwnerNameLike" htmlEscape="false" maxlength="20" class="input-medium"/>
        </li>
        <li><label>手机号：</label>
            <form:input path="petStoreOwnerMobileLike" htmlEscape="false" maxlength="20" class="input-medium"/>
        </li>
        <li><label>宠物店名称：</label>
            <form:input path="petStoreNameLike" htmlEscape="false" maxlength="100" class="input-medium"/>
        </li>
        <li><label>所在地：</label>
            <form:input path="petStoreCityLike" htmlEscape="false" maxlength="50" class="input-medium"/>
        </li>
        <li><label>激活码：</label>
            <form:input path="inviteCodeLike" htmlEscape="false" maxlength="50" class="input-medium"/>
        </li>
            <form:hidden  path="refererCode" value="${refererCode}"/>
        <li><label>注册时间：</label>
            <input id="activationTimeStart" name="activationTimeStart" type="text" readonly="readonly" maxlength="20"
                   class="input-medium Wdate"
                   value="<fmt:formatDate value="${petStore.activationTimeStart}" pattern="yyyy-MM-dd"/>"
                   onclick="WdatePicker({dateFmt:'yyyy-MM-dd',isShowClear:true});"/> -
            <input id="activationTimeEnd" name="activationTimeEnd" type="text" readonly="readonly" maxlength="20"
                   class="input-medium Wdate"
                   value="<fmt:formatDate value="${petStore.activationTimeEnd}" pattern="yyyy-MM-dd"/>"
                   onclick="WdatePicker({dateFmt:'yyyy-MM-dd',isShowClear:true});"/>
        </li>

        <li class="btns"><input id="btnSubmit" class="btn btn-primary" type="submit" value="查询"/></li>
        <li class="btns"><input id="excel_btn" class="btn btn-primary" type="button" value="导出" onclick="excelAdd()"/>
        </li>
        <li class="clearfix"></li>
    </ul>
</form:form>
<sys:message content="${message}"/>
<table id="contentTable" class="table table-striped table-bordered table-condensed">
    <thead>
    <tr>
        <th>用户名</th>
        <th>手机号</th>
        <th>宠物店名称</th>
        <th>所在地</th>
        <th>激活码</th>
        <th>微信</th>
        <th>推荐人编码</th>
        <th>注册时间</th>
        <th>管理</th>
    </tr>
    </thead>
    <tbody>
    <c:forEach items="${page.list}" var="petStore">
        <tr>
            <td>
                    ${petStore.petStoreOwnerName}
            </td>
            <td>
                    ${petStore.petStoreOwnerMobile}
            </td>
            <td>
                    ${petStore.petStoreName}
            </td>
            <td>
                    ${petStore.petStoreCity}
            </td>
            <td>
                    ${petStore.inviteCode}
            </td>
            <td>
                    ${petStore.wxOpenId}
            </td>
            <td>
                    ${petStore.refererCode}
            </td>
            <td>
                <fmt:formatDate value="${petStore.activationTime}" pattern="yyyy-MM-dd HH:mm:ss"/>
            </td>
            <td>
                <a href="${ctx}/petStore/form?id=${petStore.id}">查看</a>
            </td>
        </tr>
    </c:forEach>
    </tbody>
</table>
<div class="pagination">${page}</div>
</body>
</html>