package com.cab.passport.passportorder.web;

import com.cab.passport.passportorder.dao.CompanionDogAppraisalDao;
import com.cab.passport.passportorder.entity.CompanionDogAppraisal;
import com.cab.passport.passportorder.service.CompanionDogAppraisalService;
import com.thinkgem.jeesite.common.config.Global;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.utils.StringUtils;
import com.thinkgem.jeesite.common.utils.ZAException;
import com.thinkgem.jeesite.common.web.BaseController;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * 伴侣级鉴定Controller
 *
 * @author pp
 * @version 2019-07-04
 */
@Controller
@RequestMapping(value = "${adminPath}/passportOrder/companionDogAppraisal")
public class CompanionDogAppraisalController extends BaseController {

    @Autowired
    private CompanionDogAppraisalService companionDogAppraisalService;
    @Autowired
    private CompanionDogAppraisalDao companionDogAppraisalDao;

    private static final String REPAGE = "redirect:" + Global.getAdminPath() + "/passportOrder/companionDogAppraisal";


    @ModelAttribute
    public CompanionDogAppraisal get(@RequestParam(required = false) String id) {
        CompanionDogAppraisal entity = null;
        if (StringUtils.isNotBlank(id)) {
            entity = companionDogAppraisalService.get(id);
        }
        if (entity == null) {
            entity = new CompanionDogAppraisal();
        }
        return entity;
    }


    @RequiresPermissions("passportOrder:companionDogAppraisal:view")
    @RequestMapping(value = {"list", ""})
    public String list(CompanionDogAppraisal companionDogAppraisal, HttpServletRequest request, HttpServletResponse response, Model model) {
        Page<CompanionDogAppraisal> page = companionDogAppraisalService.findPage(new Page<CompanionDogAppraisal>(request, response), companionDogAppraisal);
        model.addAttribute("page", page);
        return "passportOrder/companionDogAppraisalList";
    }
//    @RequiresPermissions("passportOrder:companionDogAppraisal:view")
//
//    @RequestMapping(value = "form")
//    public String form(CompanionDogAppraisal companionDogAppraisal, Model model) {
//        companionDogAppraisalService.getCatClorMark();
//        Map<String, String> lstColor = new HashMap<>();
//        if ("0".equals(companionDogAppraisal.getPetType()))
//            lstColor = companionDogAppraisalService.getDogClorMark();
//        if ("1".equals(companionDogAppraisal.getPetType()))
//            lstColor = companionDogAppraisalService.getCatClorMark();
//        if (StringUtils.isNotEmpty(companionDogAppraisal.getPetColor())) {
//            if (!lstColor.containsKey(companionDogAppraisal.getPetColor())) {
//                companionDogAppraisal.setPetColorO(companionDogAppraisal.getPetColor());
//                companionDogAppraisal.setPetColor("0");
//            }
//        }
//        companionDogAppraisal.setOrgId(org.getId());
//        companionDogAppraisal.setAppraisalProvince(org.getProvince());
//        companionDogAppraisal.setAppraisalCity(org.getCity());
//        companionDogAppraisal.setAppraisalShop(org.getName());
//        model.addAttribute("companionDogAppraisal", companionDogAppraisal);
//        model.addAttribute("postalProvince", UserUtils.getProvince());
//        model.addAttribute("postalCity", UserUtils.getCityByProvince(companionDogAppraisal.getPostalProvince()));
//        model.addAttribute("petColor", lstColor);
//        return "partner/club/companionDogAppraisalForm";
//    }

    /**
     * 身份贴纸打印
     *
     * @param companionDogAppraisal
     * @param redirectAttributes
     * @return
     */
    @RequiresPermissions("passportOrder:companionDogAppraisal:print")
    @RequestMapping(value = "identityPrint")
    public String identityPrint(CompanionDogAppraisal companionDogAppraisal, RedirectAttributes redirectAttributes) {
        try {
            return companionDogAppraisalService.identityPrint(companionDogAppraisal.getId());

        } catch (ZAException e) {
            logger.warn("打印出错", e);
            addMessage(redirectAttributes, "打印出错:" + e.getMessage());
            return "redirect:/passportOrder/companionDogAppraisal/?repage";
        }
    }

    /**
     * 等级贴纸打印
     *
     * @param companionDogAppraisal
     * @param redirectAttributes
     * @return
     */
    @RequiresPermissions("passportOrder:companionDogAppraisal:print")
    @RequestMapping(value = "gradePrint")
    public String gradePrint(CompanionDogAppraisal companionDogAppraisal, RedirectAttributes redirectAttributes) {
        try {
            return companionDogAppraisalService.gradePrint(companionDogAppraisal.getId());
        } catch (ZAException e) {
            logger.warn("打印出错", e);
            addMessage(redirectAttributes, "打印出错:" + e.getMessage());
            return "redirect:/passportOrder/companionDogAppraisal/?repage";
        }
    }
    @RequiresPermissions("passportOrder:companionDogAppraisal:print")
    @RequestMapping(value = "restIdentityPrint")
    public String restIdentityPrint(CompanionDogAppraisal companionDogAppraisal, RedirectAttributes redirectAttributes) {
        companionDogAppraisalService.restIdentityPrint(companionDogAppraisal.getId());
        addMessage(redirectAttributes, "打印重置成功");
        return REPAGE + "?repage";

    }
    @RequiresPermissions("passportOrder:companionDogAppraisal:print")
    @RequestMapping(value = "restGradePrint")
    public String restGradePrint(CompanionDogAppraisal companionDogAppraisal, RedirectAttributes redirectAttributes) {
        companionDogAppraisalService.restGradePrint(companionDogAppraisal.getId());
        addMessage(redirectAttributes, "打印重置成功");
        return REPAGE + "?repage";    }

}