/*
 * Decompiled with CFR 0.152.
 */
package com.chongaibao.cabpub.sdk.signature;

import com.alibaba.fastjson.JSONObject;
import com.chongaibao.cabpub.sdk.common.ProtocolParameterEnum;
import com.chongaibao.cabpub.sdk.signature.StreamUtils;
import com.chongaibao.cabpub.sdk.signature.StringUtils;
import com.chongaibao.cabpub.sdk.signature.codec.Base64;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.crypto.Cipher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SignatureUtils {
    public static String encryptAndSign(String bizContent, String publicKey, String privateKey, String charset, boolean isEncrypt, boolean isSign) throws Exception {
        StringBuilder sb = new StringBuilder();
        if (StringUtils.isBlank(charset)) {
            charset = "GBK";
        }
        if (isEncrypt) {
            String sign = SignatureUtils.rsaEncrypt(bizContent, publicKey, charset);
            sb.append("bizContent=").append(sign);
            if (isSign) {
                String sign1 = SignatureUtils.rsaSign(sign, privateKey, charset);
                sb.append("&sign=").append(sign1);
            }
        } else if (isSign) {
            sb.append("bizConent=").append(bizContent);
            String sign = SignatureUtils.rsaSign(bizContent, privateKey, charset);
            sb.append("&sign=").append(sign);
        }
        return sb.toString();
    }

    public static Map<String, Object> encryptAndSign(Map<String, Object> map, String publicKey, String privateKey, String charset, boolean isEncrypt, boolean isSign) throws Exception {
        String sign2;
        Set<String> keySet = map.keySet();
        HashMap<String, Object> businessParamMap = new HashMap<String, Object>();
        HashMap<String, Object> newMap = new HashMap<String, Object>();
        List<String> codeList = ProtocolParameterEnum.getCodeList();
        for (String sign2 : keySet) {
            if (!codeList.contains(sign2)) {
                businessParamMap.put(sign2, map.get(sign2));
                continue;
            }
            newMap.put(sign2, map.get(sign2));
        }
        if (StringUtils.isBlank(charset)) {
            charset = "UTF-8";
        }
        if (isEncrypt) {
            sign2 = SignatureUtils.rsaEncrypt(businessParamMap, publicKey, charset);
            newMap.put(ProtocolParameterEnum.BIZ_CONTENT.getCode(), sign2);
            if (isSign) {
                String sign2 = SignatureUtils.rsaSign(newMap, privateKey, charset);
                newMap.put(ProtocolParameterEnum.SIGN.getCode(), sign2);
            }
        } else if (isSign) {
            newMap.put(ProtocolParameterEnum.BIZ_CONTENT.getCode(), SignatureUtils.getSignContent(businessParamMap));
            sign2 = SignatureUtils.rsaSign(newMap, privateKey, charset);
            newMap.put(ProtocolParameterEnum.SIGN.getCode(), sign2);
        }
        return newMap;
    }

    public static String checkSignAndDecrypt(Map<String, Object> params, String publicKey, String privateKey, boolean isCheckSign, boolean isDecrypt) throws Exception {
        String bizContent = (String)params.get(ProtocolParameterEnum.BIZ_CONTENT.getCode());
        String sign = (String)params.get(ProtocolParameterEnum.SIGN.getCode());
        params.remove(ProtocolParameterEnum.SIGN.getCode());
        params.remove("errorCode");
        params.remove("errorMsg");
        String content = SignatureUtils.getSignContent(params);
        System.out.println("\u7b7e\u540d\u5b57\u7b26\u4e32\u662f\uff1a" + content);
        String charset = (String)params.get(ProtocolParameterEnum.CHARSET.getCode());
        if (StringUtils.isBlank(charset)) {
            charset = "UTF-8";
        }
        if (isCheckSign) {
            SignatureUtils.checkRSASign(sign, content, publicKey, charset);
        }
        return isDecrypt ? SignatureUtils.rsaDecrypt(bizContent, privateKey, charset) : bizContent;
    }

    public static String rsaEncrypt(Map<String, Object> map, String publicKey, String charset) throws Exception {
        String bizContent = SignatureUtils.getSignContent(map);
        System.out.println("\u5f85\u52a0\u5bc6\u7684\u5b57\u7b26\u521b\uff1a" + bizContent);
        return SignatureUtils.rsaEncrypt(bizContent, publicKey, charset);
    }

    public static String rsaEncrypt(String content, String publicKey, String charset) throws Exception {
        PublicKey pubKey = SignatureUtils.getPublicKeyFromX509("RSA", new ByteArrayInputStream(publicKey.getBytes()));
        Cipher cipher = Cipher.getInstance("RSA/ECB/PKCS1Padding");
        cipher.init(1, pubKey);
        byte[] data = StringUtils.isBlank(charset) ? content.getBytes() : content.getBytes(charset);
        int inputLen = data.length;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        int offSet = 0;
        int i = 0;
        while (inputLen - offSet > 0) {
            byte[] cache = inputLen - offSet > 117 ? cipher.doFinal(data, offSet, 117) : cipher.doFinal(data, offSet, inputLen - offSet);
            out.write(cache, 0, cache.length);
            offSet = ++i * 117;
        }
        byte[] encryptedData = Base64.encodeBase64(out.toByteArray());
        out.close();
        return StringUtils.isBlank(charset) ? new String(encryptedData) : new String(encryptedData, charset);
    }

    public static String rsaDecrypt(String content, String privateKey, String charset) throws Exception {
        try {
            PrivateKey e = SignatureUtils.getPrivateKeyFromPKCS8("RSA", new ByteArrayInputStream(privateKey.getBytes()));
            Cipher cipher = Cipher.getInstance("RSA/ECB/PKCS1Padding");
            cipher.init(2, e);
            byte[] encryptedData = StringUtils.isBlank(charset) ? Base64.decodeBase64(content.getBytes()) : Base64.decodeBase64(content.getBytes(charset));
            int inputLen = encryptedData.length;
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            int offSet = 0;
            int i = 0;
            int maxDecryptBlock = 128;
            if (privateKey.length() > 1000) {
                maxDecryptBlock = 256;
            }
            while (inputLen - offSet > 0) {
                byte[] cache = inputLen - offSet > maxDecryptBlock ? cipher.doFinal(encryptedData, offSet, maxDecryptBlock) : cipher.doFinal(encryptedData, offSet, inputLen - offSet);
                out.write(cache, 0, cache.length);
                offSet = ++i * maxDecryptBlock;
            }
            byte[] decryptedData = out.toByteArray();
            out.close();
            return StringUtils.isBlank(charset) ? new String(decryptedData) : new String(decryptedData, charset);
        }
        catch (Exception var13) {
            throw new Exception("EncodeContent = " + content + ",charset = " + charset, var13);
        }
    }

    public static String rsaSign(Map<String, Object> params, String privateKey, String charset) throws Exception {
        String content = SignatureUtils.getSignContent(params);
        System.out.println("RSA\u5f85\u7b7e\u540d\u4e32\uff1a" + content);
        return SignatureUtils.rsaSign(content, privateKey, charset);
    }

    public static String rsaSign(String content, String privateKey, String charset) throws Exception {
        try {
            PrivateKey e = SignatureUtils.getPrivateKeyFromPKCS8("RSA", new ByteArrayInputStream(privateKey.getBytes("utf-8")));
            Signature signature = Signature.getInstance("SHA1WithRSA");
            signature.initSign(e);
            if (StringUtils.isBlank(charset)) {
                signature.update(content.getBytes());
            } else {
                signature.update(content.getBytes(charset));
            }
            byte[] signed = signature.sign();
            return new String(Base64.encodeBase64(signed));
        }
        catch (Exception var6) {
            throw new Exception("RSAcontent = " + content + "; charset = " + charset, var6);
        }
    }

    public static void checkRSASign(Map<String, Object> paramMap, String publicKey) throws Exception {
        if (paramMap == null || !paramMap.keySet().contains(ProtocolParameterEnum.SIGN.getCode())) {
            throw new Exception("\u8bf7\u6c42\u7684\u53c2\u6570\u65e0\u6548\uff01");
        }
        String sign = (String)paramMap.get(ProtocolParameterEnum.SIGN.getCode());
        paramMap.remove(ProtocolParameterEnum.SIGN.getCode());
        String content = SignatureUtils.getSignContent(paramMap);
        SignatureUtils.checkRSASign(sign, content, publicKey, "UTF-8");
    }

    public static void checkRSASign(String sign, String content, String publicKey, String charset) throws Exception {
        if (!SignatureUtils.rsaCheckContent(content, sign, publicKey, charset)) {
            throw new Exception("rsaCheck failure: sign=" + sign + ", content=" + content + ", charset=" + charset);
        }
    }

    public static String getSignContent(Map<String, Object> sortedParams) {
        JSONObject js = new JSONObject(sortedParams.size(), true);
        ArrayList<String> keys = new ArrayList<String>(sortedParams.keySet());
        Collections.sort(keys);
        for (int i = 0; i < keys.size(); ++i) {
            String key = keys.get(i);
            js.put(key, sortedParams.get(key));
        }
        return js.toJSONString();
    }

    public static PrivateKey getPrivateKeyFromPKCS8(String algorithm, InputStream ins) throws Exception {
        if (ins != null && !StringUtils.isBlank(algorithm)) {
            KeyFactory keyFactory = KeyFactory.getInstance(algorithm);
            byte[] encodedKey = StreamUtils.readText(ins).getBytes();
            encodedKey = Base64.decodeBase64(encodedKey);
            PKCS8EncodedKeySpec ps = new PKCS8EncodedKeySpec(encodedKey);
            return keyFactory.generatePrivate(ps);
        }
        return null;
    }

    public static boolean rsaCheckContent(String content, String sign, String publicKey, String charset) throws Exception {
        try {
            PublicKey e = SignatureUtils.getPublicKeyFromX509("RSA", new ByteArrayInputStream(publicKey.getBytes()));
            Signature signature = Signature.getInstance("SHA1WithRSA");
            signature.initVerify(e);
            if (StringUtils.isBlank(charset)) {
                signature.update(content.getBytes());
            } else {
                signature.update(content.getBytes(charset));
            }
            return signature.verify(Base64.decodeBase64(sign.getBytes()));
        }
        catch (Exception var6) {
            throw new Exception("RSAcontent=" + content + ",sign=" + sign + ",charset=" + charset, var6);
        }
    }

    public static PublicKey getPublicKeyFromX509(String algorithm, InputStream ins) throws Exception {
        KeyFactory keyFactory = KeyFactory.getInstance(algorithm);
        StringWriter writer = new StringWriter();
        StreamUtils.io(new InputStreamReader(ins), writer);
        byte[] encodedKey = writer.toString().getBytes();
        encodedKey = Base64.decodeBase64(encodedKey);
        return keyFactory.generatePublic(new X509EncodedKeySpec(encodedKey));
    }
}

