/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.bpmn.converter.parser;

import java.util.Arrays;
import java.util.List;
import javax.xml.stream.XMLStreamReader;
import org.activiti.bpmn.constants.BpmnXMLConstants;
import org.activiti.bpmn.converter.util.BpmnXMLUtil;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.ExtensionAttribute;
import org.apache.commons.lang3.StringUtils;

public class DefinitionsParser
implements BpmnXMLConstants {
    protected static final List<ExtensionAttribute> defaultAttributes = Arrays.asList(new ExtensionAttribute("typeLanguage"), new ExtensionAttribute("expressionLanguage"), new ExtensionAttribute("targetNamespace"));

    public void parse(XMLStreamReader xtr, BpmnModel model) throws Exception {
        int i;
        model.setTargetNamespace(xtr.getAttributeValue(null, "targetNamespace"));
        for (i = 0; i < xtr.getNamespaceCount(); ++i) {
            String prefix = xtr.getNamespacePrefix(i);
            if (prefix == null) continue;
            model.addNamespace(prefix, xtr.getNamespaceURI(i));
        }
        for (i = 0; i < xtr.getAttributeCount(); ++i) {
            ExtensionAttribute extensionAttribute = new ExtensionAttribute();
            extensionAttribute.setName(xtr.getAttributeLocalName(i));
            extensionAttribute.setValue(xtr.getAttributeValue(i));
            if (StringUtils.isNotEmpty((CharSequence)xtr.getAttributeNamespace(i))) {
                extensionAttribute.setNamespace(xtr.getAttributeNamespace(i));
            }
            if (StringUtils.isNotEmpty((CharSequence)xtr.getAttributePrefix(i))) {
                extensionAttribute.setNamespacePrefix(xtr.getAttributePrefix(i));
            }
            if (BpmnXMLUtil.isBlacklisted(extensionAttribute, defaultAttributes)) continue;
            model.addDefinitionsAttribute(extensionAttribute);
        }
    }
}

