/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.persistence.entity;

import java.io.Serializable;
import java.util.Arrays;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.db.HasRevision;
import org.activiti.engine.impl.db.PersistentObject;
import org.apache.commons.lang3.ObjectUtils;

public class ByteArrayEntity
implements Serializable,
PersistentObject,
HasRevision {
    private static final long serialVersionUID = 1L;
    protected String id;
    protected int revision;
    protected String name;
    protected byte[] bytes;
    protected String deploymentId;

    protected ByteArrayEntity() {
    }

    public ByteArrayEntity(String name, byte[] bytes) {
        this.name = name;
        this.bytes = bytes;
    }

    public ByteArrayEntity(byte[] bytes) {
        this.bytes = bytes;
    }

    public static ByteArrayEntity createAndInsert(String name, byte[] bytes) {
        ByteArrayEntity byteArrayEntity = new ByteArrayEntity(name, bytes);
        Context.getCommandContext().getDbSqlSession().insert(byteArrayEntity);
        return byteArrayEntity;
    }

    public static ByteArrayEntity createAndInsert(byte[] bytes) {
        return ByteArrayEntity.createAndInsert(null, bytes);
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    @Override
    public Object getPersistentState() {
        return new PersistentState(this.name, this.bytes);
    }

    @Override
    public int getRevisionNext() {
        return this.revision + 1;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDeploymentId() {
        return this.deploymentId;
    }

    public void setDeploymentId(String deploymentId) {
        this.deploymentId = deploymentId;
    }

    public void setBytes(byte[] bytes) {
        this.bytes = bytes;
    }

    @Override
    public int getRevision() {
        return this.revision;
    }

    @Override
    public void setRevision(int revision) {
        this.revision = revision;
    }

    public String toString() {
        return "ByteArrayEntity[id=" + this.id + ", name=" + this.name + ", size=" + (this.bytes != null ? this.bytes.length : 0) + "]";
    }

    private static class PersistentState {
        private final String name;
        private final byte[] bytes;

        public PersistentState(String name, byte[] bytes) {
            this.name = name;
            this.bytes = bytes;
        }

        public boolean equals(Object obj) {
            if (obj instanceof PersistentState) {
                PersistentState other = (PersistentState)obj;
                return ObjectUtils.equals((Object)this.name, (Object)other.name) && Arrays.equals(this.bytes, other.bytes);
            }
            return false;
        }

        public int hashCode() {
            throw new UnsupportedOperationException();
        }
    }
}

