/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.calendar;

import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.Duration;
import org.activiti.engine.ActivitiIllegalArgumentException;
import org.activiti.engine.impl.util.TimeZoneUtil;
import org.activiti.engine.runtime.ClockReader;
import org.joda.time.DateTimeZone;
import org.joda.time.format.ISODateTimeFormat;

public class DurationHelper {
    private Calendar start;
    private Calendar end;
    private Duration period;
    private boolean isRepeat;
    private int times;
    private DatatypeFactory datatypeFactory;
    protected ClockReader clockReader;

    public Calendar getStart() {
        return this.start;
    }

    public Calendar getEnd() {
        return this.end;
    }

    public Duration getPeriod() {
        return this.period;
    }

    public boolean isRepeat() {
        return this.isRepeat;
    }

    public int getTimes() {
        return this.times;
    }

    public DurationHelper(String expressionS, ClockReader clockReader) throws Exception {
        this.clockReader = clockReader;
        List<String> expression = Arrays.asList(expressionS.split("/"));
        this.datatypeFactory = DatatypeFactory.newInstance();
        if (expression.size() > 3 || expression.isEmpty()) {
            throw new ActivitiIllegalArgumentException("Cannot parse duration");
        }
        if (expression.get(0).startsWith("R")) {
            this.isRepeat = true;
            this.times = expression.get(0).length() == 1 ? Integer.MAX_VALUE : Integer.parseInt(expression.get(0).substring(1));
            expression = expression.subList(1, expression.size());
        }
        if (this.isDuration(expression.get(0))) {
            this.period = this.parsePeriod(expression.get(0));
            this.end = expression.size() == 1 ? null : this.parseDate(expression.get(1));
        } else {
            this.start = this.parseDate(expression.get(0));
            if (this.isDuration(expression.get(1))) {
                this.period = this.parsePeriod(expression.get(1));
            } else {
                this.end = this.parseDate(expression.get(1));
                this.period = this.datatypeFactory.newDuration(this.end.getTimeInMillis() - this.start.getTimeInMillis());
            }
        }
        if (this.start == null && this.end == null) {
            this.start = clockReader.getCurrentCalendar();
        }
    }

    public Calendar getCalendarAfter() {
        return this.getCalendarAfter(this.clockReader.getCurrentCalendar());
    }

    public Calendar getCalendarAfter(Calendar time) {
        if (this.isRepeat) {
            return this.getDateAfterRepeat(time);
        }
        if (this.end != null) {
            return this.end;
        }
        return this.add(this.start, this.period);
    }

    public Date getDateAfter() {
        Calendar date = this.getCalendarAfter();
        return date == null ? null : date.getTime();
    }

    private Calendar getDateAfterRepeat(Calendar date) {
        if (this.start != null) {
            Calendar cur = TimeZoneUtil.convertToTimeZone(this.start, date.getTimeZone());
            for (int i = 0; i < this.times && !cur.after(date); ++i) {
                cur = this.add(cur, this.period);
            }
            return cur.before(date) ? null : TimeZoneUtil.convertToTimeZone(cur, this.clockReader.getCurrentTimeZone());
        }
        Calendar cur = this.add(TimeZoneUtil.convertToTimeZone(this.end, date.getTimeZone()), this.period.negate());
        Calendar next = TimeZoneUtil.convertToTimeZone(this.end, date.getTimeZone());
        for (int i = 0; i < this.times && cur.after(date); ++i) {
            next = cur;
            cur = this.add(cur, this.period.negate());
        }
        return next.before(date) ? null : TimeZoneUtil.convertToTimeZone(next, this.clockReader.getCurrentTimeZone());
    }

    private Calendar add(Calendar date, Duration duration) {
        Calendar calendar = (Calendar)date.clone();
        calendar.add(13, duration.getSeconds() * duration.getSign());
        calendar.add(12, duration.getMinutes() * duration.getSign());
        calendar.add(10, duration.getHours() * duration.getSign());
        calendar.add(5, duration.getDays() * duration.getSign());
        calendar.add(2, duration.getMonths() * duration.getSign());
        calendar.add(1, duration.getYears() * duration.getSign());
        return calendar;
    }

    private Calendar parseDate(String date) throws Exception {
        return ISODateTimeFormat.dateTimeParser().withZone(DateTimeZone.forTimeZone((TimeZone)this.clockReader.getCurrentTimeZone())).parseDateTime(date).toCalendar(null);
    }

    private Duration parsePeriod(String period) throws Exception {
        return this.datatypeFactory.newDuration(period);
    }

    private boolean isDuration(String time) {
        return time.startsWith("P");
    }
}

