<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp" %>
<html>
<head>
    <title>护照订单管理</title>
    <meta name="decorator" content="default"/>
    <script type="text/javascript">
        $(document).ready(function () {

        });
        function page(n, s) {
            $("#pageNo").val(n);
            $("#pageSize").val(s);
            $("#searchForm").submit();
            return false;
        }
    </script>
</head>
<body>
<ul class="nav nav-tabs">
    <li class="active"><a href="${ctx}/passportorder/passportOrder/">护照订单列表</a></li>
    <shiro:hasPermission name="passportorder:passportOrder:edit">
        <li><a href="${ctx}/passportorder/passportOrder/form">护照订单添加</a></li>
    </shiro:hasPermission>
</ul>
<form:form id="searchForm" modelAttribute="passportOrder" action="${ctx}/passportorder/passportOrder/" method="post"
           class="breadcrumb form-search">
    <input id="pageNo" name="pageNo" type="hidden" value="${page.pageNo}"/>
    <input id="pageSize" name="pageSize" type="hidden" value="${page.pageSize}"/>
    <ul class="ul-form">
        <li><label>天猫订单号：</label>
            <form:input path="tmallOrderCode" htmlEscape="false" maxlength="20" class="input-medium"/>
        </li>
        <li><label>套餐类型:1套餐A ：护照+芯片;2套餐B：护照+芯片+C级;3套餐C：护照+芯片+检测卡+保险;4套餐D：护照+芯片+C级+检测卡+保险：</label>
            <form:select path="packageType" class="input-medium">
                <form:option value="" label=""/>
                <form:options items="${fns:getDictList('passport_order_package_type')}" itemLabel="label"
                              itemValue="value" htmlEscape="false"/>
            </form:select>
        </li>
        <li><label>收货人姓名：</label>
            <form:input path="consigneeName" htmlEscape="false" maxlength="10" class="input-medium"/>
        </li>
        <li><label>收货人电话：</label>
            <form:input path="consigneePhone" htmlEscape="false" maxlength="20" class="input-medium"/>
        </li>
        <li><label>收货人地址：</label>
            <form:input path="consigneeAddress" htmlEscape="false" maxlength="200" class="input-medium"/>
        </li>
        <li><label>宠物名称：</label>
            <form:input path="petName" htmlEscape="false" maxlength="50" class="input-medium"/>
        </li>
        <li><label>宠物种类:1狗;2猫：</label>
            <form:input path="petType" htmlEscape="false" maxlength="1" class="input-medium"/>
        </li>
        <li><label>宠物种类号码：</label>
            <form:input path="petBreedCode" htmlEscape="false" maxlength="5" class="input-medium"/>
        </li>
        <li><label>宠物性别:1公;2母：</label>
            <form:input path="petGender" htmlEscape="false" maxlength="1" class="input-medium"/>
        </li>
        <li><label>宠物生日：</label>
            <input name="petBirthday" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate"
                   value="<fmt:formatDate value="${passportOrder.petBirthday}" pattern="yyyy-MM-dd HH:mm:ss"/>"
                   onclick="WdatePicker({dateFmt:'yyyy-MM-dd HH:mm:ss',isShowClear:false});"/>
        </li>
        <li><label>宠物毛色：</label>
            <form:input path="petCoatColor" htmlEscape="false" maxlength="50" class="input-medium"/>
        </li>
        <li><label>业务状态：</label>
            <form:input path="businessState" htmlEscape="false" maxlength="1" class="input-medium"/>
        </li>
        <li><label>芯片号：</label>
            <form:input path="identificationFlag" htmlEscape="false" maxlength="20" class="input-medium"/>
        </li>
        <li><label>护照号：</label>
            <form:input path="cabPassport" htmlEscape="false" maxlength="20" class="input-medium"/>
        </li>
        <li class="btns"><input id="btnSubmit" class="btn btn-primary" type="submit" value="查询"/></li>
        <li class="clearfix"></li>
    </ul>
</form:form>
<sys:message content="${message}"/>
<table id="contentTable" class="table table-striped table-bordered table-condensed">
    <thead>
    <tr>
        <th>天猫订单号</th>
        <th>套餐类型:1套餐A ：护照+芯片;2套餐B：护照+芯片+C级;3套餐C：护照+芯片+检测卡+保险;4套餐D：护照+芯片+C级+检测卡+保险</th>
        <th>下单时间</th>
        <th>旺旺id</th>
        <th>收货人姓名</th>
        <th>收货人电话</th>
        <th>收货人地址</th>
        <th>宠物名称</th>
        <th>宠物种类:1狗;2猫</th>
        <th>宠物种类号码</th>
        <th>宠物性别:1公;2母</th>
        <th>宠物生日</th>
        <th>宠物毛色</th>
        <th>业务状态</th>
        <th>芯片号</th>
        <th>护照号</th>
        <th>快递类型</th>
        <th>快递号</th>
        <th>激活者</th>
        <th>激活时间</th>
        <th>修改时间</th>
        <th>备注信息</th>
        <shiro:hasPermission name="passportorder:passportOrder:edit">
            <th>操作</th>
        </shiro:hasPermission>
    </tr>
    </thead>
    <tbody>
    <c:forEach items="${page.list}" var="passportOrder">
        <tr>
            <td><a href="${ctx}/passportorder/passportOrder/form?id=${passportOrder.id}">
                    ${passportOrder.tmallOrderCode}
            </a></td>
            <td>
                    ${fns:getDictLabel(passportOrder.packageType, 'passport_order_package_type', '')}
            </td>
            <td>
                <fmt:formatDate value="${passportOrder.orderTime}" pattern="yyyy-MM-dd HH:mm:ss"/>
            </td>
            <td>
                    ${passportOrder.wangwangId}
            </td>
            <td>
                    ${passportOrder.consigneeName}
            </td>
            <td>
                    ${passportOrder.consigneePhone}
            </td>
            <td>
                    ${passportOrder.consigneeAddress}
            </td>
            <td>
                    ${passportOrder.petName}
            </td>
            <td>
                    ${passportOrder.petType}
            </td>
            <td>
                    ${passportOrder.petBreedCode}
            </td>
            <td>
                    ${passportOrder.petGender}
            </td>
            <td>
                <fmt:formatDate value="${passportOrder.petBirthday}" pattern="yyyy-MM-dd HH:mm:ss"/>
            </td>
            <td>
                    ${passportOrder.petCoatColor}
            </td>
            <td>
                    ${passportOrder.businessState}
            </td>
            <td>
                    ${passportOrder.identificationFlag}
            </td>
            <td>
                    ${passportOrder.cabPassport}
            </td>
            <td>
                    ${passportOrder.expressType}
            </td>
            <td>
                    ${passportOrder.expressNumber}
            </td>
            <td>
                    ${passportOrder.activateBy}
            </td>
            <td>
                <fmt:formatDate value="${passportOrder.activateDate}" pattern="yyyy-MM-dd HH:mm:ss"/>
            </td>
            <td>
                <fmt:formatDate value="${passportOrder.updateDate}" pattern="yyyy-MM-dd HH:mm:ss"/>
            </td>
            <td>
                    ${passportOrder.remarks}
            </td>
            <shiro:hasPermission name="passportorder:passportOrder:edit">
                <td>
                    <a href="${ctx}/passportorder/passportOrder/form?id=${passportOrder.id}">修改</a>
                    <a href="${ctx}/passportorder/passportOrder/delete?id=${passportOrder.id}"
                       onclick="return confirmx('确认要删除该护照订单吗？', this.href)">删除</a>
                </td>
            </shiro:hasPermission>
        </tr>
    </c:forEach>
    </tbody>
</table>
<div class="pagination">${page}</div>
</body>
</html>