/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.explorer.ui.task;

import com.vaadin.event.LayoutEvents;
import com.vaadin.ui.Alignment;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.CssLayout;
import com.vaadin.ui.Label;
import com.vaadin.ui.TextArea;
import com.vaadin.ui.VerticalLayout;
import org.activiti.engine.TaskService;
import org.activiti.engine.task.Task;
import org.activiti.explorer.I18nManager;

public class DescriptionComponent
extends CssLayout {
    private static final long serialVersionUID = 1L;
    protected Task task;
    protected I18nManager i18nManager;
    protected transient TaskService taskService;
    protected Label descriptionLabel;
    protected VerticalLayout editLayout;

    public DescriptionComponent(Task task, I18nManager i18nManager, TaskService taskService) {
        this.task = task;
        this.i18nManager = i18nManager;
        this.taskService = taskService;
        this.setWidth(100.0f, 8);
        this.initDescriptionLabel();
        this.initEditLayout();
        this.initLayoutClickListener();
    }

    protected void initDescriptionLabel() {
        String descriptionText = null;
        descriptionText = this.task.getDescription() != null && !"".equals(this.task.getDescription()) ? this.task.getDescription() : this.i18nManager.getMessage("task.no.description");
        this.descriptionLabel = new Label(descriptionText);
        this.descriptionLabel.addStyleName("clickable");
        this.addComponent((Component)this.descriptionLabel);
    }

    protected void initEditLayout() {
        this.editLayout = new VerticalLayout();
        this.editLayout.setSpacing(true);
    }

    protected void initLayoutClickListener() {
        this.addListener(new LayoutEvents.LayoutClickListener(){

            public void layoutClick(LayoutEvents.LayoutClickEvent event) {
                if (event.getClickedComponent() != null && event.getClickedComponent().equals(DescriptionComponent.this.descriptionLabel)) {
                    final TextArea descriptionTextArea = new TextArea();
                    descriptionTextArea.setWidth(100.0f, 8);
                    descriptionTextArea.setValue((Object)DescriptionComponent.this.task.getDescription());
                    DescriptionComponent.this.editLayout.addComponent((Component)descriptionTextArea);
                    Button okButton = new Button(DescriptionComponent.this.i18nManager.getMessage("button.ok"));
                    DescriptionComponent.this.editLayout.addComponent((Component)okButton);
                    DescriptionComponent.this.editLayout.setComponentAlignment((Component)okButton, Alignment.BOTTOM_RIGHT);
                    DescriptionComponent.this.replaceComponent((Component)DescriptionComponent.this.descriptionLabel, (Component)DescriptionComponent.this.editLayout);
                    okButton.addListener(new Button.ClickListener(){

                        public void buttonClick(Button.ClickEvent event) {
                            DescriptionComponent.this.task.setDescription(descriptionTextArea.getValue().toString());
                            DescriptionComponent.this.taskService.saveTask(DescriptionComponent.this.task);
                            DescriptionComponent.this.descriptionLabel.setValue((Object)DescriptionComponent.this.task.getDescription());
                            DescriptionComponent.this.replaceComponent((Component)DescriptionComponent.this.editLayout, (Component)DescriptionComponent.this.descriptionLabel);
                        }
                    });
                }
            }
        });
    }
}

