/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.explorer.ui.form;

import com.vaadin.ui.ComboBox;
import com.vaadin.ui.Field;
import java.util.List;
import org.activiti.engine.ProcessEngines;
import org.activiti.engine.form.FormProperty;
import org.activiti.engine.repository.ProcessDefinition;
import org.activiti.engine.repository.ProcessDefinitionQuery;
import org.activiti.explorer.form.ProcessDefinitionFormType;
import org.activiti.explorer.ui.form.AbstractFormPropertyRenderer;

public class ProcessDefinitionFormPropertyRenderer
extends AbstractFormPropertyRenderer {
    private static final long serialVersionUID = 1L;

    public ProcessDefinitionFormPropertyRenderer() {
        super(ProcessDefinitionFormType.class);
    }

    @Override
    public Field getPropertyField(FormProperty formProperty) {
        ComboBox comboBox = new ComboBox(this.getPropertyLabel(formProperty));
        comboBox.setRequired(formProperty.isRequired());
        comboBox.setRequiredError(this.getMessage("form.field.required", this.getPropertyLabel(formProperty)));
        comboBox.setEnabled(formProperty.isWritable());
        List processDefinitions = ((ProcessDefinitionQuery)((ProcessDefinitionQuery)ProcessEngines.getDefaultProcessEngine().getRepositoryService().createProcessDefinitionQuery().orderByProcessDefinitionName().asc()).orderByProcessDefinitionVersion().asc()).list();
        for (ProcessDefinition processDefinition : processDefinitions) {
            comboBox.addItem((Object)processDefinition.getId());
            String name = processDefinition.getName() + " (v" + processDefinition.getVersion() + ")";
            comboBox.setItemCaption((Object)processDefinition.getId(), name);
        }
        if (processDefinitions.size() > 0) {
            comboBox.setNullSelectionAllowed(false);
            comboBox.select((Object)((ProcessDefinition)processDefinitions.get(0)).getId());
        }
        return comboBox;
    }
}

