/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.explorer.data;

import com.vaadin.data.Container;
import com.vaadin.data.Item;
import com.vaadin.data.Property;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.activiti.engine.ActivitiException;
import org.activiti.explorer.data.LazyLoadingQuery;

public class LazyLoadingContainer
implements Container.Indexed,
Container.Sortable {
    private static final long serialVersionUID = 1L;
    protected LazyLoadingQuery lazyLoadingQuery;
    protected int batchSize;
    protected int size = -1;
    protected List<Object> containerPropertyIds = new ArrayList<Object>();
    protected Map<Object, Class<?>> containerPropertyTypes = new HashMap();
    protected Map<Object, Object> containerPropertyDefaultValues = new HashMap<Object, Object>();
    protected Map<Integer, Item> itemCache = new HashMap<Integer, Item>();

    public LazyLoadingContainer(LazyLoadingQuery lazyLoadingQuery, int batchSize) {
        this.lazyLoadingQuery = lazyLoadingQuery;
        this.batchSize = batchSize;
        lazyLoadingQuery.setLazyLoadingContainer(this);
    }

    public LazyLoadingContainer(LazyLoadingQuery lazyLoadingQuery) {
        this(lazyLoadingQuery, 30);
    }

    public boolean addContainerProperty(Object propertyId, Class<?> type, Object defaultValue) throws UnsupportedOperationException {
        this.containerPropertyIds.add(propertyId);
        this.containerPropertyTypes.put(propertyId, type);
        this.containerPropertyDefaultValues.put(propertyId, defaultValue);
        return true;
    }

    public boolean removeContainerProperty(Object propertyId) throws UnsupportedOperationException {
        this.containerPropertyIds.remove(propertyId);
        this.containerPropertyTypes.remove(propertyId);
        this.containerPropertyDefaultValues.remove(propertyId);
        return true;
    }

    public Collection<?> getContainerPropertyIds() {
        return this.containerPropertyIds;
    }

    public Class<?> getType(Object propertyId) {
        return this.containerPropertyTypes.get(propertyId);
    }

    public Object getDefaultValue(Object propertyId) {
        return this.containerPropertyDefaultValues.get(propertyId);
    }

    public Property getContainerProperty(Object itemId, Object propertyId) {
        return this.getItem(itemId).getItemProperty(propertyId);
    }

    public boolean containsId(Object itemId) {
        Integer index = (Integer)itemId;
        return index >= 0 && index < this.size();
    }

    public Item getItem(Object itemId) {
        if (itemId != null) {
            if (!this.itemCache.containsKey(itemId)) {
                Integer index = (Integer)itemId;
                int start = index - index % this.batchSize;
                List<Item> batch = this.lazyLoadingQuery.loadItems(start, this.batchSize);
                for (Item batchItem : batch) {
                    this.itemCache.put(start, batchItem);
                    ++start;
                }
            }
            return this.itemCache.get(itemId);
        }
        return null;
    }

    public int size() {
        if (this.size == -1) {
            this.size = this.lazyLoadingQuery.size();
        }
        return this.size;
    }

    public Collection<?> getItemIds() {
        return new AbstractList<Integer>(){

            @Override
            public int size() {
                return this.size();
            }

            @Override
            public Integer get(int index) {
                return index;
            }
        };
    }

    public Object firstItemId() {
        return 0;
    }

    public Object lastItemId() {
        return this.size() - 1;
    }

    public boolean isFirstId(Object itemId) {
        return ((Integer)itemId).equals(0);
    }

    public boolean isLastId(Object itemId) {
        return ((Integer)itemId).equals(this.size() - 1);
    }

    public Object nextItemId(Object itemId) {
        Integer index;
        Integer n = index = (Integer)itemId;
        Integer n2 = index = Integer.valueOf(index + 1);
        return n;
    }

    public Object prevItemId(Object itemId) {
        Integer index;
        Integer n = index = (Integer)itemId;
        Integer n2 = index = Integer.valueOf(index - 1);
        return n;
    }

    public int indexOfId(Object itemId) {
        return (Integer)itemId;
    }

    public Object getIdByIndex(int index) {
        return new Integer(index);
    }

    public Collection<?> getSortableContainerPropertyIds() {
        return this.containerPropertyIds;
    }

    public void sort(Object[] propertyIds, boolean[] ascending) {
        this.removeAllItems();
        this.lazyLoadingQuery.setSorting(propertyIds, ascending);
    }

    public boolean removeAllItems() throws UnsupportedOperationException {
        this.itemCache.clear();
        this.size = -1;
        return true;
    }

    public int getIndexForObjectId(String id) {
        Item searched = this.lazyLoadingQuery.loadSingleResult(id);
        if (searched == null) {
            return -1;
        }
        return this.getIndexForObjectId(searched, 0, this.size() - 1);
    }

    public int getIndexForObjectId(Item searched, int low, int high) {
        if (high < low) {
            return -1;
        }
        int middle = low + (high - low) / 2;
        Item result = null;
        if (this.itemCache.containsKey(middle)) {
            result = this.itemCache.get(middle);
        } else {
            result = this.lazyLoadingQuery.loadItems(middle, 1).get(0);
            this.itemCache.put(middle, result);
        }
        if (!(searched instanceof Comparable) || !(result instanceof Comparable)) {
            throw new ActivitiException("Cannot use the getIndexForObjectId method for non-Comparables");
        }
        int comparison = ((Comparable)searched).compareTo((Comparable)result);
        if (comparison < 0) {
            return this.getIndexForObjectId(searched, low, middle - 1);
        }
        if (comparison > 0) {
            return this.getIndexForObjectId(searched, middle + 1, high);
        }
        return middle;
    }

    public Object addItem() throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public Object addItemAfter(Object previousItemId) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public Item addItemAfter(Object previousItemId, Object newItemId) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public Object addItemAt(int index) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public Item addItemAt(int index, Object newItemId) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public boolean removeItem(Object itemId) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public Item addItem(Object itemId) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }
}

