/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.crypto.hash;

import java.io.Serializable;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import org.apache.shiro.codec.Base64;
import org.apache.shiro.codec.CodecException;
import org.apache.shiro.codec.CodecSupport;
import org.apache.shiro.codec.Hex;
import org.apache.shiro.crypto.UnknownAlgorithmException;
import org.apache.shiro.crypto.hash.Hash;
import org.apache.shiro.crypto.hash.Md2Hash;

@Deprecated
public abstract class AbstractHash
extends CodecSupport
implements Hash,
Serializable {
    private byte[] bytes = null;
    private transient String hexEncoded = null;
    private transient String base64Encoded = null;

    public AbstractHash() {
    }

    public AbstractHash(Object source) throws CodecException {
        this(source, null, 1);
    }

    public AbstractHash(Object source, Object salt) throws CodecException {
        this(source, salt, 1);
    }

    public AbstractHash(Object source, Object salt, int hashIterations) throws CodecException {
        byte[] sourceBytes = this.toBytes(source);
        byte[] saltBytes = null;
        if (salt != null) {
            saltBytes = this.toBytes(salt);
        }
        byte[] hashedBytes = this.hash(sourceBytes, saltBytes, hashIterations);
        this.setBytes(hashedBytes);
    }

    @Override
    public abstract String getAlgorithmName();

    @Override
    public byte[] getBytes() {
        return this.bytes;
    }

    public void setBytes(byte[] alreadyHashedBytes) {
        this.bytes = alreadyHashedBytes;
        this.hexEncoded = null;
        this.base64Encoded = null;
    }

    protected MessageDigest getDigest(String algorithmName) throws UnknownAlgorithmException {
        try {
            return MessageDigest.getInstance(algorithmName);
        }
        catch (NoSuchAlgorithmException e) {
            String msg = "No native '" + algorithmName + "' MessageDigest instance available on the current JVM.";
            throw new UnknownAlgorithmException(msg, e);
        }
    }

    protected byte[] hash(byte[] bytes) {
        return this.hash(bytes, null, 1);
    }

    protected byte[] hash(byte[] bytes, byte[] salt) {
        return this.hash(bytes, salt, 1);
    }

    protected byte[] hash(byte[] bytes, byte[] salt, int hashIterations) throws UnknownAlgorithmException {
        MessageDigest digest = this.getDigest(this.getAlgorithmName());
        if (salt != null) {
            digest.reset();
            digest.update(salt);
        }
        byte[] hashed = digest.digest(bytes);
        int iterations = hashIterations - 1;
        for (int i = 0; i < iterations; ++i) {
            digest.reset();
            hashed = digest.digest(hashed);
        }
        return hashed;
    }

    @Override
    public String toHex() {
        if (this.hexEncoded == null) {
            this.hexEncoded = Hex.encodeToString(this.getBytes());
        }
        return this.hexEncoded;
    }

    @Override
    public String toBase64() {
        if (this.base64Encoded == null) {
            this.base64Encoded = Base64.encodeToString(this.getBytes());
        }
        return this.base64Encoded;
    }

    public String toString() {
        return this.toHex();
    }

    public boolean equals(Object o) {
        if (o instanceof Hash) {
            Hash other = (Hash)o;
            return Arrays.equals(this.getBytes(), other.getBytes());
        }
        return false;
    }

    public int hashCode() {
        if (this.bytes == null || this.bytes.length == 0) {
            return 0;
        }
        return Arrays.hashCode(this.bytes);
    }

    private static void printMainUsage(Class<? extends AbstractHash> clazz, String type) {
        System.out.println("Prints an " + type + " hash value.");
        System.out.println("Usage: java " + clazz.getName() + " [-base64] [-salt <saltValue>] [-times <N>] <valueToHash>");
        System.out.println("Options:");
        System.out.println("\t-base64\t\tPrints the hash value as a base64 String instead of the default hex.");
        System.out.println("\t-salt\t\tSalts the hash with the specified <saltValue>");
        System.out.println("\t-times\t\tHashes the input <N> number of times");
    }

    private static boolean isReserved(String arg) {
        return "-base64".equals(arg) || "-times".equals(arg) || "-salt".equals(arg);
    }

    static int doMain(Class<? extends AbstractHash> clazz, String[] args) {
        String simple = clazz.getSimpleName();
        int index = simple.indexOf("Hash");
        String type = simple.substring(0, index).toUpperCase();
        if (args == null || args.length < 1 || args.length > 7) {
            AbstractHash.printMainUsage(clazz, type);
            return -1;
        }
        boolean hex = true;
        String salt = null;
        int times = 1;
        String text = args[args.length - 1];
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (arg.equals("-base64")) {
                hex = false;
                continue;
            }
            if (arg.equals("-salt")) {
                if (i + 1 >= args.length - 1) {
                    String msg = "Salt argument must be followed by a salt value.  The final argument is reserved for the value to hash.";
                    System.out.println(msg);
                    AbstractHash.printMainUsage(clazz, type);
                    return -1;
                }
                salt = args[i + 1];
                continue;
            }
            if (!arg.equals("-times")) continue;
            if (i + 1 >= args.length - 1) {
                String msg = "Times argument must be followed by an integer value.  The final argument is reserved for the value to hash";
                System.out.println(msg);
                AbstractHash.printMainUsage(clazz, type);
                return -1;
            }
            try {
                times = Integer.valueOf(args[i + 1]);
                continue;
            }
            catch (NumberFormatException e) {
                String msg = "Times argument must be followed by an integer value.";
                System.out.println(msg);
                AbstractHash.printMainUsage(clazz, type);
                return -1;
            }
        }
        Md2Hash hash = new Md2Hash((Object)text, salt, times);
        String hashed = hex ? hash.toHex() : hash.toBase64();
        System.out.print(hex ? "Hex: " : "Base64: ");
        System.out.println(hashed);
        return 0;
    }
}

