/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.properties;

import org.apache.fop.datatypes.Numeric;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.expr.PropertyException;
import org.apache.fop.fo.properties.EnumProperty;
import org.apache.fop.fo.properties.PercentLength;
import org.apache.fop.fo.properties.Property;
import org.apache.fop.fo.properties.SpaceProperty;

public class LineHeightPropertyMaker
extends SpaceProperty.Maker {
    public LineHeightPropertyMaker(int propId) {
        super(propId);
    }

    public Property make(PropertyList propertyList, String value, FObj fo) throws PropertyException {
        Property p = super.make(propertyList, value, fo);
        p.getSpace().setConditionality(EnumProperty.getInstance(118, "RETAIN"), true);
        p.getSpace().setPrecedence(EnumProperty.getInstance(53, "FORCE"), true);
        return p;
    }

    protected Property compute(PropertyList propertyList) throws PropertyException {
        String specVal;
        Property specProp = propertyList.getNearestSpecified(this.propId);
        if (specProp != null && (specVal = specProp.getSpecifiedValue()) != null) {
            return this.make(propertyList, specVal, propertyList.getParentFObj());
        }
        return null;
    }

    public Property convertProperty(Property p, PropertyList propertyList, FObj fo) throws PropertyException {
        Numeric numval = p.getNumeric();
        if (numval != null && numval.getDimension() == 0) {
            p = new PercentLength(numval.getNumericValue(), this.getPercentBase(propertyList));
            Property spaceProp = super.convertProperty(p, propertyList, fo);
            spaceProp.setSpecifiedValue(String.valueOf(numval.getNumericValue()));
            return spaceProp;
        }
        return super.convertProperty(p, propertyList, fo);
    }
}

