/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.dialect.sqlserver.visitor;

import com.alibaba.druid.sql.ast.SQLName;
import com.alibaba.druid.sql.ast.SQLStatement;
import com.alibaba.druid.sql.ast.statement.SQLAssignItem;
import com.alibaba.druid.sql.ast.statement.SQLColumnConstraint;
import com.alibaba.druid.sql.ast.statement.SQLColumnDefinition;
import com.alibaba.druid.sql.ast.statement.SQLExprTableSource;
import com.alibaba.druid.sql.ast.statement.SQLGrantStatement;
import com.alibaba.druid.sql.dialect.sqlserver.ast.SQLServerColumnDefinition;
import com.alibaba.druid.sql.dialect.sqlserver.ast.SQLServerDeclareItem;
import com.alibaba.druid.sql.dialect.sqlserver.ast.SQLServerOutput;
import com.alibaba.druid.sql.dialect.sqlserver.ast.SQLServerSelect;
import com.alibaba.druid.sql.dialect.sqlserver.ast.SQLServerSelectQueryBlock;
import com.alibaba.druid.sql.dialect.sqlserver.ast.SQLServerTop;
import com.alibaba.druid.sql.dialect.sqlserver.ast.expr.SQLServerObjectReferenceExpr;
import com.alibaba.druid.sql.dialect.sqlserver.ast.stmt.SQLServerBlockStatement;
import com.alibaba.druid.sql.dialect.sqlserver.ast.stmt.SQLServerCommitStatement;
import com.alibaba.druid.sql.dialect.sqlserver.ast.stmt.SQLServerDeclareStatement;
import com.alibaba.druid.sql.dialect.sqlserver.ast.stmt.SQLServerExecStatement;
import com.alibaba.druid.sql.dialect.sqlserver.ast.stmt.SQLServerIfStatement;
import com.alibaba.druid.sql.dialect.sqlserver.ast.stmt.SQLServerInsertStatement;
import com.alibaba.druid.sql.dialect.sqlserver.ast.stmt.SQLServerRollbackStatement;
import com.alibaba.druid.sql.dialect.sqlserver.ast.stmt.SQLServerSetStatement;
import com.alibaba.druid.sql.dialect.sqlserver.ast.stmt.SQLServerSetTransactionIsolationLevelStatement;
import com.alibaba.druid.sql.dialect.sqlserver.ast.stmt.SQLServerUpdateStatement;
import com.alibaba.druid.sql.dialect.sqlserver.visitor.SQLServerASTVisitor;
import com.alibaba.druid.sql.visitor.SQLASTOutputVisitor;

public class SQLServerOutputVisitor
extends SQLASTOutputVisitor
implements SQLServerASTVisitor {
    public SQLServerOutputVisitor(Appendable appender) {
        super(appender);
    }

    @Override
    public boolean visit(SQLServerSelectQueryBlock x) {
        this.print("SELECT ");
        if (1 == x.getDistionOption()) {
            this.print("ALL ");
        } else if (2 == x.getDistionOption()) {
            this.print("DISTINCT ");
        } else if (3 == x.getDistionOption()) {
            this.print("UNIQUE ");
        }
        if (x.getTop() != null) {
            x.getTop().accept(this);
            this.print(' ');
        }
        this.printSelectList(x.getSelectList());
        if (x.getInto() != null) {
            this.println();
            this.print("INTO ");
            x.getInto().accept(this);
        }
        if (x.getFrom() != null) {
            this.println();
            this.print("FROM ");
            x.getFrom().accept(this);
        }
        if (x.getWhere() != null) {
            this.println();
            this.print("WHERE ");
            x.getWhere().setParent(x);
            x.getWhere().accept(this);
        }
        if (x.getGroupBy() != null) {
            this.println();
            x.getGroupBy().accept(this);
        }
        return false;
    }

    @Override
    public void endVisit(SQLServerSelectQueryBlock x) {
    }

    @Override
    public boolean visit(SQLServerTop x) {
        this.print("TOP ");
        boolean paren = false;
        if (x.getParent() instanceof SQLServerUpdateStatement || x.getParent() instanceof SQLServerInsertStatement) {
            paren = true;
            this.print("(");
        }
        x.getExpr().accept(this);
        if (paren) {
            this.print(")");
        }
        if (x.isPercent()) {
            this.print(" PERCENT");
        }
        return false;
    }

    @Override
    public void endVisit(SQLServerTop x) {
    }

    @Override
    public boolean visit(SQLServerObjectReferenceExpr x) {
        this.print(x.toString());
        return false;
    }

    @Override
    public void endVisit(SQLServerObjectReferenceExpr x) {
    }

    @Override
    public boolean visit(SQLServerInsertStatement x) {
        int i;
        int size;
        this.print("INSERT ");
        if (x.getTop() != null) {
            x.getTop().setParent(x);
            x.getTop().accept(this);
            this.print(' ');
        }
        this.print("INTO ");
        x.getTableSource().accept(this);
        if (x.getColumns().size() > 0) {
            this.incrementIndent();
            this.println();
            this.print("(");
            size = x.getColumns().size();
            for (i = 0; i < size; ++i) {
                if (i != 0) {
                    if (i % 5 == 0) {
                        this.println();
                    }
                    this.print(", ");
                }
                x.getColumns().get(i).accept(this);
            }
            this.print(")");
            this.decrementIndent();
        }
        if (x.getOutput() != null) {
            this.println();
            x.getOutput().setParent(x);
            x.getOutput().accept(this);
        }
        if (x.getValuesList().size() != 0) {
            this.println();
            this.print("VALUES");
            this.println();
            size = x.getValuesList().size();
            for (i = 0; i < size; ++i) {
                if (i != 0) {
                    this.print(",");
                    this.println();
                }
                x.getValuesList().get(i).accept(this);
            }
        }
        if (x.getQuery() != null) {
            this.println();
            x.getQuery().accept(this);
        }
        if (x.isDefaultValues()) {
            this.print(" DEFAULT VALUES");
        }
        return false;
    }

    @Override
    public void endVisit(SQLServerInsertStatement x) {
    }

    @Override
    public boolean visit(SQLServerUpdateStatement x) {
        this.print("UPDATE ");
        if (x.getTop() != null) {
            x.getTop().setParent(x);
            x.getTop().accept(this);
            this.print(' ');
        }
        x.getTableSource().accept(this);
        this.println();
        this.print("SET ");
        int size = x.getItems().size();
        for (int i = 0; i < size; ++i) {
            if (i != 0) {
                this.print(", ");
            }
            x.getItems().get(i).accept(this);
        }
        if (x.getOutput() != null) {
            this.println();
            x.getOutput().setParent(x);
            x.getOutput().accept(this);
        }
        if (x.getFrom() != null) {
            this.println();
            this.print("FROM ");
            x.getFrom().setParent(x);
            x.getFrom().accept(this);
        }
        if (x.getWhere() != null) {
            this.println();
            this.print("WHERE ");
            x.getWhere().setParent(x);
            x.getWhere().accept(this);
        }
        return false;
    }

    @Override
    public void endVisit(SQLServerUpdateStatement x) {
    }

    @Override
    public boolean visit(SQLExprTableSource x) {
        x.getExpr().accept(this);
        if (x.getHints() != null && x.getHints().size() > 0) {
            this.print(" WITH (");
            this.printAndAccept(x.getHints(), ", ");
            this.print(")");
        }
        if (x.getAlias() != null) {
            this.print(' ');
            this.print(x.getAlias());
        }
        return false;
    }

    @Override
    public boolean visit(SQLServerColumnDefinition.Identity x) {
        this.print("IDENTITY (");
        this.print(x.getSeed());
        this.print(", ");
        this.print(x.getIncrement());
        this.print(")");
        return false;
    }

    @Override
    public void endVisit(SQLServerColumnDefinition.Identity x) {
    }

    @Override
    public boolean visit(SQLServerColumnDefinition x) {
        x.getName().accept(this);
        if (x.getDataType() != null) {
            this.print(' ');
            x.getDataType().accept(this);
        }
        if (x.getDefaultExpr() != null) {
            this.visitColumnDefault(x);
        }
        for (SQLColumnConstraint item : x.getConstraints()) {
            this.print(' ');
            item.accept(this);
        }
        if (x.getIdentity() != null) {
            this.print(' ');
            x.getIdentity().accept(this);
        }
        if (x.getEnable() != null && x.getEnable().booleanValue()) {
            this.print(" ENABLE");
        }
        return false;
    }

    @Override
    public void endVisit(SQLServerColumnDefinition x) {
    }

    @Override
    public boolean visit(SQLColumnDefinition x) {
        if (x instanceof SQLServerColumnDefinition) {
            return this.visit((SQLServerColumnDefinition)x);
        }
        return super.visit(x);
    }

    @Override
    public boolean visit(SQLServerExecStatement x) {
        SQLName moduleName;
        this.print("EXEC ");
        SQLName returnStatus = x.getReturnStatus();
        if (returnStatus != null) {
            returnStatus.accept(this);
            this.print(" = ");
        }
        if ((moduleName = x.getModuleName()) != null) {
            moduleName.accept(this);
            this.print(' ');
        } else {
            this.print(" (");
        }
        this.printAndAccept(x.getParameters(), ", ");
        if (moduleName == null) {
            this.print(')');
        }
        return false;
    }

    @Override
    public void endVisit(SQLServerExecStatement x) {
    }

    @Override
    public boolean visit(SQLServerSetTransactionIsolationLevelStatement x) {
        this.print("SET TRANSACTION ISOLATION LEVEL ");
        this.print(x.getLevel());
        return false;
    }

    @Override
    public void endVisit(SQLServerSetTransactionIsolationLevelStatement x) {
    }

    @Override
    public boolean visit(SQLServerSetStatement x) {
        this.print("SET ");
        SQLAssignItem item = x.getItem();
        item.getTarget().accept(this);
        this.print(" ");
        item.getValue().accept(this);
        return false;
    }

    @Override
    public void endVisit(SQLServerSetStatement x) {
    }

    @Override
    public boolean visit(SQLServerOutput x) {
        this.print("OUTPUT ");
        this.printSelectList(x.getSelectList());
        if (x.getInto() != null) {
            this.incrementIndent();
            this.println();
            this.print("INTO ");
            x.getInto().accept(this);
            if (x.getColumns().size() > 0) {
                this.incrementIndent();
                this.println();
                this.print("(");
                int size = x.getColumns().size();
                for (int i = 0; i < size; ++i) {
                    if (i != 0) {
                        if (i % 5 == 0) {
                            this.println();
                        }
                        this.print(", ");
                    }
                    x.getColumns().get(i).accept(this);
                }
                this.print(")");
                this.decrementIndent();
            }
        }
        this.decrementIndent();
        return false;
    }

    @Override
    public void endVisit(SQLServerOutput x) {
    }

    @Override
    public boolean visit(SQLServerDeclareItem x) {
        x.getName().accept(this);
        if (x.getType() == SQLServerDeclareItem.Type.TABLE) {
            this.print(" TABLE");
            int size = x.getTableElementList().size();
            if (size > 0) {
                this.print(" (");
                this.incrementIndent();
                this.println();
                for (int i = 0; i < size; ++i) {
                    if (i != 0) {
                        this.print(",");
                        this.println();
                    }
                    x.getTableElementList().get(i).accept(this);
                }
                this.decrementIndent();
                this.println();
                this.print(")");
            }
        } else if (x.getType() == SQLServerDeclareItem.Type.CURSOR) {
            this.print(" CURSOR");
        } else {
            this.print(" ");
            x.getDataType().accept(this);
            if (x.getValue() != null) {
                this.print(" = ");
                x.getValue().accept(this);
            }
        }
        return false;
    }

    @Override
    public void endVisit(SQLServerDeclareItem x) {
    }

    @Override
    public boolean visit(SQLServerDeclareStatement x) {
        this.print("DECLARE ");
        this.printAndAccept(x.getItems(), ", ");
        return false;
    }

    @Override
    public void endVisit(SQLServerDeclareStatement x) {
    }

    @Override
    public boolean visit(SQLServerIfStatement.Else x) {
        this.print("ELSE");
        this.incrementIndent();
        this.println();
        int size = x.getStatements().size();
        for (int i = 0; i < size; ++i) {
            if (i != 0) {
                this.println();
            }
            SQLStatement item = x.getStatements().get(i);
            item.setParent(x);
            item.accept(this);
        }
        this.decrementIndent();
        return false;
    }

    @Override
    public void endVisit(SQLServerIfStatement.Else x) {
    }

    @Override
    public boolean visit(SQLServerIfStatement x) {
        this.print("IF ");
        x.getCondition().accept(this);
        this.incrementIndent();
        this.println();
        int size = x.getStatements().size();
        for (int i = 0; i < size; ++i) {
            SQLStatement item = x.getStatements().get(i);
            item.setParent(x);
            item.accept(this);
            if (i == size - 1) continue;
            this.println();
        }
        this.decrementIndent();
        if (x.getElseItem() != null) {
            this.println();
            x.getElseItem().accept(this);
        }
        return false;
    }

    @Override
    public void endVisit(SQLServerIfStatement x) {
    }

    @Override
    public boolean visit(SQLServerBlockStatement x) {
        this.print("BEGIN");
        this.incrementIndent();
        this.println();
        int size = x.getStatementList().size();
        for (int i = 0; i < size; ++i) {
            if (i != 0) {
                this.println();
            }
            SQLStatement stmt = x.getStatementList().get(i);
            stmt.setParent(x);
            stmt.accept(this);
            this.print(";");
        }
        this.decrementIndent();
        this.println();
        this.print("END");
        return false;
    }

    @Override
    public void endVisit(SQLServerBlockStatement x) {
    }

    @Override
    protected void printGrantOn(SQLGrantStatement x) {
        if (x.getOn() != null) {
            this.print(" ON ");
            if (x.getObjectType() != null) {
                this.print(x.getObjectType().name());
                this.print("::");
            }
            x.getOn().accept(this);
        }
    }

    @Override
    public void endVisit(SQLServerSelect x) {
    }

    @Override
    public boolean visit(SQLServerSelect x) {
        super.visit(x);
        if (x.isForBrowse()) {
            this.println();
            this.print("FOR BROWSE");
        }
        if (x.getForXmlOptions().size() > 0) {
            this.println();
            this.print("FOR XML ");
            for (int i = 0; i < x.getForXmlOptions().size(); ++i) {
                if (i == 0) continue;
                this.print(", ");
                this.print(x.getForXmlOptions().get(i));
            }
        }
        return false;
    }

    @Override
    public boolean visit(SQLServerCommitStatement x) {
        this.print("COMMIT");
        if (x.isWork()) {
            this.print(" WORK");
        } else {
            this.print(" TRANSACTION");
            if (x.getTransactionName() != null) {
                this.print(" ");
                x.getTransactionName().accept(this);
            }
            if (x.getDelayedDurability() != null) {
                this.print(" WITH ( DELAYED_DURABILITY = ");
                x.getDelayedDurability().accept(this);
                this.print(" )");
            }
        }
        return false;
    }

    @Override
    public void endVisit(SQLServerCommitStatement x) {
    }

    @Override
    public boolean visit(SQLServerRollbackStatement x) {
        this.print("ROLLBACK");
        if (x.isWork()) {
            this.print(" WORK");
        } else {
            this.print(" TRANSACTION");
            if (x.getName() != null) {
                this.print(" ");
                x.getName().accept(this);
            }
        }
        return false;
    }

    @Override
    public void endVisit(SQLServerRollbackStatement x) {
    }
}

