/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.pdf417.encoder;

import com.google.zxing.WriterException;
import com.google.zxing.pdf417.encoder.Compaction;
import java.math.BigInteger;
import java.util.Arrays;

final class PDF417HighLevelEncoder {
    private static final int TEXT_COMPACTION = 0;
    private static final int BYTE_COMPACTION = 1;
    private static final int NUMERIC_COMPACTION = 2;
    private static final int SUBMODE_ALPHA = 0;
    private static final int SUBMODE_LOWER = 1;
    private static final int SUBMODE_MIXED = 2;
    private static final int SUBMODE_PUNCTUATION = 3;
    private static final int LATCH_TO_TEXT = 900;
    private static final int LATCH_TO_BYTE_PADDED = 901;
    private static final int LATCH_TO_NUMERIC = 902;
    private static final int SHIFT_TO_BYTE = 913;
    private static final int LATCH_TO_BYTE = 924;
    private static final byte[] TEXT_MIXED_RAW;
    private static final byte[] TEXT_PUNCTUATION_RAW;
    private static final byte[] MIXED;
    private static final byte[] PUNCTUATION;

    private PDF417HighLevelEncoder() {
    }

    private static byte[] getBytesForMessage(String msg) {
        return msg.getBytes();
    }

    static String encodeHighLevel(String msg, Compaction compaction) throws WriterException {
        byte[] bytes = null;
        StringBuilder sb = new StringBuilder(msg.length());
        int len = msg.length();
        int p = 0;
        int textSubMode = 0;
        if (compaction == Compaction.TEXT) {
            PDF417HighLevelEncoder.encodeText(msg, p, len, sb, textSubMode);
        } else if (compaction == Compaction.BYTE) {
            bytes = PDF417HighLevelEncoder.getBytesForMessage(msg);
            PDF417HighLevelEncoder.encodeBinary(bytes, p, bytes.length, 1, sb);
        } else if (compaction == Compaction.NUMERIC) {
            sb.append('\u0386');
            PDF417HighLevelEncoder.encodeNumeric(msg, p, len, sb);
        } else {
            int encodingMode = 0;
            while (p < len) {
                int b;
                int n = PDF417HighLevelEncoder.determineConsecutiveDigitCount(msg, p);
                if (n >= 13) {
                    sb.append('\u0386');
                    encodingMode = 2;
                    textSubMode = 0;
                    PDF417HighLevelEncoder.encodeNumeric(msg, p, n, sb);
                    p += n;
                    continue;
                }
                int t = PDF417HighLevelEncoder.determineConsecutiveTextCount(msg, p);
                if (t >= 5 || n == len) {
                    if (encodingMode != 0) {
                        sb.append('\u0384');
                        encodingMode = 0;
                        textSubMode = 0;
                    }
                    textSubMode = PDF417HighLevelEncoder.encodeText(msg, p, t, sb, textSubMode);
                    p += t;
                    continue;
                }
                if (bytes == null) {
                    bytes = PDF417HighLevelEncoder.getBytesForMessage(msg);
                }
                if ((b = PDF417HighLevelEncoder.determineConsecutiveBinaryCount(msg, bytes, p)) == 0) {
                    b = 1;
                }
                if (b == 1 && encodingMode == 0) {
                    PDF417HighLevelEncoder.encodeBinary(bytes, p, 1, 0, sb);
                } else {
                    PDF417HighLevelEncoder.encodeBinary(bytes, p, b, encodingMode, sb);
                    encodingMode = 1;
                    textSubMode = 0;
                }
                p += b;
            }
        }
        return sb.toString();
    }

    private static int encodeText(CharSequence msg, int startpos, int count, StringBuilder sb, int initialSubmode) {
        StringBuilder tmp = new StringBuilder(count);
        int submode = initialSubmode;
        int idx = 0;
        block5: while (true) {
            char ch = msg.charAt(startpos + idx);
            switch (submode) {
                case 0: {
                    if (PDF417HighLevelEncoder.isAlphaUpper(ch)) {
                        if (ch == ' ') {
                            tmp.append('\u001a');
                            break;
                        }
                        tmp.append((char)(ch - 65));
                        break;
                    }
                    if (PDF417HighLevelEncoder.isAlphaLower(ch)) {
                        submode = 1;
                        tmp.append('\u001b');
                        continue block5;
                    }
                    if (PDF417HighLevelEncoder.isMixed(ch)) {
                        submode = 2;
                        tmp.append('\u001c');
                        continue block5;
                    }
                    tmp.append('\u001d');
                    tmp.append((char)PUNCTUATION[ch]);
                    break;
                }
                case 1: {
                    if (PDF417HighLevelEncoder.isAlphaLower(ch)) {
                        if (ch == ' ') {
                            tmp.append('\u001a');
                            break;
                        }
                        tmp.append((char)(ch - 97));
                        break;
                    }
                    if (PDF417HighLevelEncoder.isAlphaUpper(ch)) {
                        tmp.append('\u001b');
                        tmp.append((char)(ch - 65));
                        break;
                    }
                    if (PDF417HighLevelEncoder.isMixed(ch)) {
                        submode = 2;
                        tmp.append('\u001c');
                        continue block5;
                    }
                    tmp.append('\u001d');
                    tmp.append((char)PUNCTUATION[ch]);
                    break;
                }
                case 2: {
                    char next;
                    if (PDF417HighLevelEncoder.isMixed(ch)) {
                        tmp.append((char)MIXED[ch]);
                        break;
                    }
                    if (PDF417HighLevelEncoder.isAlphaUpper(ch)) {
                        submode = 0;
                        tmp.append('\u001c');
                        continue block5;
                    }
                    if (PDF417HighLevelEncoder.isAlphaLower(ch)) {
                        submode = 1;
                        tmp.append('\u001b');
                        continue block5;
                    }
                    if (startpos + idx + 1 < count && PDF417HighLevelEncoder.isPunctuation(next = msg.charAt(startpos + idx + 1))) {
                        submode = 3;
                        tmp.append('\u0019');
                        continue block5;
                    }
                    tmp.append('\u001d');
                    tmp.append((char)PUNCTUATION[ch]);
                    break;
                }
                default: {
                    if (PDF417HighLevelEncoder.isPunctuation(ch)) {
                        tmp.append((char)PUNCTUATION[ch]);
                        break;
                    }
                    submode = 0;
                    tmp.append('\u001d');
                    continue block5;
                }
            }
            if (++idx >= count) break;
        }
        char h = '\u0000';
        int len = tmp.length();
        for (int i = 0; i < len; ++i) {
            boolean odd;
            boolean bl = odd = i % 2 != 0;
            if (odd) {
                h = (char)(h * 30 + tmp.charAt(i));
                sb.append(h);
                continue;
            }
            h = tmp.charAt(i);
        }
        if (len % 2 != 0) {
            sb.append((char)(h * 30 + 29));
        }
        return submode;
    }

    private static void encodeBinary(byte[] bytes, int startpos, int count, int startmode, StringBuilder sb) {
        if (count == 1 && startmode == 0) {
            sb.append('\u0391');
        }
        int idx = startpos;
        if (count >= 6) {
            sb.append('\u039c');
            char[] chars = new char[5];
            while (startpos + count - idx >= 6) {
                int i;
                long t = 0L;
                for (i = 0; i < 6; ++i) {
                    t <<= 8;
                    t += (long)(bytes[idx + i] & 0xFF);
                }
                for (i = 0; i < 5; ++i) {
                    chars[i] = (char)(t % 900L);
                    t /= 900L;
                }
                for (i = chars.length - 1; i >= 0; --i) {
                    sb.append(chars[i]);
                }
                idx += 6;
            }
        }
        if (idx < startpos + count) {
            sb.append('\u0385');
        }
        for (int i = idx; i < startpos + count; ++i) {
            int ch = bytes[i] & 0xFF;
            sb.append((char)ch);
        }
    }

    private static void encodeNumeric(String msg, int startpos, int count, StringBuilder sb) {
        int len;
        StringBuilder tmp = new StringBuilder(count / 3 + 1);
        BigInteger num900 = BigInteger.valueOf(900L);
        BigInteger num0 = BigInteger.valueOf(0L);
        for (int idx = 0; idx < count - 1; idx += len) {
            tmp.setLength(0);
            len = Math.min(44, count - idx);
            String part = '1' + msg.substring(startpos + idx, startpos + idx + len);
            BigInteger bigint = new BigInteger(part);
            do {
                BigInteger c = bigint.mod(num900);
                tmp.append((char)c.intValue());
            } while (!(bigint = bigint.divide(num900)).equals(num0));
            for (int i = tmp.length() - 1; i >= 0; --i) {
                sb.append(tmp.charAt(i));
            }
        }
    }

    private static boolean isDigit(char ch) {
        return ch >= '0' && ch <= '9';
    }

    private static boolean isAlphaUpper(char ch) {
        return ch == ' ' || ch >= 'A' && ch <= 'Z';
    }

    private static boolean isAlphaLower(char ch) {
        return ch == ' ' || ch >= 'a' && ch <= 'z';
    }

    private static boolean isMixed(char ch) {
        return MIXED[ch] != -1;
    }

    private static boolean isPunctuation(char ch) {
        return PUNCTUATION[ch] != -1;
    }

    private static boolean isText(char ch) {
        return ch == '\t' || ch == '\n' || ch == '\r' || ch >= ' ' && ch <= '~';
    }

    private static int determineConsecutiveDigitCount(CharSequence msg, int startpos) {
        int count = 0;
        int idx = startpos;
        int len = msg.length();
        if (idx < len) {
            char ch = msg.charAt(idx);
            while (PDF417HighLevelEncoder.isDigit(ch) && idx < len) {
                ++count;
                if (++idx >= len) continue;
                ch = msg.charAt(idx);
            }
        }
        return count;
    }

    private static int determineConsecutiveTextCount(CharSequence msg, int startpos) {
        int len = msg.length();
        int idx = startpos;
        while (idx < len) {
            int numericCount;
            char ch = msg.charAt(idx);
            for (numericCount = 0; numericCount < 13 && PDF417HighLevelEncoder.isDigit(ch) && idx < len; ++numericCount) {
                if (++idx >= len) continue;
                ch = msg.charAt(idx);
            }
            if (numericCount >= 13) {
                return idx - startpos - numericCount;
            }
            if (numericCount > 0) continue;
            ch = msg.charAt(idx);
            if (!PDF417HighLevelEncoder.isText(ch)) break;
            ++idx;
        }
        return idx - startpos;
    }

    private static int determineConsecutiveBinaryCount(CharSequence msg, byte[] bytes, int startpos) throws WriterException {
        int idx;
        int len = msg.length();
        for (idx = startpos; idx < len; ++idx) {
            int i;
            int i2;
            char ch = msg.charAt(idx);
            int numericCount = 0;
            while (numericCount < 13 && PDF417HighLevelEncoder.isDigit(ch) && (i2 = idx + ++numericCount) < len) {
                ch = msg.charAt(i2);
            }
            if (numericCount >= 13) {
                return idx - startpos;
            }
            int textCount = 0;
            while (textCount < 5 && PDF417HighLevelEncoder.isText(ch) && (i = idx + ++textCount) < len) {
                ch = msg.charAt(i);
            }
            if (textCount >= 5) {
                return idx - startpos;
            }
            ch = msg.charAt(idx);
            if (bytes[idx] != 63 || ch == '?') continue;
            throw new WriterException("Non-encodable character detected: " + ch + " (Unicode: " + ch + ')');
        }
        return idx - startpos;
    }

    static {
        byte b;
        int i;
        TEXT_MIXED_RAW = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 38, 13, 9, 44, 58, 35, 45, 46, 36, 47, 43, 37, 42, 61, 94, 0, 32, 0, 0, 0};
        TEXT_PUNCTUATION_RAW = new byte[]{59, 60, 62, 64, 91, 92, 93, 95, 96, 126, 33, 13, 9, 44, 58, 10, 45, 46, 36, 47, 34, 124, 42, 40, 41, 63, 123, 125, 39, 0};
        MIXED = new byte[128];
        PUNCTUATION = new byte[128];
        Arrays.fill(MIXED, (byte)-1);
        for (i = 0; i < TEXT_MIXED_RAW.length; i = (int)((byte)(i + 1))) {
            b = TEXT_MIXED_RAW[i];
            if (b <= 0) continue;
            PDF417HighLevelEncoder.MIXED[b] = i;
        }
        Arrays.fill(PUNCTUATION, (byte)-1);
        for (i = 0; i < TEXT_PUNCTUATION_RAW.length; i = (int)((byte)(i + 1))) {
            b = TEXT_PUNCTUATION_RAW[i];
            if (b <= 0) continue;
            PDF417HighLevelEncoder.PUNCTUATION[b] = i;
        }
    }
}

