/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.common.util.http;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.conn.DnsResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WxDnsResolver
implements DnsResolver {
    private static final String WECHAT_API_URL = "api.weixin.qq.com";
    private static Map<String, InetAddress[]> MAPPINGS = new HashMap<String, InetAddress[]>();
    protected final Logger log = LoggerFactory.getLogger(WxDnsResolver.class);
    private String wxApiIp;

    public WxDnsResolver(String ip) {
        this.wxApiIp = ip;
        this.init();
    }

    private void init() {
        if (this.log.isDebugEnabled()) {
            this.log.debug("init wechat dns config with ip {}", (Object)this.wxApiIp);
        }
        try {
            MAPPINGS.put(WECHAT_API_URL, new InetAddress[]{InetAddress.getByName(this.wxApiIp)});
        }
        catch (UnknownHostException e) {
            this.log.error("init WxDnsResolver error", (Throwable)e);
            MAPPINGS = new HashMap<String, InetAddress[]>();
        }
    }

    public InetAddress[] resolve(String host) throws UnknownHostException {
        return MAPPINGS.containsKey(host) ? MAPPINGS.get(host) : new InetAddress[]{};
    }

    public String getWxApiIp() {
        return this.wxApiIp;
    }

    public void setWxApiIp(String wxApiIp) {
        this.wxApiIp = wxApiIp;
        this.init();
    }
}

