/*
 * Decompiled with CFR 0.152.
 */
package net.coobird.thumbnailator.makers;

import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.Map;
import net.coobird.thumbnailator.builders.BufferedImageBuilder;
import net.coobird.thumbnailator.resizers.DefaultResizerFactory;
import net.coobird.thumbnailator.resizers.FixedResizerFactory;
import net.coobird.thumbnailator.resizers.Resizer;
import net.coobird.thumbnailator.resizers.ResizerFactory;

public abstract class ThumbnailMaker {
    private static final String NOT_READY_FOR_MAKE = "Maker not ready to make thumbnail.";
    private static final String PARAM_IMAGE_TYPE = "imageType";
    private static final String PARAM_RESIZER = "resizer";
    private static final String PARAM_RESIZERFACTORY = "resizerFactory";
    protected final ReadinessTracker ready = new ReadinessTracker();
    private static final int DEFAULT_IMAGE_TYPE = 2;
    protected int imageType;
    protected ResizerFactory resizerFactory;

    public ThumbnailMaker() {
        this.ready.unset(PARAM_IMAGE_TYPE);
        this.ready.unset(PARAM_RESIZER);
        this.ready.unset(PARAM_RESIZERFACTORY);
        this.defaultImageType();
        this.defaultResizerFactory();
    }

    public abstract BufferedImage make(BufferedImage var1);

    protected BufferedImage makeThumbnail(BufferedImage bufferedImage, int n, int n2) {
        if (!this.ready.isReady()) {
            throw new IllegalStateException(NOT_READY_FOR_MAKE);
        }
        if (n <= 0) {
            throw new IllegalArgumentException("Width must be greater than zero.");
        }
        if (n2 <= 0) {
            throw new IllegalArgumentException("Height must be greater than zero.");
        }
        BufferedImage bufferedImage2 = new BufferedImageBuilder(n, n2, this.imageType).build();
        Dimension dimension = new Dimension(bufferedImage.getWidth(), bufferedImage.getHeight());
        Dimension dimension2 = new Dimension(n, n2);
        Resizer resizer = this.resizerFactory.getResizer(dimension, dimension2);
        resizer.resize(bufferedImage, bufferedImage2);
        return bufferedImage2;
    }

    public ThumbnailMaker imageType(int n) {
        this.imageType = n;
        this.ready.set(PARAM_IMAGE_TYPE);
        return this;
    }

    public ThumbnailMaker defaultImageType() {
        return this.imageType(2);
    }

    public ThumbnailMaker resizer(Resizer resizer) {
        this.resizerFactory = new FixedResizerFactory(resizer);
        this.ready.set(PARAM_RESIZER);
        this.ready.set(PARAM_RESIZERFACTORY);
        return this;
    }

    public ThumbnailMaker defaultResizer() {
        return this.defaultResizerFactory();
    }

    public ThumbnailMaker resizerFactory(ResizerFactory resizerFactory) {
        this.resizerFactory = resizerFactory;
        this.ready.set(PARAM_RESIZER);
        this.ready.set(PARAM_RESIZERFACTORY);
        return this;
    }

    public ThumbnailMaker defaultResizerFactory() {
        this.resizerFactory = DefaultResizerFactory.getInstance();
        this.ready.set(PARAM_RESIZER);
        this.ready.set(PARAM_RESIZERFACTORY);
        return this;
    }

    protected static final class ReadinessTracker {
        private final Map<String, Boolean> alreadySetMap = new HashMap<String, Boolean>();

        protected ReadinessTracker() {
        }

        protected boolean isReady() {
            for (Map.Entry<String, Boolean> entry : this.alreadySetMap.entrySet()) {
                if (entry.getValue().booleanValue()) continue;
                return false;
            }
            return true;
        }

        protected void unset(String string) {
            this.alreadySetMap.put(string, false);
        }

        protected void set(String string) {
            this.alreadySetMap.put(string, true);
        }

        protected boolean isSet(String string) {
            return this.alreadySetMap.get(string);
        }
    }
}

