/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cab.passport.passportorder.service;

import com.cab.passport.passportorder.dao.PassportOrderDao;
import com.cab.passport.passportorder.entity.PassportOrder;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.service.CrudService;
import com.thinkgem.jeesite.common.utils.RESTResponse;
import com.thinkgem.jeesite.common.utils.ZAException;
import net.sf.json.JSONObject;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
 * 护照订单Service
 *
 * @author lgl
 * @version 2018-10-09
 */
@Service
@Transactional(readOnly = true)
public class PassportOrderService extends CrudService<PassportOrderDao, PassportOrder> {

    public PassportOrder get(String id) {
        return super.get(id);
    }

    public List<PassportOrder> findList(PassportOrder passportOrder) {
        return super.findList(passportOrder);
    }

    public Page<PassportOrder> findPage(Page<PassportOrder> page, PassportOrder passportOrder) {
        return super.findPage(page, passportOrder);
    }

    @Transactional(readOnly = false)
    public void save(PassportOrder passportOrder) {
        super.save(passportOrder);
    }

    @Transactional(readOnly = false)
    public void delete(PassportOrder passportOrder) {
        super.delete(passportOrder);
    }

    @Transactional(readOnly = false)
    public RESTResponse active(String json) {
        // 获取参数
        JSONObject jo = JSONObject.fromObject(json);
        //参数校验
        activeValidateParameter(jo);
        //查询实体
        PassportOrder po = dao.getByIdentificationFlag(jo.getString("identificationFlag"));
        if (!jo.getString("cabPassport").equals(po.getCabPassport())) {
            throw new ZAException("信息有误");
        }
        //业务校验
        if (StringUtils.isNotBlank(po.getPetOwnerMobile())) {
            throw new ZAException("该宠物已激活");
        }
        //保存激活信息
        po.setPetOwnerName(jo.getString("petOwnerName"));
        po.setPetOwnerMobile(jo.getString("petOwnerMobile"));
        po.setPetOwnerAddress(jo.getString("petOwnerAddress"));
        save(po);
        return new RESTResponse();
    }

    private void activeValidateParameter(JSONObject jo) {
        if (!jo.containsKey("identificationFlag") || StringUtils.isBlank(jo.getString("identificationFlag"))) {
            throw new ZAException("identificationFlag为空");
        }
        if (!jo.containsKey("cabPassport") || StringUtils.isBlank(jo.getString("cabPassport"))) {
            throw new ZAException("cabPassport为空");
        }
        if (!jo.containsKey("petOwnerName") || StringUtils.isBlank(jo.getString("petOwnerName"))) {
            throw new ZAException("petOwnerName为空");
        }
        if (!jo.containsKey("petOwnerMobile") || StringUtils.isBlank(jo.getString("petOwnerMobile"))) {
            throw new ZAException("petOwnerMobile为空");
        }
        if (!jo.containsKey("petOwnerAddress") || StringUtils.isBlank(jo.getString("petOwnerAddress"))) {
            throw new ZAException("petOwnerAddress为空");
        }
    }
}