/*
 * Decompiled with CFR 0.152.
 */
package com.chongaibao.cabpub.sdk.util;

import com.alibaba.fastjson.JSONObject;
import com.chongaibao.cabpub.sdk.signature.StringUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChongaibaoSdkHttpUtils {
    private static final String DEFAULT_CHARSET = "UTF-8";

    private ChongaibaoSdkHttpUtils() {
    }

    public static String doPost(String url, Map<String, String> params, int connectTimeout, int readTimeout) throws IOException {
        return ChongaibaoSdkHttpUtils.doPost(url, params, DEFAULT_CHARSET, connectTimeout, readTimeout);
    }

    public static String doPost(String url, Map<String, String> params, String charset, int connectTimeout, int readTimeout) throws IOException {
        return ChongaibaoSdkHttpUtils.doPost(url, params, charset, connectTimeout, readTimeout, (Map<String, String>)null);
    }

    public static String doPost(String url, Map<String, String> params, String charset, int connectTimeout, int readTimeout, Map<String, String> headerMap) throws IOException {
        String ctype = "application/json;charset=" + charset;
        String query = ChongaibaoSdkHttpUtils.buildQueryJson(params, charset);
        byte[] content = new byte[]{};
        if (query != null) {
            content = query.getBytes(charset);
        }
        return ChongaibaoSdkHttpUtils.doPost(url, ctype, content, connectTimeout, readTimeout, headerMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String doPost(String url, String ctype, byte[] content, int connectTimeout, int readTimeout, Map<String, String> headerMap) throws IOException {
        HttpURLConnection conn = null;
        OutputStream out = null;
        String rsp = null;
        try {
            conn = ChongaibaoSdkHttpUtils.getConnection(new URL(url), "POST", ctype, headerMap);
            conn.setConnectTimeout(connectTimeout);
            conn.setReadTimeout(readTimeout);
            out = conn.getOutputStream();
            out.write(content);
            rsp = ChongaibaoSdkHttpUtils.getResponseAsString(conn);
        }
        finally {
            if (out != null) {
                out.close();
            }
            if (conn != null) {
                conn.disconnect();
            }
        }
        return rsp;
    }

    public static String buildQueryForm(Map<String, String> params, String charset) throws IOException {
        if (params != null && !params.isEmpty()) {
            StringBuilder query = new StringBuilder();
            Set<Map.Entry<String, String>> entries = params.entrySet();
            boolean hasParam = false;
            for (Map.Entry<String, String> entry : entries) {
                String value;
                String name = entry.getKey();
                if (!StringUtils.isNotBlank(name, value = entry.getValue())) continue;
                if (hasParam) {
                    query.append("&");
                } else {
                    hasParam = true;
                }
                query.append(name).append("=").append(URLEncoder.encode(value, charset));
            }
            return query.toString();
        }
        return null;
    }

    public static String buildQueryJson(Map<String, String> params, String charset) throws IOException {
        if (params != null && !params.isEmpty()) {
            JSONObject jsonObject = new JSONObject();
            for (Map.Entry<String, String> entry : params.entrySet()) {
                jsonObject.put(entry.getKey(), (Object)entry.getValue());
            }
            return jsonObject.toJSONString();
        }
        return null;
    }

    private static HttpURLConnection getConnection(URL url, String method, String ctype, Map<String, String> headerMap) throws IOException {
        HttpURLConnection conn = null;
        if ("https".equals(url.getProtocol())) {
            SSLContext entry = null;
            try {
                entry = SSLContext.getInstance("TLS");
                entry.init(new KeyManager[0], new TrustManager[]{new DefaultTrustManager()}, new SecureRandom());
            }
            catch (Exception var7) {
                throw new IOException(var7);
            }
            HttpsURLConnection connHttps = (HttpsURLConnection)url.openConnection();
            connHttps.setSSLSocketFactory(entry.getSocketFactory());
            connHttps.setHostnameVerifier(new HostnameVerifier(){

                public boolean verify(String hostname, SSLSession session) {
                    return true;
                }
            });
            conn = connHttps;
        } else {
            conn = (HttpURLConnection)url.openConnection();
        }
        conn.setRequestMethod(method);
        conn.setDoInput(true);
        conn.setDoOutput(true);
        conn.setRequestProperty("Accept", "text/xml,text/javascript,text/html");
        conn.setRequestProperty("User-Agent", "top-sdk-java");
        conn.setRequestProperty("Content-Type", ctype);
        if (headerMap != null) {
            for (Map.Entry<String, String> entry1 : headerMap.entrySet()) {
                conn.setRequestProperty(entry1.getKey(), entry1.getValue());
            }
        }
        return conn;
    }

    public static Map<String, String> splitUrlQuery(String query) {
        HashMap<String, String> result = new HashMap<String, String>();
        String[] pairs = query.split("&");
        if (pairs != null && pairs.length > 0) {
            String[] var6 = pairs;
            int var5 = pairs.length;
            for (int var4 = 0; var4 < var5; ++var4) {
                String pair = var6[var4];
                String[] param = pair.split("=", 2);
                if (param == null || param.length != 2) continue;
                result.put(param[0], param[1]);
            }
        }
        return result;
    }

    protected static String getResponseAsString(HttpURLConnection conn) throws IOException {
        String charset = ChongaibaoSdkHttpUtils.getResponseCharset(conn.getContentType());
        InputStream es = conn.getErrorStream();
        if (es == null) {
            return ChongaibaoSdkHttpUtils.getStreamAsString(conn.getInputStream(), charset);
        }
        String msg = ChongaibaoSdkHttpUtils.getStreamAsString(es, charset);
        if (StringUtils.isBlank(msg)) {
            throw new IOException(conn.getResponseCode() + ":" + conn.getResponseMessage());
        }
        return msg;
    }

    private static String getResponseCharset(String ctype) {
        String charset = DEFAULT_CHARSET;
        if (StringUtils.isNotBlank(ctype)) {
            String[] params;
            String[] var6 = params = ctype.split(";");
            int var5 = params.length;
            for (int var4 = 0; var4 < var5; ++var4) {
                String param = var6[var4];
                if (!(param = param.trim()).startsWith("charset")) continue;
                String[] pair = param.split("=", 2);
                if (pair.length != 2 || StringUtils.isBlank(pair[1])) break;
                charset = pair[1].trim();
                break;
            }
        }
        return charset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getStreamAsString(InputStream stream, String charset) throws IOException {
        try {
            String var7;
            int read1;
            InputStreamReader reader = new InputStreamReader(stream, charset);
            StringBuilder response = new StringBuilder();
            char[] buff = new char[1024];
            boolean read = false;
            while ((read1 = reader.read(buff)) > 0) {
                response.append(buff, 0, read1);
            }
            String string = var7 = response.toString();
            return string;
        }
        finally {
            if (stream != null) {
                stream.close();
            }
        }
    }

    public static String doGet(String url, Map<String, String> params) throws IOException {
        return ChongaibaoSdkHttpUtils.doGet(url, params, DEFAULT_CHARSET);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String doGet(String url, Map<String, String> params, String charset) throws IOException {
        HttpURLConnection conn = null;
        String rsp = null;
        try {
            String ctype = "application/x-www-form-urlencoded;charset=" + charset;
            String query = ChongaibaoSdkHttpUtils.buildQueryJson(params, charset);
            conn = ChongaibaoSdkHttpUtils.getConnection(ChongaibaoSdkHttpUtils.buildGetUrl(url, query), "GET", ctype, null);
            rsp = ChongaibaoSdkHttpUtils.getResponseAsString(conn);
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
        return rsp;
    }

    private static URL buildGetUrl(String strUrl, String query) throws IOException {
        URL url = new URL(strUrl);
        if (StringUtils.isBlank(query)) {
            return url;
        }
        strUrl = StringUtils.isBlank(url.getQuery()) ? (strUrl.endsWith("?") ? strUrl + query : strUrl + "?" + query) : (strUrl.endsWith("&") ? strUrl + query : strUrl + "&" + query);
        return new URL(strUrl);
    }

    private static class DefaultTrustManager
    implements X509TrustManager {
        private DefaultTrustManager() {
        }

        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }

        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }
    }
}

