/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.editor.language.json.converter;

import java.util.Map;
import org.activiti.bpmn.model.BaseElement;
import org.activiti.bpmn.model.EventSubProcess;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.GraphicInfo;
import org.activiti.bpmn.model.SubProcess;
import org.activiti.editor.language.json.converter.BaseBpmnJsonConverter;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.node.ArrayNode;
import org.codehaus.jackson.node.ObjectNode;

public class EventSubProcessJsonConverter
extends BaseBpmnJsonConverter {
    public static void fillTypes(Map<String, Class<? extends BaseBpmnJsonConverter>> convertersToBpmnMap, Map<Class<? extends BaseElement>, Class<? extends BaseBpmnJsonConverter>> convertersToJsonMap) {
        EventSubProcessJsonConverter.fillJsonTypes(convertersToBpmnMap);
        EventSubProcessJsonConverter.fillBpmnTypes(convertersToJsonMap);
    }

    public static void fillJsonTypes(Map<String, Class<? extends BaseBpmnJsonConverter>> convertersToBpmnMap) {
        convertersToBpmnMap.put("EventSubProcess", EventSubProcessJsonConverter.class);
    }

    public static void fillBpmnTypes(Map<Class<? extends BaseElement>, Class<? extends BaseBpmnJsonConverter>> convertersToJsonMap) {
        convertersToJsonMap.put(EventSubProcess.class, EventSubProcessJsonConverter.class);
    }

    @Override
    protected String getStencilId(FlowElement flowElement) {
        return "EventSubProcess";
    }

    @Override
    protected void convertElementToJson(ObjectNode propertiesNode, FlowElement flowElement) {
        SubProcess subProcess = (SubProcess)flowElement;
        propertiesNode.put("activitytype", "Event-Sub-Process");
        propertiesNode.put("subprocesstype", "Embedded");
        ArrayNode subProcessShapesArrayNode = this.objectMapper.createArrayNode();
        GraphicInfo graphicInfo = this.model.getGraphicInfo(flowElement.getId());
        this.processor.processFlowElements(subProcess.getFlowElements(), this.model, subProcessShapesArrayNode, graphicInfo.getX() + this.subProcessX, graphicInfo.getY() + this.subProcessY);
        this.flowElementNode.put("childShapes", (JsonNode)subProcessShapesArrayNode);
    }

    @Override
    protected FlowElement convertJsonToElement(JsonNode elementNode, JsonNode modelNode, Map<String, JsonNode> shapeMap) {
        EventSubProcess subProcess = new EventSubProcess();
        JsonNode childShapesArray = elementNode.get("childShapes");
        this.processor.processJsonElements(childShapesArray, modelNode, (BaseElement)subProcess, shapeMap);
        return subProcess;
    }
}

