/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.rest.common.api;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.activiti.engine.ActivitiIllegalArgumentException;
import org.activiti.engine.identity.Group;
import org.activiti.rest.common.api.ActivitiUtil;
import org.activiti.rest.common.application.ActivitiRestApplication;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.util.ISO8601DateFormat;
import org.restlet.data.Form;
import org.restlet.data.MediaType;
import org.restlet.data.Reference;
import org.restlet.data.Status;
import org.restlet.resource.ServerResource;

public class SecuredResource
extends ServerResource {
    protected static final String USER = "user";
    protected static final String ADMIN = "admin";
    protected ISO8601DateFormat isoFormatter = new ISO8601DateFormat();
    protected String loggedInUser;

    public String createFullResourceUrl(String[] urlFragments, Object ... arguments) {
        Reference url = this.getRequest().getRootRef().clone();
        for (String urlFragment : urlFragments) {
            url.addSegment(MessageFormat.format(urlFragment, arguments));
        }
        return url.toString();
    }

    public MediaType resolveMediaType(String resourceName) {
        return ((ActivitiRestApplication)this.getApplication()).getMediaTypeResolver().resolveMediaType(resourceName);
    }

    public <T extends ActivitiRestApplication> T getApplication(Class<T> applicationClass) {
        return (T)((Object)((ActivitiRestApplication)this.getApplication()));
    }

    public String getAttribute(String name) {
        return this.decode((String)this.getRequest().getAttributes().get(name));
    }

    protected String getQueryParameter(String name, Form query) {
        return query.getFirstValue(name);
    }

    protected Integer getQueryParameterAsInt(String name, Form query) {
        Integer result = null;
        String stringValue = this.getQueryParameter(name, query);
        if (stringValue != null) {
            try {
                result = Integer.parseInt(stringValue);
            }
            catch (NumberFormatException nfe) {
                throw new ActivitiIllegalArgumentException("The given value for query-parameter '" + name + "' is not an integer: " + stringValue);
            }
        }
        return result;
    }

    protected Boolean getQueryParameterAsBoolean(String name, Form query) {
        String stringValue = this.getQueryParameter(name, query);
        if (stringValue != null) {
            if (Boolean.TRUE.toString().equals(stringValue.toLowerCase())) {
                return Boolean.TRUE;
            }
            if (Boolean.FALSE.toString().equals(stringValue.toLowerCase())) {
                return Boolean.FALSE;
            }
            throw new ActivitiIllegalArgumentException("The given value for query-parameter '" + name + "' should be one fo 'true' or 'false', instead of: " + stringValue);
        }
        return null;
    }

    protected Date getQueryParameterAsDate(String name, Form query) {
        Date result = null;
        String stringValue = this.getQueryParameter(name, query);
        if (stringValue != null) {
            try {
                result = this.isoFormatter.parse(stringValue);
            }
            catch (ParseException e) {
                throw new ActivitiIllegalArgumentException("The given value for query-parameter '" + name + "' is not a valid date: " + stringValue, (Throwable)e);
            }
            catch (IllegalArgumentException e) {
                throw new ActivitiIllegalArgumentException("The given value for query-parameter '" + name + "' is not a valid date: " + stringValue, (Throwable)e);
            }
        }
        return result;
    }

    protected String decode(String string) {
        if (string != null) {
            try {
                return URLDecoder.decode(string, "UTF-8");
            }
            catch (UnsupportedEncodingException uee) {
                throw new IllegalStateException("JVM does not support UTF-8 encoding.", uee);
            }
        }
        return null;
    }

    protected boolean authenticate() {
        return this.authenticate(null);
    }

    protected boolean authenticate(String group) {
        this.loggedInUser = ((ActivitiRestApplication)this.getApplication()).authenticate(this.getRequest(), this.getResponse());
        if (this.loggedInUser == null) {
            this.setStatus(this.getAuthenticationFailureStatus(), "Authentication is required");
            return false;
        }
        if (group == null) {
            ActivitiUtil.getIdentityService().setAuthenticatedUserId(this.loggedInUser);
            return true;
        }
        boolean allowed = false;
        List groupList = ActivitiUtil.getIdentityService().createGroupQuery().groupMember(this.loggedInUser).list();
        if (groupList != null) {
            for (Group groupObject : groupList) {
                if (!groupObject.getId().equals(group)) continue;
                allowed = true;
                ActivitiUtil.getIdentityService().setAuthenticatedUserId(this.loggedInUser);
                break;
            }
        }
        if (!allowed) {
            this.setStatus(this.getAuthenticationFailureStatus(), "User is not part of the group " + group);
        }
        return allowed;
    }

    protected Map<String, Object> retrieveVariables(JsonNode jsonNode) {
        HashMap<String, Object> variables = new HashMap<String, Object>();
        if (jsonNode != null) {
            Iterator itName = jsonNode.getFieldNames();
            while (itName.hasNext()) {
                String name = (String)itName.next();
                JsonNode valueNode = jsonNode.path(name);
                if (valueNode.isBoolean()) {
                    variables.put(name, valueNode.getBooleanValue());
                    continue;
                }
                if (valueNode.isInt()) {
                    variables.put(name, valueNode.getIntValue());
                    continue;
                }
                if (valueNode.isLong()) {
                    variables.put(name, valueNode.getLongValue());
                    continue;
                }
                if (valueNode.isDouble()) {
                    variables.put(name, valueNode.getDoubleValue());
                    continue;
                }
                if (valueNode.isTextual()) {
                    variables.put(name, valueNode.getTextValue());
                    continue;
                }
                variables.put(name, valueNode.getValueAsText());
            }
        }
        return variables;
    }

    protected Status getAuthenticationFailureStatus() {
        return Status.CLIENT_ERROR_UNAUTHORIZED;
    }
}

