/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.editor.language.json.converter;

import java.util.Iterator;
import java.util.Map;
import org.activiti.bpmn.model.BaseElement;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.UserTask;
import org.activiti.editor.language.json.converter.BaseBpmnJsonConverter;
import org.apache.commons.lang3.StringUtils;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.node.ArrayNode;
import org.codehaus.jackson.node.ObjectNode;

public class UserTaskJsonConverter
extends BaseBpmnJsonConverter {
    public static void fillTypes(Map<String, Class<? extends BaseBpmnJsonConverter>> convertersToBpmnMap, Map<Class<? extends BaseElement>, Class<? extends BaseBpmnJsonConverter>> convertersToJsonMap) {
        UserTaskJsonConverter.fillJsonTypes(convertersToBpmnMap);
        UserTaskJsonConverter.fillBpmnTypes(convertersToJsonMap);
    }

    public static void fillJsonTypes(Map<String, Class<? extends BaseBpmnJsonConverter>> convertersToBpmnMap) {
        convertersToBpmnMap.put("UserTask", UserTaskJsonConverter.class);
    }

    public static void fillBpmnTypes(Map<Class<? extends BaseElement>, Class<? extends BaseBpmnJsonConverter>> convertersToJsonMap) {
        convertersToJsonMap.put(UserTask.class, UserTaskJsonConverter.class);
    }

    @Override
    protected String getStencilId(FlowElement flowElement) {
        return "UserTask";
    }

    @Override
    protected void convertElementToJson(ObjectNode propertiesNode, FlowElement flowElement) {
        UserTask userTask = (UserTask)flowElement;
        String assignee = userTask.getAssignee();
        String candidateUsers = this.convertListToCommaSeparatedString(userTask.getCandidateUsers());
        String candidateGroups = this.convertListToCommaSeparatedString(userTask.getCandidateGroups());
        if (StringUtils.isNotEmpty((CharSequence)assignee) || StringUtils.isNotEmpty((CharSequence)candidateUsers) || StringUtils.isNotEmpty((CharSequence)candidateGroups)) {
            ObjectNode assignmentItemNode;
            ObjectNode assignmentNode = this.objectMapper.createObjectNode();
            ArrayNode itemsNode = this.objectMapper.createArrayNode();
            if (StringUtils.isNotEmpty((CharSequence)assignee)) {
                assignmentItemNode = this.objectMapper.createObjectNode();
                assignmentItemNode.put("assignment_type", "assignee");
                assignmentItemNode.put("resourceassignmentexpr", assignee);
                itemsNode.add((JsonNode)assignmentItemNode);
            }
            if (StringUtils.isNotEmpty((CharSequence)candidateUsers)) {
                assignmentItemNode = this.objectMapper.createObjectNode();
                assignmentItemNode.put("assignment_type", "candidateUsers");
                assignmentItemNode.put("resourceassignmentexpr", candidateUsers);
                itemsNode.add((JsonNode)assignmentItemNode);
            }
            if (StringUtils.isNotEmpty((CharSequence)candidateGroups)) {
                assignmentItemNode = this.objectMapper.createObjectNode();
                assignmentItemNode.put("assignment_type", "candidateGroups");
                assignmentItemNode.put("resourceassignmentexpr", candidateGroups);
                itemsNode.add((JsonNode)assignmentItemNode);
            }
            assignmentNode.put("totalCount", itemsNode.size());
            assignmentNode.put("items", (JsonNode)itemsNode);
            propertiesNode.put("usertaskassignment", (JsonNode)assignmentNode);
        }
        if (userTask.getPriority() != null) {
            this.setPropertyValue("prioritydefinition", userTask.getPriority().toString(), propertiesNode);
        }
        this.setPropertyValue("formkeydefinition", userTask.getFormKey(), propertiesNode);
        this.setPropertyValue("duedatedefinition", userTask.getDueDate(), propertiesNode);
        this.setPropertyValue("categoryDefinition", userTask.getCategory(), propertiesNode);
        this.addFormProperties(userTask.getFormProperties(), propertiesNode);
    }

    @Override
    protected FlowElement convertJsonToElement(JsonNode elementNode, JsonNode modelNode, Map<String, JsonNode> shapeMap) {
        JsonNode itemsNode;
        UserTask task = new UserTask();
        task.setPriority(this.getPropertyValueAsString("prioritydefinition", elementNode));
        task.setFormKey(this.getPropertyValueAsString("formkeydefinition", elementNode));
        task.setDueDate(this.getPropertyValueAsString("duedatedefinition", elementNode));
        task.setCategory(this.getPropertyValueAsString("categoryDefinition", elementNode));
        JsonNode assignmentNode = this.getProperty("usertaskassignment", elementNode);
        if (assignmentNode != null && (itemsNode = assignmentNode.get("items")) != null) {
            Iterator assignmentIterator = itemsNode.getElements();
            while (assignmentIterator.hasNext()) {
                JsonNode assignmentItemNode = (JsonNode)assignmentIterator.next();
                if (assignmentItemNode.get("assignment_type") == null || assignmentItemNode.get("resourceassignmentexpr") == null) continue;
                String assignmentType = assignmentItemNode.get("assignment_type").asText();
                if ("assignee".equals(assignmentType)) {
                    task.setAssignee(assignmentItemNode.get("resourceassignmentexpr").asText());
                    continue;
                }
                if ("candidateUsers".equals(assignmentType)) {
                    task.setCandidateUsers(this.getValueAsList("resourceassignmentexpr", assignmentItemNode));
                    continue;
                }
                if (!"candidateGroups".equals(assignmentType)) continue;
                task.setCandidateGroups(this.getValueAsList("resourceassignmentexpr", assignmentItemNode));
            }
        }
        this.convertJsonToFormProperties(elementNode, (BaseElement)task);
        return task;
    }
}

