/*
 * Decompiled with CFR 0.152.
 */
package com.ckfinder.connector.handlers.command;

import com.ckfinder.connector.configuration.IConfiguration;
import com.ckfinder.connector.errors.ConnectorException;
import com.ckfinder.connector.handlers.command.IPostCommand;
import com.ckfinder.connector.handlers.command.XMLCommand;
import com.ckfinder.connector.utils.AccessControlUtil;
import com.ckfinder.connector.utils.FileUtils;
import java.io.File;
import javax.servlet.http.HttpServletRequest;
import org.w3c.dom.Element;

public class RenameFileCommand
extends XMLCommand
implements IPostCommand {
    private String fileName;
    private String newFileName;
    private boolean renamed;
    private boolean addRenameNode;

    protected void createXMLChildNodes(int errorNum, Element rootElement) throws ConnectorException {
        if (this.addRenameNode) {
            this.createRenamedFileNode(rootElement);
        }
    }

    private void createRenamedFileNode(Element rootElement) {
        Element element = this.creator.getDocument().createElement("RenamedFile");
        element.setAttribute("name", this.fileName);
        if (this.renamed) {
            element.setAttribute("newName", this.newFileName);
        }
        rootElement.appendChild(element);
    }

    protected int getDataForXml() {
        int checkFileExt;
        if (!AccessControlUtil.getInstance(this.configuration).checkFolderACL(this.type, this.currentFolder, this.userRole, 64)) {
            return 103;
        }
        if (this.configuration.forceASCII()) {
            this.newFileName = FileUtils.convertToASCII(this.newFileName);
        }
        if (this.fileName != null && !this.fileName.equals("") && this.newFileName != null && !this.newFileName.equals("")) {
            this.addRenameNode = true;
        }
        if ((checkFileExt = FileUtils.checkFileExtension(this.newFileName, this.configuration.getTypes().get(this.type), this.configuration, true)) == 1) {
            return 105;
        }
        if (checkFileExt == 2) {
            this.newFileName = FileUtils.renameFileWithBadExt(this.newFileName);
        }
        if (!FileUtils.checkFileName(this.fileName) || FileUtils.checkIfFileIsHidden(this.fileName, this.configuration)) {
            return 109;
        }
        if (!FileUtils.checkFileName(this.newFileName, this.configuration) || FileUtils.checkIfFileIsHidden(this.newFileName, this.configuration)) {
            return 102;
        }
        if (FileUtils.checkFileExtension(this.fileName, this.configuration.getTypes().get(this.type), this.configuration, false) == 1) {
            return 109;
        }
        String dirPath = this.configuration.getTypes().get(this.type).getPath() + this.currentFolder;
        File file = new File(dirPath, this.fileName);
        File newFile = new File(dirPath, this.newFileName);
        File dir = new File(dirPath);
        try {
            if (!file.exists()) {
                return 117;
            }
            if (newFile.exists()) {
                return 115;
            }
            if (!dir.canWrite() || !file.canWrite()) {
                return 104;
            }
            this.renamed = file.renameTo(newFile);
            if (this.renamed) {
                this.renameThumb();
                return 0;
            }
            return 104;
        }
        catch (SecurityException e) {
            if (this.configuration.isDebugMode()) {
                throw e;
            }
            return 104;
        }
    }

    private void renameThumb() {
        File thumbFile = new File(this.configuration.getThumbsPath() + File.separator + this.type + this.currentFolder, this.fileName);
        File newThumbFile = new File(this.configuration.getThumbsPath() + File.separator + this.type + this.currentFolder, this.newFileName);
        thumbFile.renameTo(newThumbFile);
    }

    public void initParams(HttpServletRequest request, IConfiguration configuration, Object ... params) throws ConnectorException {
        super.initParams(request, configuration, new Object[0]);
        this.fileName = this.getParameter(request, "fileName");
        this.newFileName = this.getParameter(request, "newFileName");
    }
}

