//商城首页
define(["knockout"],function(ko){
    return function(context){
        var me = this;
        //列表数据
        me.listData = ko.observableArray([]);
        //商品类别
        me.goodClassList = ko.observableArray([{id:"0",name:"全部",className:"active"}]);
        //商品类别
        me.classId = ko.observable("");
        //返利:否0；是1
        me.isRebate = ko.observable("");
        //商品名称
        me.name = ko.observable("");
        //买赠：否0;是1
        me.buyGifts = ko.observable("");
        //每页多少条数据
        me.pageSize = ko.observable(8);
        //第几页
        me.pageNo = ko.observable(1);
        //页码列表
        me.pageArray = ko.observableArray();

        me.showBuyGifts = ko.observable("");
        me.showIsRebate = ko.observable("");
        me.showAll = ko.observable("active");

        //商城购物车
        me.shopGoodList = ko.observableArray([]);
        me.shopNum = ko.observable("0");
        me.shopTotalPrice = ko.observable("0");
        //上一页
        me.pagePre = function(){
            if(me.pageNo()>1){
                me.pageNo(me.pageNo()-1);
            }
            me.findshopGoodList(false);
        }

        me.pageNext = function(){
            if(me.pageNo()<parseInt(me.pageArray().pop()["pageNo"])){
                me.pageNo(me.pageNo()+1);
            }
            me.findshopGoodList(false);
        }

        me.pageAction = function(data){
            if(data.pageNo == -1){
                //什么都不做
            }else if(me.pageNo() == data.pageNo){
                //alert("当前选中的就是该页");
                me.findshopGoodList(false);
            }else{
                //alert(data.pageNo);//做一些分页啥的
                me.pageNo(data.pageNo);
                me.findshopGoodList(false);
            }
            return false;
        }
        /**
         * 展现购物车
         */
        me.showCarts = function(){
            if($("#cartsDiv").css("display")=="none"){
                $("#cartsDiv").css("display","block");
            }else{
                $("#cartsDiv").css("display","none");
            }
        }
        /**
         * 查询商品列表
         */
        me.findshopGoodList = function(isreset){
            if(isreset){
                me.pageNo(1);
            };
            var sendData = {};
            sendData["classId"] = me.classId();
            sendData["isRebate"] = me.isRebate();
            sendData["name"] = me.name();
            sendData["buyGifts"] = me.buyGifts();
            sendData["pageSize"] = me.pageSize();
            sendData["pageNo"] = me.pageNo();
            util.sendAjax({
                url:'shop/shopGoods',
                data:sendData,
                async:true,
                loadFlag:true,
                type:'GET',
                cache:false,
                success:function(json){
                    if(json.rc==0){
                        if(json.list!=null && json.list.length>0){
                            var list = json.list;
                            for(var i=0;i<list.length;i++){
                                if(util.isVal(list[i].image)==""){
                                    list[i].indexList = "images/default.png";
                                }else{
                                    list[i].indexList = "/oa-web/api/v1/file/image/"+list[i].imageList[0];
                                }
                            }
                            me.listData(json.list);
                        }else{
                            me.listData([]);
                            layer.msg("商品列表数据为空！");
                        }
                        //计算总页数和分页的参数
                        console.log("json.total="+json.total);
                        me.pageArray(util.getPageArray(me.pageNo(),json.total,me.pageSize()));
                    }else{
                        layer.msg("查询商品列表失败,错误代码:"+json.rc+"错误信息:"+json.msg);
                    }
                }
            });

        }
        /**
         * 选择分类方法
         * @param data
         */
        me.checkClass = function(data){
            if(data.id=="0"){
                $("#classDiv a[name='className0']").attr("class","active");
                me.classId("");
            }else{
                $("#classDiv a[name='className0']").attr("class"," ");
                me.classId(data.id);
            }
            var list = me.goodClassList();
            var preList = [];
            for(var i=0;i<list.length;i++){
                if(list[i].id==data.id){
                    list[i].className="active";
                }else{
                    list[i].className="";
                }
                preList.push(list[i]);
                me.goodClassList(preList);
            }
            me.findshopGoodList(true);
        }
        /**
         * 选择买赠，返利
         * @param type
         */
        me.checkType = function(type){
            if(type==0){
                me.buyGifts(1);
                me.isRebate("");
                me.showBuyGifts("active");
                me.showIsRebate("");
                me.showAll("");
            }else{
                me.buyGifts("");
                me.isRebate(1);
                me.showBuyGifts("");
                me.showIsRebate("active");
                me.showAll("");
            }
            me.findshopGoodList(true);
        }
        /**
         * 选择全部
         */
        me.checkTypeAll = function(){
            me.buyGifts("");
            me.isRebate("");
            me.showBuyGifts("");
            me.showIsRebate("");
            me.showAll("active");
            me.findshopGoodList(true);
        }
        /**
         *查询商品类别
         */
        me.findshopGoodClassList = function(){
            util.sendAjax({
                url:'shop/shopGoodsClass',
                data:{},
                async:false,
                type:'GET',
                cache:false,
                success:function(data){
                    if(data.rc==0){
                        var list = data.list;
                        for(var i=0;i<list.length;i++){
                            var obj = list[i];
                            obj["className"] = "";
                            me.goodClassList.push(obj);
                        }
                    }else{
                        layer.msg("查询商品类别失败,错误代码:"+json.rc+"错误信息:"+json.msg);
                    }
                }
            });

        }
        /**
         * 添加购物车
         */
        me.addCarts = function(data){
            //买5返1，买10返3
            if(data.buyGifts=="满5返1,满10返3"){
                util.sendAjax({
                    url:'shop/shopGoods/getBuyGifts',
                    data:{id:data.id},
                    async:false,
                    type:'GET',
                    cache:false,
                    success:function(json){
                        var html="";
                        $.each(json.list,function(index,item){
                            html+="<option value=\""+item.id+"\">"+item.name+"</option>";
                        });
                        layer.open({
                            type: 1,
                            title:'选择赠品',
                            area: ['420px', '240px'], //宽高
                            closeBtn: 0, //不显示关闭按钮
                            shift: 2,
                            shadeClose: true, //开启遮罩关闭
                            content: '<div style="padding:40px 0 10px"><span style="display:inline-block;line-height:40px;padding-left:10px;float:left;">赠品：</span><div class="form-f" style="margin-left:60px;"><select name="" id="buyGiftsId" style="height:40px;line-height:40px;>'+html+'</select></div>',
                            btn: ['确定', '关闭'],
                            yes:function(index, layero){
                                var buyGiftsGoods = $("#buyGiftsId").val();
                                layer.close(index);
                                if(util.isVal(buyGiftsGoods)==""){
                                    layer.msg("请选择买赠商品");
                                }else{
                                    me.sendAddCarts(data,1,buyGiftsGoods);
                                }

                            }
                        });
                    }
                });
            }
            //买10返2
            if(data.buyGifts=="满10返2"){
                util.sendAjax({
                    url:'shop/shopGoods/getBuyGifts',
                    data:{id:data.id},
                    async:false,
                    type:'GET',
                    cache:false,
                    success:function(json){
                        var html="";
                        $.each(json.list,function(index,item){
                            html+="<option value=\""+item.id+"\">"+item.name+"</option>";
                        });
                        layer.open({
                            type: 1,
                            title:'选择赠品',
                            area: ['420px', '240px'], //宽高
                            closeBtn: 0, //不显示关闭按钮
                            shift: 2,
                            shadeClose: true, //开启遮罩关闭
                            content: '<div style="padding:40px 0 10px"><span style="display:inline-block;line-height:40px;padding-left:10px;float:left;">赠品：</span><div class="form-f" style="margin-left:60px;"><select name="" id="buyGiftsId" style="height:40px;line-height:40px;>'+html+'</select></div>',
                            btn: ['确定', '关闭'],
                            yes:function(index, layero){
                                var buyGiftsGoods = $("#buyGiftsId").val();
                                layer.close(index);
                                if(util.isVal(buyGiftsGoods)==""){
                                    layer.msg("请选择买赠商品");
                                }else{
                                    me.sendAddCarts(data,2,buyGiftsGoods);
                                }
                            }
                        });
                    }
                });
            }
            if(data.buyGifts==""){
                me.sendAddCarts(data,0,null);
            }
        }
        me.sendAddCarts = function(data,type,buyGiftsGoods){
            console.log(buyGiftsGoods);
            var sendData = {};
            sendData["goodsId"] =data.id ;
            if(type==0){
                sendData["goodsNum"] = "1" ;
                sendData["buyGiftsGoods"] = "";
            }else if(type==1){
                sendData["goodsNum"] = "5" ;
                sendData["buyGiftsGoods"] = buyGiftsGoods;
            }else{
                sendData["goodsNum"] = "10" ;
                sendData["buyGiftsGoods"] = buyGiftsGoods;
            }

            util.sendAjax({
                url:'shop/shopCarts',
                data:JSON.stringify(sendData),
                async:true,
                loadFlag:true,
                type:'POST',
                cache:false,
                success:function(json){
                    if(json.rc==0){
                        layer.msg("加入购物车成功！");
                        context.app.changeShopCart();
                        me.shopGoodList(context.app.shopGoodList());
                        me.shopNum(context.app.shopNum());
                        me.shopTotalPrice(context.app.shopTotalPrice());
                    }else{
                        layer.msg("添加购物车失败,错误代码:"+json.rc+"错误信息:"+json.msg);
                    }
                }
            });
        }
        /**
         * 跳转详细页
         */
        me.toDetail = function(data){
            location.href = location.href.split("#")[0]+"#/shop/detail?id="+data.id;
        }
        $(function(){
            me.findshopGoodClassList();
            me.findshopGoodList(false);
            me.shopGoodList(context.app.shopGoodList());
            me.shopNum(context.app.shopNum());
            me.shopTotalPrice(context.app.shopTotalPrice());
        });
        //什么都没干，就是个演示
        context.app.loading(false);
        context.app.isShop(true);
    }
});