//出生证明激活页
define(["knockout"], function (ko) {
    return function (context) {
        var me = this;
        //页面状态
        var isedit = util.getQueryString().error == '1' ? '3' : util.getQueryString().normal == '1' ? '0' : util.getQueryString().edit == '1' ? '1' : '0';
        var imgTargetNum = null;//第几张生活照
        var imgTargetThis = null;
        var containerLayer = null;
        me.isedit = ko.observable(isedit);//编辑
        me.frontViewUrl = ko.observable();//正面照
        me.lateralViewUrl = ko.observable();//侧面照
        me.backViewUrl = ko.observable();//背面照
        me.viewUrlList = ko.observableArray([""]);//生活照数组
        me.boxSelected = ko.observable(true);//是否选中
        me.saleSelected = ko.observable(true);//是否选中
        me.price = ko.observable('');//价格
        me.cityName = ko.observable("");//城市
        me.contactPer = ko.observable();//联系人
        me.phone = ko.observable();//联系方式
        me.reviewRemarks = ko.observable();//驳回原因
        me.frontPicReviewState = ko.observable();
        me.frontPicRemark = ko.observable('');
        me.sidePicReviewState = ko.observable("");
        me.sidePicRemark = ko.observable();
        me.backPicReviewState = ko.observable();
        me.backPicRemark = ko.observable();
        me.dogInfo = ko.observable({
            identificationFlag: "",
            breedCnName: "",
            dogColorMarkCn: "",
            gender: "",
            birthdate: "",
            birthCode:""
        });//犬只信息

        me.ymList = ko.observableArray([{
            date: "", name: "", show: false
        }]);//疫苗列表
        me.qcList = ko.observableArray([{
            date: "", name: "", show: false
        }]);//驱虫列表
        // this.toNum = function(){
        //     me.isedit('3');
        // }
        //默认不激活
        me.boxSelected(false);
        //默认不寄售
        me.saleSelected(false);
        //时间插件赋值
        this.timeClone = function (a, item, event) {
            var tmp = me.clone(item);
            var timer = setInterval(function(){
                if(item.date!=$(event.target).val()){
                    tmp.date = $(event.target).val();
                    if (a == 'ym') {
                        me.ymList.replace(item, tmp);
                    } else {
                        me.qcList.replace(item, tmp);
                    }
                    clearInterval(timer);
                }
            },100)
        }
        //新增驱虫或疫苗
        this.addqcym = function (a,data,event) {
            var date = $(event.target).parent().parent().find('.timeselect input').val();
            var tmp = me.clone(this);
            var obj = {
                date: "", name: "", show: false
            }
            var obj1 = {
                date: "", name: "", show: true
            }
            tmp.date = date;
            if (tmp.date != '' && tmp.name != '') {
                tmp.show = true;
                if (a == 'ym') {
                    me.ymList.replace(this, tmp);
                    if (me.ymList().length == 6) {
                        me.ymList.push(obj1);
                    } else if (me.ymList().length < 6) {
                        me.ymList.push(obj);
                    }
                } else {
                    me.qcList.replace(this, tmp);
                    if (me.qcList().length == 3) {
                        me.qcList.push(obj1);
                    } else if (me.qcList().length < 3) {
                        me.qcList.push(obj);
                    }
                }
            } else {
                tmp.show = false;
                if (a == 'ym') {
                    var text = '疫苗';
                    me.ymList.replace(this, tmp);
                } else {
                    var text = '驱虫';
                    me.qcList.replace(this, tmp);
                }
                if (tmp.date == '') {
                    layer.msg('请输入' + text + '时间')
                } else if (tmp.name == '') {
                    layer.msg('请输入' + text + '内容')
                }
            }
        };
        //删除驱虫或疫苗
        this.removeqcym = function (a) {
            if (a == 'ym') {
                me.ymList.remove(this);
                var obj = {
                    date: "", name: "", show: false
                }
                if (me.ymList().length == 6) {
                    if(me.ymList()[me.ymList().length-1].show !=false){
                        for(var i =0;i<me.ymList().length;i++){
                            var q = me.clone(me.ymList()[i]);
                            q.show = true;
                            me.ymList.replace(me.ymList()[i],q);
                        }
                        me.ymList.push(obj);
                    }
                }
            } else {
                me.qcList.remove(this);
                var obj = {
                    date: "", name: "", show: false
                }
                if (me.qcList().length == 3) {
                    if(me.qcList()[me.qcList().length-1].show!=false){
                        for(var i =0;i<me.qcList().length;i++){
                            var q = me.clone(me.qcList()[i]);
                            q.show = true;
                            me.qcList.replace(me.qcList()[i],q);
                        }
                        me.qcList.push(obj);
                    }
                }
            }
        }


        //删除生活照
        this.removelifepic = function () {
            var arr =me.viewUrlList();
            for (var i=0;i<arr.length;i++){
                if(arr[i] == this){
                    arr.splice(i,1);
                }
            }
            if(arr.length < 5 && arr[arr.length-1]!=''){
                arr.push('')
            };
            me.viewUrlList(arr);
        }

        //用做ko更新数组某一项数据时的克隆，无需重新清空并绑定整个列表
        me.clone = function (source) {
            var obj = {};
            for (var p in source)
                obj[p] = source[p];
            return obj;
        };
        //选中反选
        me.toggle = function () {
            if (me.boxSelected()) {
                var index = layer.confirm('不推荐本犬会将失去多渠道销售的机会，您确定不推荐吗？', {
                    btn: ['再想想', '去意已决'] //按钮
                }, function () {
                    layer.close(index);
                }, function () {
                    me.boxSelected(false);
                    me.saleSelected(false);
                });
            } else {
                me.boxSelected(true);
            }
        }
        //选中反选
        me.saletoggle = function () {
            if (me.saleSelected()) {
                    me.saleSelected(false);
            } else {
                me.saleSelected(true);
            }
        }
        //返回
        me.goback = function () {
            history.go(-1);
        }
        //截图初始化方法
        var initCropper = function (img, input) {
            var $image = img;
            var options = {
                aspectRatio: 1, // 纵横比
                viewMode: 0,
                dragMode: 'none', cropBoxResizable: true, responsive: false, minCanvasHeight: 300, minCanvasWidth: 300,autoCropArea:1,
                //background:true,
                preview: '.img-preview' // 预览图的class名
            };
            $image.cropper(options);
            var $inputImage = input;
            var uploadedImageURL;
            if (URL) {

                // 给input添加监听
                me.fileChange = function (num, item, event) {
                    imgTargetNum = num;
                    imgTargetThis = this;
                    //捕获页
                    containerLayer = layer.open({
                        type: 1,
                        shade: false,
                        title: "裁剪图片", //不显示标题
                        content: $('.container-layer'), //捕获的元素，注意：最好该指定的元素要存放在body最外层，否则可能被其它的相对元素所影响
                        area: ['700px', '450px'], //宽高
                        // cancel: function(){
                        //     layer.msg('捕获就是从页面已经存在的元素上，包裹layer的结构', {time: 5000, icon:6});
                        // }
                    });

                    var files = event.target.files;
                    var file;
                    if (!$image.data('cropper')) {
                        return;
                    }
                    if (files && files.length) {
                        file = files[0];
                        // 判断是否是图像文件
                        if (/^image\/\w+$/.test(file.type)) {
                            // 如果URL已存在就先释放
                            if (uploadedImageURL) {
                                URL.revokeObjectURL(uploadedImageURL);
                            }
                            uploadedImageURL = URL.createObjectURL(file);
                            // 销毁cropper后更改src属性再重新创建cropper
                            $image.cropper('destroy').attr('src', uploadedImageURL).cropper(options);
                            $(event.target).val('');
                        } else {
                            window.alert('请选择一个图像文件！');
                        }
                    }
                }
            } else {
                $inputImage.prop('disabled', true).addClass('disabled');
            }
        }
        me.fileChange = function () {
        }
        //截图
        this.crop = function (item, event) {
            layer.closeAll();
            var that = this;
            var $image = $('#photo');
            $image.cropper('getCroppedCanvas', {
                width: 1600, // 裁剪后的长宽
                height: 1600
            }).toBlob(function (blob) {
                layer.load();
                var formData = new FormData();
                formData.append('file', blob);
                formData.append('module', 'pupImg');
                $.ajax({
                    url: '/oa-web/api/v1/file/dogActivation',
                    method: 'POST',
                    data: formData,
                    contentType: false,
                    processData: false,
                    cache: false,
                    success: function (json) {
                        if (json != undefined && json.rc != undefined && json.rc == 2103) {
                            window.location.href = "/oa-web/uc/index.html";
                        } else {
                            if (json.rc == 0) {
                                urladress(imgTargetNum, json.data.id);
                            } else {
                                layer.msg("图片上传失败:" + data.msg);
                            }
                        }
                    },
                    error: function (XMLHttpRequest, status, error) {
                        if (XMLHttpRequest.status == 401) {
                            window.location.href = "/oa-web/uc/login.html";
                            return;
                        }
                        layer.msg('网络连接错误！', {icon: 5});
                    },
                    complete: function (XMLHttpRequest, TS) {
                        layer.closeAll('loading');
                    }
                });
                // 裁剪后将图片放到指定标签
            }, "image/jpeg", 0.95);
        }

        //图片上传后回显
        function urladress(a, id) {
            if (a > 10) {
                if (a == 11) {
                    me.frontViewUrl('/oa-web/api/v1/file/image/' + id);
                } else if (a == 12) {
                    me.lateralViewUrl('/oa-web/api/v1/file/image/' + id);
                } else if (a == 13) {
                    me.backViewUrl('/oa-web/api/v1/file/image/' + id);
                }
            } else {
                var tmp = me.viewUrlList();
                //tmp.splice(tmp.length-1,1, '/oa-web/api/v1/file/image/'+id);
                tmp[a] = '/oa-web/api/v1/file/image/' + id;
                if (me.viewUrlList().length < 5 && a == me.viewUrlList().length - 1) {
                    me.viewUrlList().push('')
                };
                me.viewUrlList(tmp);
            }
        }

        //提取图片ID用于上传
        function urlToId(obj) {
            if (typeof(obj) == 'object') {
                var str = '';
                obj.forEach(function (value, index) {
                    if (value != '') {
                        var arr = value.split('/');
                        obj[index] = arr[arr.length - 1];
                    } else {
                        obj.splice(index, 1)
                    }
                })
                return obj.join(',');
            } else {
                var arr = obj.split('/');
                return arr[arr.length - 1];
            }
        }

        function objToMap(obj) {
            var map = [];
            obj.forEach(function (value, index) {
                if (value.date != '' && value.value != '') {
                    map.push({
                        date:value.date,
                        name:value.name
                    })
                }
            })
            if(obj.length == 1 && obj[0].date == "" && obj[0].name == ""){
                map = [];
            }
            return map;
        }

        function mapToObj(obj) {
            if(obj.length > 0){
                for (var i = 0;i<obj.length;i++) {
                    obj[i].show = true;
                }
                obj[obj.length - 1].show = false;
            }else{
                obj = [];
                obj.push({
                    date: "", name: "", show: false
                });
            }
            return obj;
        }

        me.validPrice = function (item, event) {
            var num = parseFloat($(event.target).val());
            if (num > 0 && num < 1000001) {
                $(event.target).val(Math.round(num));
                me.price(Math.round(num));
            } else {
                $(event.target).val('');
                me.price('');
            }
        }
        me.formatPrice = function(item,event){
            var num =me.price();
            if(num == ''){
                return
            }
            var rem = num % 100;
            if(rem!=0){
                me.price(JSON.stringify(num*1-rem*1+100));
            }
        }
        me.validconcatPer = function (item, event) {
            var str = $(event.target).val();
            var b = str.replace(/[^\u4e00-\u9fa5a-zA-Z\ ]/g, "");
            $(event.target).val(b.substring(0,10));
        }
        me.validphone = function (item, event) {
            var str = $(event.target).val();
            var b = str.replace(/[^\d]/g, "");
            if(str[0] == 1){
                $(event.target).val(b.substring(0,11));
            }else{
                $(event.target).val('');
            }
        }
        //提交
        this.submit = function () {
            me.cityName($("#citySelect").val())
            if (me.price() == '' && me.boxSelected()) {
                layer.msg('请添加您的报价')
            } else if ((me.cityName() == '' || me.cityName() == undefined) && me.boxSelected()) {
                layer.msg('请输入犬只所在地')
            } else if (me.frontViewUrl() == '' || me.frontViewUrl() == undefined) {
                layer.msg('请上传完犬只的标准照片')
            } else if (me.lateralViewUrl() == '' || me.lateralViewUrl() == undefined) {
                layer.msg('请上传完犬只的标准照片')
            } else if (me.backViewUrl() == '' || me.backViewUrl() == undefined) {
                layer.msg('请上传完犬只的标准照片')
            } else if ((me.phone() == '' || me.phone() == undefined) && me.boxSelected()) {
                layer.msg('请填写联系方式')
            } else if ((me.contactPer() == '' || me.contactPer() == undefined) && me.boxSelected()) {
                layer.msg('请填写联系人姓名')
            } else {
                for(var i=0;i<me.ymList().length;i++){
                    var item = me.ymList()[i];
                    if((item.date=="" ||  item.name=="") && !(item.date=="" &&  item.name=="")){
                        layer.msg("疫苗列表未填写完整");
                        return false
                    }
                }
                for(var i=0;i<me.qcList().length;i++){
                    var item = me.qcList()[i];
                    if((item.date=="" ||  item.name=="") && !(item.date=="" &&  item.name=="")){
                        layer.msg("驱虫列表未填写完整");
                        return false
                    }
                }
                me.cityName($("#citySelect").val())
                if(!me.boxSelected()){
                    var originalObj = JSON.parse(localStorage.getItem('original') || '{}');
                    me.cityName(originalObj.citySelect || '')
                    //me.price(originalObj.price || '')
                    me.phone(originalObj.phone || '')
                    me.contactPer(originalObj.contactPer || '')
                }
                localStorage.removeItem('original');
                var obj = {
                    immune: objToMap(me.ymList()),
                    anthelmintic: objToMap(me.qcList())
                }
                var data = {
                    city: me.cityName(),
                    price: me.price(),
                    mobile: me.phone(),
                    lifePic: urlToId(me.viewUrlList()),
                    sidePic: urlToId(me.lateralViewUrl()),
                    birthCode: me.birthCode || '',
                    frontPic: urlToId(me.frontViewUrl()),
                    backPic: urlToId(me.backViewUrl()),
                    linkman: me.contactPer(),
                    healthInfo: JSON.stringify(obj),
                    state: me.boxSelected() ? '1' : '0',
                    consign:me.saleSelected() ? '1' : '0',
                    type:'1'
                }
                util.sendAjax({
                    url: '/dog/dogActivation',
                    data: JSON.stringify(data),
                    async: true,
                    loadFlag: true,
                    type: me.isedit() == 0 ? "POST" : "PUT",
                    cache: false,
                    success: function (data) {
                        if (data.rc == 0) {
                            location.href = location.href.split("#")[0] + "#/dog/birthcertificatelist";
                        } else {
                            layer.msg("提交失败:" + data.msg);
                        }
                    }
                });
            }
        }


        function getDogInfo() {
            var birthCerRegCode = me.birthCode = util.getQueryString().birthCerRegCode;
            util.sendAjax({
                url: '/dog/dogActivation/getDogInfo/' + birthCerRegCode,
                data: {},
                async: true,
                loadFlag: true,
                type: 'GET',
                cache: false,
                success: function (data) {
                    if (data.rc == 0) {
                        me.dogInfo(data.data);
                        me.cityName(data.data.city);
                        me.phone(data.data.mobile);
                        me.contactPer(data.data.linkman);
                        //me.price(data.data.price);

                        //$("#price").attr("placeholder","参考价格¥"+data.data.lowEstimatedPrice+"~¥"+data.data.highEstimatedPrice)
                        var obj = {
                            phone:data.data.mobile,
                            contactPer:data.data.linkman,
                            //price:data.data.price,
                            price:'',
                            citySelect:data.data.city
                        };
                        localStorage.setItem('original',JSON.stringify(obj));
                    } else {
                        layer.msg("犬只信息获取失败:" + data.msg);
                    }
                }
            });
        }

        function editDogInfo() {
            var birthCerRegCode = me.birthCode = util.getQueryString().birthCerRegCode;
            util.sendAjax({
                url: '/dog/dogActivation?birthCode=' + birthCerRegCode,
                data: {},
                async: true,
                loadFlag: true,
                type: 'GET',
                cache: false,
                success: function (data) {
                    if (data.rc == 0) {
                        me.dogInfo(data.data);
                        me.cityName(data.data.city);
                        me.price(data.data.price);
                        me.frontViewUrl(data.data.frontPic);
                        me.lateralViewUrl(data.data.sidePic);
                        me.backViewUrl(data.data.backPic);
                        me.phone(data.data.mobile);
                        me.contactPer(data.data.linkman);
                        me.viewUrlList(data.data.lifePic.split(','));
                        me.ymList(mapToObj(data.data.healthInfo.immune));
                        me.qcList(mapToObj(data.data.healthInfo.anthelmintic));
                        me.boxSelected(data.data.state == 1)
                        me.saleSelected(data.data.consign == 1)
                        me.reviewRemarks(data.data.reviewRemarks);
                        me.frontPicReviewState(data.data.frontPicReviewState == 2);
                        me.frontPicRemark(data.data.frontPicRemark);
                        me.sidePicReviewState(data.data.sidePicReviewState == 2);
                        me.sidePicRemark(data.data.sidePicRemark);
                        me.backPicReviewState(data.data.backPicReviewState == 2);
                        me.backPicRemark(data.data.backPicRemark);
                        //$("#price").attr("placeholder","参考价格¥"+data.data.lowEstimatedPrice+"~¥"+data.data.highEstimatedPrice)
                        var priceStr = data.data.price;
                        var obj = {
                            phone:data.data.mobile,
                            contactPer:data.data.linkman,
                            price:me.price(),
                            citySelect:data.data.city
                        };
                        localStorage.setItem('original',JSON.stringify(obj));
                    } else {
                        layer.msg("犬只信息获取失败:" + data.msg);
                    }
                }
            });
        }

        $(function () {
            if (me.isedit() == 0) {
                getDogInfo();
            } else {
                editDogInfo();
            }
            var timer = setInterval(function(){
                if (me.isedit() != 2 && $("#citySelect")) {
                    var test = new Vcity.CitySelector({input: 'citySelect'});
                    clearInterval(timer);
                }
            },500);
            var timer1 = setInterval(function(){
                if($('#photo') && $('#frontView')){
                    initCropper($('#photo'), $('#frontView'))
                    clearInterval(timer1);
                }
            },500);
        });
        context.app.loading(false);
        context.app.isShop(false);
    }
});
