<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>证书换发管理</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
			//悬浮提示插件
			$(document).tooltip();
		});
		function page(n,s){
			$("#pageNo").val(n);
			$("#pageSize").val(s);
			$("#searchForm").submit();
        	return false;
        }
	</script>
	<!-- 悬浮提示插件 -->
	<link rel="stylesheet" href="${ctxStatic}/jquery-ui/1.12.0/jquery-ui.min.css">
	<script src="${ctxStatic}/jquery-ui/1.12.0/jquery-ui.min.js"></script>
</head>
<body>
	<ul class="nav nav-tabs">
		<li class="active"><a href="${ctxDc}/dogPedigreeCertifiedChange">证书换发列表</a></li>
	</ul>
	<form:form id="searchForm" modelAttribute="dogPedigreeCertifiedChange" action="${ctxDc}/dogPedigreeCertifiedChange" method="post" class="breadcrumb form-search">
		<input id="pageNo" name="pageNo" type="hidden" value="${page.pageNo}"/>
		<input id="pageSize" name="pageSize" type="hidden" value="${page.pageSize}"/>
		<ul class="ul-form">
			<li><label>血统证书编号：</label>
				<form:input path="overseasPedigreeCertifiedLike" htmlEscape="false" maxlength="64" class="input-medium"/>
			</li>
			<li><label>会员号/姓名：</label>
				<form:input path="paymentMemberCode" htmlEscape="false" maxlength="64" class="input-medium"/>
			</li>
			<li><label>机构名称：</label>
				<form:input path="orgName" htmlEscape="false" maxlength="100" class="input-medium"/>
			</li>
			<li><label>审核状态：</label>
				<form:select path="reviewState" class="input-medium">
					<form:option value="" label="全部"/>
					<form:option value="0" label="待审核"/>
					<form:option value="1" label="通过"/>
					<form:option value="2" label="未通过"/>
				</form:select>
			</li>
			<li><label>订单状态：</label>
				<form:select path="paymentState" class="input-medium">
					<form:option value="" label="全部"/>
					<form:options items="${fns:getDictList('user_payment_state')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
				</form:select>
			</li>
		</ul>
		<ul class="ul-form">
			<li><label>处理状态：</label>
				<form:select path="processState" class="input-medium">
					<form:option value="" label="全部"/>
					<form:options items="${fns:getDictList('proccess_state')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
				</form:select>
			</li>
			<li><label>申请日期：</label>
				<input name="beginCreateDate" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate"
					value="<fmt:formatDate value="${dogPedigreeCertifiedChange.beginCreateDate}" pattern="yyyy-MM-dd"/>"
					onclick="WdatePicker({dateFmt:'yyyy-MM-dd',isShowClear:true});"/> -
				<input name="endCreateDate" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate"
					value="<fmt:formatDate value="${dogPedigreeCertifiedChange.endCreateDate}" pattern="yyyy-MM-dd"/>"
					onclick="WdatePicker({dateFmt:'yyyy-MM-dd',isShowClear:true});"/>
			</li>
			<li><label>处理日期：</label>
				<input name="beginProcessDate" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate"
					value="<fmt:formatDate value="${dogPedigreeCertifiedChange.beginProcessDate}" pattern="yyyy-MM-dd"/>"
					onclick="WdatePicker({dateFmt:'yyyy-MM-dd',isShowClear:true});"/> -
				<input name="endProcessDate" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate"
					value="<fmt:formatDate value="${dogPedigreeCertifiedChange.endProcessDate}" pattern="yyyy-MM-dd"/>"
					onclick="WdatePicker({dateFmt:'yyyy-MM-dd',isShowClear:true});"/>
			</li>
			<li><label>是否确认芯片：</label>
				<form:select path="dogChipCheck" class="input-medium">
					<form:option value="" label="全部"/>
					<form:option value="1" label="是"/>
					<form:option value="0" label="否"/>
				</form:select>
			</li>
			<li><label>是否采集DNA：</label>
				<form:select path="dogDnaArchiveIdFlag" class="input-medium">
					<form:option value="" label="全部"/>
					<form:option value="1" label="是"/>
					<form:option value="0" label="否"/>
				</form:select>
			</li>
			<li><label>撤销状态：</label>
				<form:select path="isCanceled" class="input-medium">
					<form:option value="" label="全部"/>
					<form:options items="${fns:getDictList('canceled_state')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
				</form:select>
			</li>
			<li class="btns"><input id="btnSubmit" class="btn btn-primary" type="submit" value="查询"/></li>
			<li class="clearfix"></li>
		</ul>
	</form:form>
	<sys:message content="${message}"/>
	<table id="contentTable" class="table table-striped table-bordered table-condensed">
		<thead>
			<tr>
				<th>国外血统证书编号</th>
				<th>CKU血统证书编号</th>
				<th>犬种</th>
				<th>犬名</th>
				<th>犬主</th>
				<th>出生日期</th>
				<th>申请日期</th>
				<th>订单状态</th>
				<th>审核状态</th>
				<th>撤销状态</th>
				<th>合作机构</th>
				<th>是否确认芯片</th>
				<th>是否采集DNA</th>
				<th>流程状态</th>
				<th>业务状态</th>
				<th>操作</th>
			</tr>
		</thead>
		<tbody>
		<c:forEach items="${page.list}" var="dogPedigreeCertifiedChange">
			<tr>
				<td>
					${fns:escapeHtml(dogPedigreeCertifiedChange.overseasPedigreeCertified)}
				</td>
				<td>
					<c:choose>
					<c:when test="${fns:startsWith(dogPedigreeCertifiedChange.overseasPedigreeCertified,'CKU')}">
						<a href="${dogInfoURL}${fns:escapeHtml(dogPedigreeCertifiedChange.overseasPedigreeCertified)}" target="_searchCode">
								${fns:escapeHtml(dogPedigreeCertifiedChange.overseasPedigreeCertified)}
						</a>
					</c:when>
					<c:otherwise>
						<a href="${dogInfoURL}${fns:escapeHtml(dogPedigreeCertifiedChange.pedigreeCertifiedCode)}" target="_searchCode">
								${fns:escapeHtml(dogPedigreeCertifiedChange.pedigreeCertifiedCode)}
						</a>
					</c:otherwise>
					</c:choose>
				</td>
				<td title="${fns:escapeHtml(dogPedigreeCertifiedChange.breedCnName)}">
					${fns:escapeHtml(dogPedigreeCertifiedChange.dogBreed)}
				</td>
				<td>
					${fns:escapeHtml(dogPedigreeCertifiedChange.dogName)}
				</td>
				<td title="${fns:escapeHtml(dogPedigreeCertifiedChange.paymentMemberCode)}">
					${fns:escapeHtml(dogPedigreeCertifiedChange.dogOwnerName)}
				</td>
				<td>
					<fmt:formatDate value="${dogPedigreeCertifiedChange.dogBirthday}" pattern="yyyy-MM-dd"/>
				</td>
				<td>
					<fmt:formatDate value="${dogPedigreeCertifiedChange.createDate}" pattern="yyyy-MM-dd"/>
				</td>
				<td style="color:${dogPedigreeCertifiedChange.paymentState=='2'?'#090':'#F00'}">
					${fns:getDictLabel(dogPedigreeCertifiedChange.paymentState, 'user_payment_state', '')}
				</td>
				<td style="color:#000" title="${fns:escapeHtml(dogPedigreeCertifiedChange.reviewRemarks)}">
							${fns:getDictLabel(dogPedigreeCertifiedChange.reviewState, 'review_state', '')}
				</td>
				<td>
					<c:choose>
						<c:when test="${'1' eq dogPedigreeCertifiedChange.isCanceled}">
							已撤销
						</c:when>
						<c:otherwise>
							<c:if test="${dogPedigreeCertifiedChange.isCanCancel=='0'|| empty dogPedigreeCertifiedChange.isCanCancel}">
								未撤销
							</c:if>
						</c:otherwise>
					</c:choose>
				</td>
				<td>
					${fns:escapeHtml(dogPedigreeCertifiedChange.orgName)}
				</td>
				<td>
					<c:if test="${newBusinessTimeMillis-dogPedigreeCertifiedChange.createDate.time < 0}">
						<c:if test="${dogPedigreeCertifiedChange.dogChipCheck=='0'}">
							<font color="#F00">否</font>
						</c:if>
						<c:if test="${dogPedigreeCertifiedChange.dogChipCheck=='1'}">
							<font color="#090">是</font>
						</c:if>
					</c:if>
				</td>
				<td>
					<c:if test="${newBusinessTimeMillis-dogPedigreeCertifiedChange.createDate.time < 0}">
						<c:if test="${empty dogPedigreeCertifiedChange.dogDnaArchiveId}">
							<font color="#F00">否</font>
						</c:if>
						<c:if test="${not empty dogPedigreeCertifiedChange.dogDnaArchiveId}">
							<font color="#090">是</font>
						</c:if>
					</c:if>
				</td>
				<td>
							${fns:getDictLabel(dogPedigreeCertifiedChange.processState, 'proccess_state', '')}
				</td>
				<td>
					${dogPedigreeCertifiedChange.businessState}
				</td>
				<td>
    				<a href="${ctxDc}/dogPedigreeCertifiedChange/form?id=${dogPedigreeCertifiedChange.id}">查看</a>
					<c:if test="${dogPedigreeCertifiedChange.printState=='2'}">
						<c:if test="${fns:startsWith(dogPedigreeCertifiedChange.overseasPedigreeCertified,'CKU') && not empty dogPedigreeCertifiedChange.overseasPedigreeCertified}">
							<a href="${ctxDc}/dogPedigreeCertifiedChange/print?id=${dogPedigreeCertifiedChange.id}">打印</a>
						</c:if>
						<c:if test="${not empty dogPedigreeCertifiedChange.pedigreeCertifiedCode}">
							<a href="${ctxDc}/dogPedigreeCertifiedChange/print?id=${dogPedigreeCertifiedChange.id}">打印</a>
						</c:if>
					</c:if>
					<c:if test="${dogPedigreeCertifiedChange.printState=='02'}">
						<a href="${ctxDc}/dogPedigreeCertifiedChange/resetPrint?id=${dogPedigreeCertifiedChange.id}">重置打印</a>
					</c:if>
				</td>
			</tr>
		</c:forEach>
		</tbody>
	</table>
	<div class="pagination">${page}</div>
</body>
</html>