<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>报名信息修改</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
			$("#inputForm").validate({
				submitHandler: function(form){
					var showDogBreedValue = $("input[name='showDogBreed']:checked").val();
					if(showDogBreedValue == '无'){
						var value = $("#showDogBreedId").val();
						if(value == ''){
							alert("请填写比赛犬种");
							return false;
						}
					}
					loading('正在提交，请稍等...');
					form.submit();
				},
				errorContainer: "#messageBox",
				errorPlacement: function(error, element) {
					$("#messageBox").text("输入有误，请先更正。");
					if (element.is(":checkbox")||element.is(":radio")||element.parent().is(".input-append")){
						error.appendTo(element.parent().parent());
					} else {
						error.insertAfter(element);
					}
				}
			});
			
			if("${groomerShow.showCategory}"=='3'){
				if('${fns:splitContains(groomerRegister.showLevel,"国际宠物美容师",",")}' != 'true'){
					$("#moxing").hide();
				}
				$("input[type='radio'][name='showLevel']").change(function(){
					if($(this).val()=='国际宠物美容师'){
						$("#moxing").show();
					}else{
						$("#moxing").hide();
						if($('input[type=radio][name=showDogBreed]:checked').val()=='模型'){
							$("input[type='radio'][name='showDogBreed'][value='贵宾']").attr("checked","true");	
						}
					}
				});
			}
			if('${groomerShow.showCategory}' == '6'){
				var testLevel = '${groomerShow.testLevel}'.split(",");
				var showLevel = '${groomerRegister.showLevel}';
				$.each(testLevel, function (index, value){
					/*$("<input type='radio' name='showLevel' value=''>").attr("value",value).text(value).appendTo("#showLevelDiv");*/
					var levelRadioHtml = "<input type='radio' name='showLevel' value='" + value + "'>" + "<span>" + value + "</span>";
					$(levelRadioHtml).appendTo("#showLevelDiv");
					if (value === showLevel) {
						$("input[type='radio'][name='showLevel'][value='" + value + "']").prop('checked', true);
					}
				});
			}
			
			$('input[type=radio][name=showDogBreed]').change(function() {
		          if (this.value == '无') {
		              $("#showDogBreedId").removeAttr("disabled");
		          } else  {
					  $("#showDogBreedId").attr("disabled","disabled");
					  $("#showDogBreedId").val("");
		          }
		    });
			
		});
	</script>
</head>
<body>
	<ul class="nav nav-tabs">
		<li><a href="${ctxSchools}/schoolsGroomerRegister/groomerRegisterList">美容师活动列表</a></li>
		<li class="active"><a href="${ctxSchools}/schoolsGroomerRegister/form?id=${groomerRegister.id}">报名信息编辑</a></li>
	</ul>
	<form:form id="inputForm" modelAttribute="groomerRegister" action="${ctxSchools}/schoolsGroomerRegister/save" method="post" class="form-horizontal">
		<form:hidden path="id"/>
		<sys:message content="${message}"/>
		<h3>会员基本信息</h3>
		<div class="control-group">
			<label class="control-label">会员号：</label>
			<div class="controls">
				<form:input path="memberCode" htmlEscape="false" maxlength="64" class="input-xlarge required" readonly="true"/>
				<span class="help-inline"><font color="red">*</font> </span>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">姓名：</label>
			<div class="controls">
				<form:input path="name" htmlEscape="false" maxlength="64" class="input-xlarge required" readonly="true"/>
				<span class="help-inline"><font color="red">*</font></span>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">手机号：</label> 
			<div class="controls">
				<form:input path="mobile" htmlEscape="false" maxlength="100" class="input-xlarge " readonly="true"/>
				<span class="help-inline"><font color="red">*</font></span>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">性别：</label> 
			<div class="controls">
				<form:radiobuttons path="gender" items="${fns:getDictList('user_gender')}" itemLabel="label" itemValue="value" htmlEscape="false" class="required" disabled="true"/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">参赛级别：</label>
			<div class="controls">
				<c:set var="showCategory" value="${groomerShow.showCategory}"></c:set>
				<c:choose>
				    <c:when test="${showCategory eq '1'}">
						<input  name="showLevel" class="required" type="radio" value="C" ${fns:splitContains(groomerRegister.showLevel,"C",",")?"checked":""}/>
						<label>C</label>
				    </c:when>
				    <c:when test="${showCategory eq '2'}">
				    	<input name="showLevel" class="required" type="radio" value="国际宠物美容师" ${fns:splitContains(groomerRegister.showLevel,"国际宠物美容师",",")?"checked":""}/>
						<label>国际宠物美容师</label>
				    </c:when>
				    <c:when test="${showCategory eq '3'}">
				    	<input name="showLevel" class="required" type="radio" value="国际宠物美容师" ${fns:splitContains(groomerRegister.showLevel,"国际宠物美容师",",")?"checked":""}/>
						<label>国际宠物美容师</label>
						<input  name="showLevel" class="required" type="radio" value="宠物造型师&国际宠物美容师" ${fns:splitContains(groomerRegister.showLevel,"宠物造型师&国际宠物美容师",",")?"checked":""}/>
						<label>宠物造型师&国际宠物美容师</label>
				    </c:when>
				    <c:when test="${showCategory eq '4'}">
				    	<oa:dictRadios name="showLevel" type="groomer_nurse_level" value="${groomerRegister.showLevel}" rangeItems="${groomerShow.testLevel}" cssClass="required" remarks="注：切换参赛级别请重新选择比赛犬种"></oa:dictRadios>
				    </c:when>
					<c:when test="${groomerShow.showCategory eq '6'}">
						<div id = "showLevelDiv">

						</div>
						<%--<input  name="showLevel" class="required" type="radio" value="C"/>
						<label>C</label>
						<input  name="showLevel" class="required" type="radio" value="B"/>
						<label>B</label>
						<input name="showLevel" class="required" type="radio" value="A"/>
						<label>A</label>--%>
					</c:when>
					<c:when test="${showCategory eq '8'}">
						<oa:dictRadios name="showLevel" value="${groomerRegister.showLevel}" cssClass="input-xlarge required" type="groomer_cat_nurse_level" rangeItems="${groomerShow.testLevel}"></oa:dictRadios>
					</c:when>
				    <c:otherwise>
				    	活动类型错误
				    </c:otherwise>
				</c:choose>
		</div>
		<div class="control-group" style="width:80%">
			<label class="control-label">证件照：</label>
			<div class="controls">
				<!-- <img  id="avatarImg" alt="" src="" style="padding:10px;height:130px;"/> -->
				<sys:schollsSingleImgUpload module="member"  imgId="${groomerRegister.avatar}" fileSizeLimit="1024*1024*1" fileSingleSizeLimit="1024*1024*1" successCallback="uploadSuccess"/>
				<form:input path="avatar" id="avatar" htmlEscape="false" maxlength="255" class="input-xlarge " type="hidden"/>
				<!-- 文件上传成功的回调方法 -->
				<script type="text/javascript">
					function uploadSuccess(file,response){
						$("#avatar").val(response.id);
					}
				</script>
			</div>
		</div>
		<div style="clear:both;"></div>
		<h3>赛事信息</h3>	
		<div class="control-group">
			<label class="control-label">赛事名称：</label>
			<div class="controls">
				<form:input path="groomerShow.showName" htmlEscape="false" maxlength="100" class="input-xlarge required" readonly="true" />
				<span class="help-inline"><font color="red">*</font> </span>
			</div>
		</div>	
		<div class="control-group">
			<label class="control-label">赛事编号：</label>
			<div class="controls">
				<form:input path="showCode" htmlEscape="false" maxlength="100" class="input-xlarge required" readonly="true"/>
				<span class="help-inline"><font color="red">*</font> </span>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">活动分类：</label>
			<div class="controls">
					${fns:getDictLabel(groomerShow.showCategory, 'groomer_show_category', '')}
			</div>
		</div>
		
		</div>
			<div class="control-group">
			<label class="control-label">报名费：</label>
			<div class="controls">
				${fns:escapeHtml(groomerRegister.fee) }
			</div>
		</div>
		<c:set var="showLevelHidden" value="${groomerShow.showCategory eq '1' && groomerShowTypeMap['showType'] eq 'cathedra'}"></c:set>
		<div class="control-group" ${showLevelHidden?'style="display:none"':''}>
			<label class="control-label">比赛犬种：</label>
			<div class="controls">
				<c:choose>
				    <c:when test="${groomerShow.showCategory eq '4'}">
						<oa:groomerBreeds name="showDogBreed" value="${groomerRegister.showDogBreed}" otherName="showDogBreedExtra" otherValue="${groomerRegister.showDogBreedExtra}" memberElementId="memberCode" levelElementId="showLevel" isSchool="true" cssClass="input-xlarge required"></oa:groomerBreeds>
				    </c:when>
					<c:when test="${showCategory eq '8'}">
						<input name="showDogBreed" type="text" value="${groomerRegister.showDogBreed}"/>
					</c:when>
				    <c:otherwise>
						<c:choose>
							<c:when test="${groomerRegister.showDogBreed eq ''}">
								无
							</c:when>
							<c:otherwise>
				                <input name="showDogBreed" class="required" type="radio" value="贵宾" ${fns:splitContains(groomerRegister.showDogBreed,"贵宾",",")?"checked":""}/>
				                <label>贵宾</label>
				               	<input name="showDogBreed" class="required" type="radio" value="比熊" ${fns:splitContains(groomerRegister.showDogBreed,"比熊",",")?"checked":""}/>
				                <label>比熊</label>
				                <input name="showDogBreed" class="required" type="radio" value="雪纳瑞" ${fns:splitContains(groomerRegister.showDogBreed,"雪纳瑞",",")?"checked":""}/>
				                <label>雪纳瑞</label>
				                <c:if test="${groomerShow.showCategory eq '2' || groomerShow.showCategory eq '3'}">
									<div id="moxing" style="display: inline-block;">
										<input name="showDogBreed" class="required" type="radio" value="模型" ${fns:splitContains(groomerRegister.showDogBreed,"模型",",")?"checked":""}/>
										<label>模型</label>
									</div>
								</c:if>
								<input name="showDogBreed" class="required" type="radio" value="无" ${fns:splitContains(groomerRegister.showDogBreed,"无",",")?"checked":""}/>
				                <label>其他犬种:</label>
				                <input id="showDogBreedId" name="showDogBreed" type="text" ${fns:splitContains(groomerRegister.showDogBreed,"无",",")?"":"disabled"} value='${fns:replaceContainsEmpty(groomerRegister.showDogBreed,"无,贵宾,比熊,雪纳瑞,模型",",")}'/><span><font>&nbsp;&nbsp;注:多个犬种用空格分隔</font></span>
							</c:otherwise>
						</c:choose>
				    </c:otherwise>
				</c:choose>
			</div>
		</div>
		<div class="form-actions">
			<input id="btnSubmit" class="btn btn-primary" type="submit" value="提交"/>
			<input id="btnCancel" class="btn" type="button" value="返 回" onclick="history.go(-1)"/>
		</div>
	</form:form>
</body>
</html>