<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>单独展犬展成绩管理</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
			$("#btnImport").click(function(){
				$.jBox($("#importBox").html(), {title:"成绩导入", buttons:{"关闭":true}, 
					bottomText:"导入文件不能超过5M，仅允许导入“xls”或“xlsx”格式文件！"});
			});
		});
		function page(n,s){
			$("#pageNo").val(n);
			$("#pageSize").val(s);
			$("#searchForm").submit();
        	return false;
        }
	</script>
</head>
<body>
	<div id="importBox" class="hide">
		<form id="importForm" action="${ctx}/results/showResultsDdz/import" method="post" enctype="multipart/form-data"
			class="form-search" style="padding-left:20px;text-align:center;" onsubmit="loading('正在导入，请稍等...');"><br/>
			<input id="uploadFile" name="file" type="file" style="width:330px"/><br/><br/>　　
			<input id="btnImportSubmit" class="btn btn-primary" type="submit" value="   导    入   "/>
		</form>
	</div>
	<ul class="nav nav-tabs">
		<li class="active"><a href="${ctx}/results/showResultsDdz/">单独展犬展成绩列表</a></li>
	</ul>
	<form:form id="searchForm" modelAttribute="showResultsDdz" action="${ctx}/results/showResultsDdz/" method="post" class="breadcrumb form-search">
		<input id="pageNo" name="pageNo" type="hidden" value="${page.pageNo}"/>
		<input id="pageSize" name="pageSize" type="hidden" value="${page.pageSize}"/>
		<ul class="ul-form">
			<li><label>秩序号：</label>
				<form:input path="orderCode" htmlEscape="false" maxlength="5" class="input-medium"/>
			</li>
			<li><label>犬主中文名：</label>
				<form:input path="dogOwnerNameCn" htmlEscape="false" maxlength="50" class="input-medium"/>
			</li>
			<li><label>犬只证书号：</label>
				<form:input path="pedigreeCertified" htmlEscape="false" maxlength="64" class="input-medium"/>
			</li>
			<li><label>犬展编号：</label>
				<form:input path="showCode" htmlEscape="false" maxlength="64" class="input-medium"/>
			</li>
			<li class="btns"><input id="btnSubmit" class="btn btn-primary" type="submit" value="查询"/></li>
			<shiro:hasPermission name="results:showResults:edit">
			<li class="btns"><input id="btnImport" class="btn btn-primary" type="button" value="成绩导入"/></li>
			</shiro:hasPermission>
			<li class="clearfix"></li>
		</ul>
	</form:form>
	<sys:message content="${message}"/>
	<table id="contentTable" class="table table-striped table-bordered table-condensed">
		<thead>
			<tr>
			
			    <th>归属年份</th>
				<th>秩序号</th>
				<th>评价</th>
				<th>CC</th>
				<th>年龄组名次</th>
				<th>WD</th>
				<th>BOW</th>
				<th>BOV</th>
				<th>BISS</th>
				<th>本场积分</th>
				<th>单犬种积分</th>
				<th>犬主中文名</th>
				<th>犬主英文名</th>
				<th>会员号</th>
				<th>FCI代码</th>
				<th>性别</th>
				<th>年龄组别</th>
				<th>血统证书号</th>
				<th>犬展编号</th>
				<th>裁判</th>
				<th>活动区域</th>
				<th>管理</th>
			</tr>
		</thead>
		<tbody>
		<c:forEach items="${page.list}" var="showResultsDdz">
			<tr>
			<td>
					${fns:escapeHtml(showResultsDdz.year)}
				</td>
				<td>
					${fns:escapeHtml(showResultsDdz.orderCode)}
				</td>
				<td>
					${fns:escapeHtml(showResultsDdz.appraisal)}
				</td>
				<td>
					${fns:escapeHtml(showResultsDdz.resultCc)} ${fns:escapeHtml(showResultsDdz.remarksCc)}
				</td>
				<td>
					${fns:escapeHtml(showResultsDdz.rankings)}
				</td>
				<td>
					${fns:getDictLabel(showResultsDdz.resultWb, 'show_result_ddz_wb', '')}
				</td>
				<td>
					${fns:escapeHtml(showResultsDdz.resultBow)}
				</td>
				<td>
					${fns:getDictLabel(showResultsDdz.resultBob, 'show_result_ddz_bob', '')}
				</td>
				<td>
					${fns:getDictLabel(showResultsDdz.resultBiss, 'show_result_ddz_biss', '')}
				</td>
				<td>
					${fns:escapeHtml(showResultsDdz.showResult)}
				</td>
				<td>
					${fns:escapeHtml(showResultsDdz.showBreedResult)}
				</td>
				<td>
					${fns:escapeHtml(showResultsDdz.dogOwnerNameCn)}
				</td>
				<td>
					${fns:escapeHtml(showResultsDdz.dogOwnerNameEn)}
				</td>
				<td>
					${fns:escapeHtml(showResultsDdz.dogOwnerMemberCode)}
				</td>
				<td>
					${fns:escapeHtml(showResultsDdz.fciCode)}
				</td>
				<td>
					${fns:getDictLabel(showResultsDdz.dogGender, 'dog_gender', '')}
				</td>
				<td>
					${fns:getDictLabel(showResultsDdz.ageGroup, 'show_age_group', '')}
				</td>
				<td>
					${fns:escapeHtml(showResultsDdz.pedigreeCertified)}
				</td>
				<td>
					${fns:escapeHtml(showResultsDdz.showCode)}
				</td>
				<td>
					${fns:escapeHtml(showResultsDdz.referee)}
				</td>
				<td>
					${fns:escapeHtml(showResultsDdz.raceLap)}
				</td>
				<td>
				<shiro:hasPermission name="results:showResultsDdz:view">
					<a href="${ctx}/results/showResultsDdz/form?id=${showResultsDdz.id}">查看</a>
				</shiro:hasPermission>
				<shiro:hasPermission name="results:showResultsDdz:edit">
					<a href="${ctx}/results/showResultsDdz/editForm?id=${showResultsDdz.id}" target="_blank">编辑</a>
				</shiro:hasPermission>
				<shiro:hasPermission name="results:showResultsDdz:delete">
					<a href="${ctx}/results/showResultsDdz/delete?id=${showResultsDdz.id}" onclick="return confirmx('确认要删除该单独展犬展成绩吗？', this.href)">删除</a>
				</shiro:hasPermission>
				</td>
			</tr>
		</c:forEach>
		</tbody>
	</table>
	<div class="pagination">${page}</div>
</body>
</html>