<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
    <title>冠军登录信息管理</title>
    <meta name="decorator" content="default"/>
    <script type="text/javascript">
        $(document).ready(function() {
            
        });
    </script>
</head>
    <table id="contentTable" class="table table-striped table-bordered table-condensed">
        <thead>
            <tr>
                <th>缴费流水号</th>
                <th>登录类型</th>
                <th>登录序号</th>
                <th>犬主人</th>
                <th>会员号</th>
                <th>血统证书号</th>
                <th>身份识别标志</th>
                <th>犬名</th>
                <th>申请时间</th>
                <th>缴费状态</th>
                <shiro:hasPermission name="championlogin:championLogin:edit"><th>操作</th></shiro:hasPermission>
            </tr>
        </thead>
        <tbody>
        <c:forEach items="${list}" var="championLogin">
            <tr>
                <td>
                    ${fns:escapeHtml(championLogin.runningNumber) }
                </td>
                <td>
                    ${fns:getDictLabel(championLogin.loginType, 'main_login_type', fns:getDictLabel(championLogin.loginType, 'champion_login_type', ''))}
                </td>
                <td>
                    ${fns:escapeHtml(championLogin.loginCode) }
                </td>
                <td>
                    ${fns:escapeHtml(championLogin.dog.dogOwner) }
                </td>
                <td>
                    ${fns:escapeHtml(championLogin.dog.memberCode) }
                </td>
                <td>
                    ${fns:escapeHtml(championLogin.pedigreeCertified) }
                </td>
                <td>
                    ${fns:escapeHtml(championLogin.dog.identificationFlag) }
                </td>
                <td>
                    ${fns:escapeHtml(championLogin.dog.nameEn) }
                </td>
                <td>
                    <fmt:formatDate value="${championLogin.createDate}" pattern="yyyy-MM-dd HH:mm:ss"/>
                </td>
                <td>
                    <c:if test="${championLogin.paymentState=='1'}"><font color="red">
                        ${fns:getDictLabel(championLogin.paymentState, 'user_payment_state', '')}
                        </font>
                    </c:if>
                    <c:if test="${championLogin.paymentState=='2'}"><font color="green">
                        ${fns:getDictLabel(championLogin.paymentState, 'user_payment_state', '')}
                        </font>
                    </c:if>
                </td>
                <td>
                <shiro:hasPermission name="championlogin:championLogin:delete">
                 <c:if test="${!championLogin.businessRefundState}">
                    <a href="${ctx}/championlogin/championLogin/orderDelete?id=${championLogin.id}" onclick="return confirmx('确认要删除该冠军登录信息吗？', this.href)">删除</a>
                </c:if>
                </shiro:hasPermission>
                </td>
            </tr>
        </c:forEach>
        </tbody>
    </table>
</body>
</html>