<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>商品管理</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
			//$("#name").focus();
			$("#inputForm").validate({
				submitHandler: function(form){
					loading('正在提交，请稍等...');
					form.submit();
				},
				errorContainer: "#messageBox",
				errorPlacement: function(error, element) {
					$("#messageBox").text("输入有误，请先更正。");
					if (element.is(":checkbox")||element.is(":radio")||element.parent().is(".input-append")){
						error.appendTo(element.parent().parent());
					} else {
						error.insertAfter(element);
					}
				}
			});
		});
		function changeInterval(obj){
			if(obj.value==1){
				$("#intervalDetail").css("display","block");
			}else{
				$("#intervalDetail").css("display","none");
			}
		}
		function intervalNumFun(obj){
			$("#interval2Num").val(obj.value);
		}
	</script>
</head>
<body>
	<ul class="nav nav-tabs">
		<li><a href="${ctx}/shop/shopGoods/">商品列表</a></li>
		<li class="active"><a href="${ctx}/shop/shopGoods/form?id=${shopGoods.id}">商品<shiro:hasPermission name="shop:shopGoods:${not empty shopGoods.id?'edit':'add'}">${not empty shopGoods.id?'修改':'添加'}</shiro:hasPermission><shiro:lacksPermission name="shop:shopGoods:${not empty shopGoods.id?'edit':'add'}">查看</shiro:lacksPermission></a></li>
	</ul><br/>
	<form:form id="inputForm" modelAttribute="shopGoods" action="${ctx}/shop/shopGoods/save" method="post" class="form-horizontal">
		<form:hidden path="id"/>
		<sys:message content="${message}"/>
		<div class="control-group">
			<label class="control-label">分类：</label>
			<div class="controls">
				<form:select id="" path="classId" class="input-medium">
					<c:forEach items="${chassList}" var="item">
						<form:option value="${item.id}" label="${item.name}" htmlEscape="false"/>
					</c:forEach>
				</form:select>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">商品编号：</label>
			<div class="controls">
				<form:input path="code" htmlEscape="false" maxlength="100" class="input-xlarge required" title="商品编号不能为空！"/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">商品名称：</label>
			<div class="controls">
				<form:input path="name" htmlEscape="false" maxlength="100" class="input-xlarge required" title="商品名称不能为空！"/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">商品展示图：</label>
			<div class="controls">
				<c:if test="${shopGoods.image!=null && fn:length(shopGoods.imageList)>0}">
					<c:forEach items="${shopGoods.imageList}" var="img">
						<div class="thumbnail"  style="width: 200px;height: 180px;float:left;">
							<div class="caption">
								<a type="button" href="${ctx}/shop/shopGoods/delImg?id=${shopGoods.id}&imgId=${img}" class="close"><span aria-hidden="true">&times;</span><span class="sr-only"></span></a>
							</div>
							<img src="${ctx}/sys/file/image/${img}">
						</div>
					</c:forEach>
				</c:if>
			</div>
			<div class="controls">
				<sys:imageUpload module="shopGoods" fileNumLimit="10" fileSizeLimit="1024*1024*10" fileSingleSizeLimit="1024*1024*1" successCallback="uploadSuccess"/>
				<form:hidden path="image" htmlEscape="false" maxlength="100" class="input-xlarge"/>
				<!-- 文件上传成功的回调方法 -->
				<script type="text/javascript">
					function uploadSuccess(file,response){
						var image = $("#image").val();
						if(util.isVal(image)==""){
							$("#image").val(response.id);
						}else{
							$("#image").val(image+","+response.id);
						}
					}
				</script>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">商品单价：</label>
			<div class="controls">
				<form:input path="price" htmlEscape="false" class="input-xlarge required number" min="0"/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">买赠：</label>
			<div class="controls">
				<form:radiobuttons path="buyGifts" items="${fns:getDictList('goods_buygifts')}" itemLabel="label" itemValue="value" false="true" class="required"/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">返利：</label>
			<div class="controls">
				<form:radiobuttons path="isRebate" items="${fns:getDictList('yes_no')}" itemLabel="label" itemValue="value" htmlEscape="false" class="required"/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">运费：</label>
			<div class="controls">
				<form:radiobuttons path="isFreight" items="${fns:getDictList('yes_no')}" itemLabel="label" itemValue="value" htmlEscape="false" class="required"/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">分区价格：</label>
			<div class="controls">
				<form:radiobuttons path="isInterval" onclick="changeInterval(this)" items="${fns:getDictList('yes_no')}" itemLabel="label" itemValue="value" htmlEscape="false" class="required"/>
			</div>
		</div>
		<div id="intervalDetail" style="display:${shopGoods.isInterval=='1'?'block':'none'};">
			<div class="control-group">
				<label class="control-label">分区1价格：</label>
				<div class="controls">
					<form:input path="interval1Price" htmlEscape="false" class="input-xlarge number" min="0"/> <span style="color: red;">0-x*price</span>
				</div>
			</div>
			<div class="control-group">
				<label class="control-label">分区1数量：</label>
				<div class="controls">
					<form:input path="interval1Num" htmlEscape="false" onchange="intervalNumFun(this)" class="input-xlarge number" min="0"/> <span style="color: red;">0-x</span>
				</div>
			</div>
			<div class="control-group">
				<label class="control-label">分区2价格：</label>
				<div class="controls">
					<form:input path="interval2Price" htmlEscape="false" class="input-xlarge number" min="0"/> <span style="color: red;">x-y*price</span>
				</div>
			</div>
			<div class="control-group">
				<label class="control-label">分区2数量：</label>
				<div class="controls">
					<form:input path="interval2Num" htmlEscape="false" class="input-xlarge number" min="0"/> <span style="color: red;">x-y（若只有一个分区，分区1与分区2数量相等！）</span>
				</div>
			</div>
			<div class="control-group">
				<label class="control-label">分区3价格：</label>
				<div class="controls">
					<form:input path="interval3Price" htmlEscape="false" class="input-xlarge number" min="0"/> <span style="color: red;">y-&*price</span>
				</div>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">重量：</label>
			<div class="controls">
				<form:input path="weight" htmlEscape="false" maxlength="50" class="input-xlarge required number" min="0"/><span style="color: red;">　KG</span>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">标题：</label>
			<div class="controls">
				<form:input path="title" htmlEscape="false" maxlength="200" class="input-xlarge "/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">标签：</label>
			<div class="controls">
				<form:input path="tag" htmlEscape="false" maxlength="100" class="input-xlarge "/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">商品详细：</label>
			<div class="controls">
				<form:textarea path="details" htmlEscape="false" maxlength="1000" class="input-xlarge "/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">上架：</label>
			<div class="controls">
				<form:radiobuttons path="isShelves" items="${fns:getDictList('yes_no')}" itemLabel="label" itemValue="value" htmlEscape="false" class="required"/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">限购：</label>
			<div class="controls">
				<form:input path="limits" htmlEscape="false" maxlength="11" class="input-xlarge required number" checked="true"/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">数量：</label>
			<div class="controls">
				<form:input path="num" htmlEscape="false" maxlength="11" class="input-xlarge required number" min="0"/>
			</div>
		</div>
		<div class="form-actions">
			<shiro:hasPermission name="shop:shopGoods:${not empty shopGoods.id?'edit':'add'}"><input id="btnSubmit" class="btn btn-primary" type="submit" value="保 存"/>&nbsp;</shiro:hasPermission>
			<input id="btnCancel" class="btn" type="button" value="返 回" onclick="history.go(-1)"/>
		</div>
	</form:form>
</body>
</html>