<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>牵犬师电话报名录入</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
	$(document).ready(function() {
		$("#inputForm").validate({
			submitHandler: function(form){
				var memberCode=$("#memberCode").val();
				var showCode=$("#showCode").val();
				$.ajax({
					type: "POST",
	                dataType:"json",
	                url:"${ctx}/handler/handlerRegister/registerExaminerCheck?showCode="+encodeURI(showCode, "UTF-8")+"&memberCode="+memberCode,
	                async: false,
	                error: function(request, textStatus, errorThrown) {
	                    alert("请求失败！");
	                },
	                success: function(data) {
	                	if(data.rc == true){
	                		$.jBox.alert("您已经报名过了,请勿重复报名!","系统提示");
	                	}else{
	                		loading('正在提交，请稍等...');
	                		form.submit();
	                	}
	                }
				}); 
			},
			errorContainer: "#messageBox",
			errorPlacement: function(error, element) {
				$("#messageBox").text("输入有误，请先更正。");
				if (element.is(":checkbox")||element.is(":radio")||element.parent().is(".input-append")){
					error.appendTo(element.parent().parent());
				} else {
					error.insertAfter(element);
				}
			}
		});	

		// 组别展示
		$("#groupDiv").hide();
		$("#showLevel").on('change' , function(){
		     var value = $("#showLevel").val();
		     if(value == '4' || value == '7'){
		    	 $("#groupDiv").show();
			 }else{
				 $("#groupDiv").hide();
				 $('input[name="showGroup"]:checked').removeAttr("checked");
			 }
		});
		
	});
		
	
		
	</script>
</head>
<body>
	<ul class="nav nav-tabs">
		<li class="active"><a href="#">电话报名录入</a></li>
	</ul>
	<form:form id="inputForm" modelAttribute="handlerRegister" action="${ctx}/handler/handlerRegister/mobileExaminerFrom" method="post"
		class="form-horizontal">
		<input id="avatar" name="avatar" type="hidden">
		<input id="anyBreed" name="anyBreed" type="hidden">
		<input id="showDog" name="showDog" type="hidden">
		<sys:message content="${message}" />
		<h3>会员基本信息</h3>
		<div class="control-group">
			<label class="control-label">会员号：</label>
			<div class="controls">
				<form:input path="memberCode" htmlEscape="false" maxlength="100"
					class="input-xlarge required" readonly="true" />
				<input id="selectMember" class="btn btn-primary" value="查询"
					type="button" onclick="searchUser()" /> 
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">姓名：</label>
			<div class="controls">
				<form:input path="name" htmlEscape="false" maxlength="100"
					class="input-xlarge " readonly="true" />
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">手机号：</label>
			<div class="controls">
				<form:input path="mobile" htmlEscape="false" maxlength="100"
					class="input-xlarge " readonly="true" />
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">余额：</label>
			<div class="controls">
				<input type="text" readonly="readonly" id="accountBalance"
					class="input-xlarge ">
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">性别：</label>
			<div class="controls">
				<input name="gender" maxlength="50" class="input-xlarge" type="radio" value="male" readonly="readonly" /> 
				<label>男</label> 
				<input name="gender" maxlength="50"  class="input-xlarge" type="radio" value="female" readonly="readonly" /> 
				<label>女</label>
			</div>
		</div>
	 	<div class="control-group">
			<label class="control-label">培训机构：</label>
			<div class="controls">
				<form:input path="schoolNameCn" htmlEscape="false" maxlength="100" value="" class="input-xlarge required" />
				<ul>
					<li><font color="red">注:无培训机构,请填写'无'!</font></li>
				</ul>
			</div>
		</div> 
		<div style="clear: both;"></div>
		<h3>活动信息</h3>
		<div class="control-group">
			<label class="control-label">活动名称：</label>
			<div class="controls">
				<input value="${handlerShow.showName}" type="text"
					readonly="readonly" id="showName" class="input-xlarge required" />
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">活动编号：</label>
			<div class="controls">
				<input id="showCode" name="showCode" type="text"
					value="${handlerShow.showCode}" class="input-xlarge required"
					readonly="readonly" />
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">报名费：</label>
			<div class="controls">
				<input id="fee" name="fee" type="text" value="${handlerShow.fee}"
					class="input-xlarge required" readonly="readonly" />
			</div>
		</div>
		
		<div class="control-group">
			<label class="control-label">级别：</label>
			<div class="controls">
				<form:select path="showLevel" class="input-xlarge required">
					<form:option value="" label=""/>
					<form:options items="${handlerShow.showLevels}" itemLabel="label" itemValue="value" htmlEscape="false"/>
				</form:select>
			</div>
		</div>
		
		<div id="groupDiv"> 
			<div class="control-group">
			<label class="control-label">请选择组别：</label>
			<div class="controls">
				<form:checkboxes path="showGroup" items="${fns:getDictList('handler_show_group')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
			</div>
		</div>
		</div>
		
		<div id="showDog" class="control-group"></div>
		<div class="form-actions">
			<input id="btnSubmit" class="btn btn-primary" type="button" onclick="saveRegister()"
				value="保 存" />&nbsp; <input id="btnCancel"
				class="btn" type="button" value="返 回" onclick="history.go(-1)" />
		</div>
	</form:form>
	<script>
		//打开查询用户的弹窗
		function searchUser(){
			top.layer.open({
				type: 2,
				title: ['会员查询', 'font-size:18px;text-align: center;'],
				shadeClose: false,
				shade: [0.8, '#393D49'],
				maxmin: false, //开启最大化最小化按钮
				area: ['700px', '500px'],
				content: "${ctx}/sys/user/member/search"
			});
		}
		
		//查询用户完成的回调方法
		this.searchUserCallback = function (json){
			$("#memberCode").val(json.memberCode);
			$("#name").val(json.name);
            if(json.paymentState==2){
         	   $("#paymentState").text('有效');
            }else{
         	   $("#paymentState").text('无效');
            };
            $("#mobile").val(json.mobile);
            $("#avatar").val(json.avatar);
            $("#accountBalance").val(json.accountBalance);
            $("input[type=radio][name='gender'][value="+json.gender+"]").attr("checked",'checked');
            var memberCode=json.memberCode;
            var id = '${handlerShow.id}';
			/*
            $.ajax({
                type:"POST",
                url: ctx+"/handler/handlerRegister/getMemberGroup",
                data : {'memberCode':memberCode,'id':id},
                dataType: 'json',
                async: false, 
                success: function(jsons){
                	if (jsons.rc==0) {
                  		$("#showLevel").val(jsons.group);
					}else{
                  		$.jBox.alert(jsons.msg,"提示");
						$("#memberCode").val('');
						$("#name").val('');
						$("#mobile").val('');
		           		$("#accountBalance").val('');
		           		$("#schoolNameCn").val('');
		          	    $("input[type=radio][name='gender']").removeAttr("checked");
					}
                }
            });
            */
		}
		
		function saveRegister(){
			var showLevel = $("#showLevel").val();
			if('4' == showLevel){
				var result = $('input[name="showGroup"]').is(":checked");
				if(result == false){
					$.jBox.alert("请选择组别","提示");
					return false;
				}
			}
			
			$("#inputForm").submit();
		}
		

	</script>
</body>
</html>