<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>报名管理</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
			//$("#name").focus();
			$("#inputForm").validate({
				submitHandler: function(form){
					 var value = $("#showLevel").val();
				     if(value == '4'){
						var result = $('input[name="showGroups"]').is(":checked");
						if(result == false){
							$.jBox.alert("请选择组别","提示");
							return false;
						}
					 }
					
					loading('正在提交，请稍等...');
					form.submit();
				},
				errorContainer: "#messageBox",
				errorPlacement: function(error, element) {
					$("#messageBox").text("输入有误，请先更正。");
					if (element.is(":checkbox")||element.is(":radio")||element.parent().is(".input-append")){
						error.appendTo(element.parent().parent());
					} else {
						error.insertAfter(element);
					}
				}
			});
			
			var level = '${handlerRegister.showLevel}';
			if('4' == level || '7' == level){
				$("#groupDiv").show();
			}else{
				$("#groupDiv").hide();
			}

			$("#showLevel").on('change' , function(){
			     var value = $("#showLevel").val();
			     if(value == '4' || value == '7'){
			    	 $("#groupDiv").show();
				 }else{
					 $("#groupDiv").hide();
				 }
			});
			
		});
	</script>
</head>
<body>
	<ul class="nav nav-tabs">
		<li><a href="${ctx}/handler/handlerRegister/">报名列表</a></li>
		<li class="active"><a href="${ctx}/handler/handlerRegister/form?id=${handlerRegister.id}">报名<shiro:hasPermission name="handler:handlerRegister:edit">${not empty handlerRegister.id?'修改':'添加'}</shiro:hasPermission><shiro:lacksPermission name="handler:handlerRegister:edit">查看</shiro:lacksPermission></a></li>
	</ul><br/>
	<form:form id="inputForm" modelAttribute="handlerRegister" action="${ctx}/handler/handlerRegister/save" method="post" class="form-horizontal">
		<form:hidden path="id"/>
		<sys:message content="${message}"/>		
		<h3>会员基本信息</h3>
		
		<div class="control-group">
			<label class="control-label">会员号：</label>
			<div class="controls">
				<form:input path="memberCode" readonly="true" htmlEscape="false" maxlength="100" class="input-xlarge "/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">姓名：</label>
			<div class="controls">
				<form:input path="name" readonly="true" htmlEscape="false" maxlength="64" class="input-xlarge "/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">性别：</label>
			<div class="controls">
				<form:radiobuttons path="gender" items="${fns:getDictList('user_gender')}" itemLabel="label" itemValue="value" htmlEscape="false" class="" disabled="true"/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">电话：</label>
			<div class="controls">
				<form:input path="mobile" htmlEscape="false" maxlength="20" class="input-xlarge "/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">培训学校：</label>
			<div class="controls">
				<form:input path="schoolNameCn" htmlEscape="false" maxlength="255" class="input-xlarge "/>
			</div>
		</div>
		
		<div style="clear:both;"></div>
		<h3>活动信息</h3>	
		<div class="control-group">
			<label class="control-label">活动名称：</label>
			<div class="controls">
				<form:input path="handlerShow.showName" htmlEscape="false" maxlength="100" class="input-xlarge required" readonly="true" />
				<span class="help-inline"><font color="red">*</font> </span>
			</div>
		</div>	
		<div class="control-group">
			<label class="control-label">活动编号：</label>
			<div class="controls">
				<form:input path="showCode" htmlEscape="false" maxlength="100" class="input-xlarge required" readonly="true"/>
				<span class="help-inline"><font color="red">*</font> </span>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">报名序号：</label>
			<div class="controls">
				<form:input path="registerCode" readonly="true" htmlEscape="false" maxlength="100" class="input-xlarge "/>
			</div>
		</div>
		
		<div class="control-group">
			<label class="control-label">级别：</label>
			<div class="controls">
				<form:select path="showLevel" class="input-xlarge required">
					<form:option value="" label=""/>
					<form:options items="${showLevels}" itemLabel="label" itemValue="value" htmlEscape="false"/>
				</form:select>
			</div>
		</div>
		
		<div id="groupDiv"> 
			<div class="control-group">
			<label class="control-label">请选择组别：</label>
			<div class="controls">
				<form:checkboxes path="showGroups" items="${fns:getDictList('handler_show_group')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
			</div>
			</div>
		</div>
	
		<div class="control-group">
			<label class="control-label">审核状态：</label>
			<div class="controls">
				<form:select path="reviewState" class="input-medium">
					<form:option value="1" label="已报名"/>
					<form:option value="3" label="已取消"/>
				</form:select>
			</div>
		</div>
		
		<div class="form-actions">
			<shiro:hasPermission name="handler:handlerRegister:edit"><input id="btnSubmit" class="btn btn-primary" type="submit" value="保 存"/>&nbsp;</shiro:hasPermission>
			<input id="btnCancel" class="btn" type="button" value="返 回" onclick="history.go(-1)"/>
		</div>
	</form:form>
</body>
</html>