<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>美容活动犬种管理</title>
	<meta name="decorator" content="default"/>
	<style type="text/css">
		.content-head-main{
			padding-left:20px;
			background-color:#eee;
			height:40px;
			line-height: 40px;
		}
		.content-head-sub{
			padding-left:20px;
			background-color:#FFDEAD;
			height:30px;
			line-height: 30px;
			color:#FF4500;
			font-weight:5px;
			border-top: 1px solid #ddd;
		}
		.content-body-out{
			padding-left:20px;
			margin:10px 0px;
			display: -webkit-box;
			overflow: auto;
			min-height: 40px;
		}
		.content-body-in{
			display:inline-block;
			border:1px solid #EEE;
			padding: 3px;
			border-radius:3px;
			margin:0 8px 8px 0;
		}
		.content-body-sel{
			overflow:hidden;
			text-overflow:ellipsis;
			white-space:nowrap;
			display:inline-block;
			vertical-align:middle;
			text-align: center;
		}
		.content-body-img{
			vertical-align:middle;
			margin: 0 3px 0 5px;
		}
		.td-head{
		    padding: 10px 20px!important;
		}
		.td-body{
			padding: 20px 20px!important;
			background-color:#FFF;
		}
	</style>
	<script type="text/javascript">
		String.prototype.endWith=function(str){
			var reg=new RegExp(str+"$");
			return reg.test(this);
		}
		$(document).ready(function() {
			if("${checkedBreeds}" != ""){
				var checkedArr = "${checkedBreeds}".split(",");
				checkedArr.forEach(function (item,index,array){
					if($("#contentTable input[type=checkbox][value='"+item+"']").size()>0){
						$("#contentTable input[type=checkbox][value='"+item+"']").prop("checked",true);
						$("#content-body-out").append('<div id="'+item+'" class="content-body-in"><div class="content-body-sel">'+item+'</div><span class="close content-body-img" onclick="delLabel(\''+item+'\')" title="删除">×</span></div>');
					}
				});
			}
			
			if("${otherBreeds}" != ""){
				$("#addOtherBreed").attr("checked","true");
				$("#otherBreed").val("${otherBreeds}");
				$("#otherBreed").show();
			}
		});
		var minNum = parseInt("${minNum}");
		var maxNum = parseInt("${maxNum}");
		function checkBreed(obj){
			var groupArr = [];
			var validFlag = true;
			var checkedSize = $("#contentTable input[type=checkbox]:checked").size();
			if(checkedSize > maxNum){
				validFlag = false;
				layer.msg("${showLevelsLabel}最多选择${maxNum}个犬种！");
			}else if('${validate}' != 'false'){
				$("#contentTable input[type=checkbox]:checked").each(function(){
					var index = groupArr.indexOf($(this).attr("group"));
					if(index >= 0){
						layer.msg("同一组别只能选择一个犬种！");
						validFlag = false;
					}
					groupArr.push($(this).attr("group"));
				});
			}
			var selLabel = $(obj).val();
			if(validFlag){
				if($(obj).is(':checked')){
					$("#content-body-out").append('<div id="'+selLabel+'" class="content-body-in"><div class="content-body-sel">'+selLabel+'</div><span class="close content-body-img" onclick="delLabel(\''+selLabel+'\')" title="删除">×</span></div>');
				}else{
					delLabel(selLabel);
				}
			}else{
				delLabel(selLabel);
			}
		}
		
		function delLabel(breedName){
			$("#content-body-out #"+breedName).remove();
			$("#contentTable input[value='"+breedName+"']:checked").removeAttr("checked"); 
		}
		
		function delAllLabel(){
			$("#content-body-out").html("");
			$("#contentTable input[type=checkbox]").removeAttr("checked"); 
			$("#otherBreed").val("");
		}
		
		function getCheckedBreeds(){
			var checkedSize = $("#contentTable input[type=checkbox]:checked").size();
			var otherBreedValArr = [];
			if($("#addOtherBreed").is(":checked")){
				otherBreedValArr = $("#otherBreed").val().split(",").filter(function (s) {
				   return s && s.trim();
				});
			}
			if(checkedSize + otherBreedValArr.length > maxNum){
				layer.msg("${showLevelsLabel}最多选择${maxNum}个犬种！");
				return false;
			}else if(checkedSize + otherBreedValArr.length < minNum){
				layer.msg("${showLevelsLabel}至少选择${minNum}个犬种！");
				return false;
			}
			var resultArr = [];
			$("#contentTable input[type=checkbox]:checked").each(function(){
				resultArr.push($(this).val());
			});
			return {"checkedBreeds":resultArr.join(","),"otherBreeds":otherBreedValArr.join(",")};
		};
		
		function addOtherBreed(obj){
			if($(obj).is(":checked")){
				$("#otherBreed").show();
			}else{
				$("#otherBreed").hide();
			}
		}
		
		function validateInput(otherBreed){
			otherBreed.value = otherBreed.value.replace(/，/ig,',')
			otherBreed.value = otherBreed.value.replace(/ /ig,'')
			otherBreed.value = otherBreed.value.replace(new RegExp(',+',"gm"),','); 
		}
		
		function trimInput(otherBreed){
			otherBreed.value = $.trim(otherBreed.value);
			if(otherBreed.value.endWith(",")){
				otherBreed.value = otherBreed.value.substring(0,otherBreed.value.length-1);
			}
			
		}
	</script>
</head>
<body>
	<div class="container container-layer" style="width:800px;">
		<div class="content-head-main">
			已选择品种 <a href="javascript:;" onclick="delAllLabel();" style="color:#1ab394;">清空</a>
			<div style="float: right;margin-right:10px;display:block;">
				<input id="addOtherBreed" name="addOtherBreed" type="checkbox" onclick="addOtherBreed(this);" style="vertical-align: middle;">
				<div style="vertical-align:middle;display:inline-block;color: #1ab394;font-weight:800;">其他犬种</div>
				<input id="otherBreed" placeholder="填写犬种名称，多品种使用逗号分隔" type="text" htmlEscape="false" class="input-xlarge" style="vertical-align:middle;display:none;margin-bottom: 0px;" onkeyup="validateInput(this);" onblur="trimInput(this);"/>
			</div>
		</div>
		<div id="content-body-out" class="content-body-out"></div>
		<div class="content-head-sub">
			请在以下品种范围内选择
		</div>
		<table id="contentTable" class="table table-striped table-bordered table-condensed">
			<tbody>
				<c:forEach items="${breedGroupList}" var="gsb">
					<tr>
						<td class="td-head">
							${gsb.breedGroup}
						</td>
					</tr>
					<tr>
						<td class="td-body">
							<c:forEach items="${gsb.breedList}" var="b">
								<div style="margin:0px 10px 10px 0px;display: inline-block;width:150px;">
									<c:choose>
									    <c:when test="${b.registered && validate}">
											<input group="${gsb.breedGroup}" name="showDogBreed" type="checkbox" value="${b.breedName}" disabled="disabled">
												<font color="#eb9316">${b.breedName}</font>
											</input>
									    </c:when>
									    <c:otherwise>
									    	<input group="${gsb.breedGroup}" name="showDogBreed" type="checkbox" value="${b.breedName}" onclick="checkBreed(this);">
												${b.breedName}	
											</input>
									    </c:otherwise>
								    </c:choose>
								</div>
							</c:forEach>
						</td>
					</tr>
				</c:forEach>
			</tbody>
		</table>
	</div>
</body>
</html>