<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>报名信息查看</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
			//复选框回显
			var id= $("#id").val();
			$.ajax({
				type:"POST",
	            url: ctx+"/groomer/groomerRegister/getRegisterMessage",
	            data : {'id':id},
	            dataType: 'json',
	            async: false, 
	            success: function(jsons){
	            	if(jsons.length>0){
						$.each(jsons, function(index,item) {
							if (item=='无'||item=='贵宾'||item=='比熊'||item=='雪纳瑞'||item=='模型') {
		            			$("input[type=checkbox][name='showDogBreed'][value="+item+"]").attr("checked",'checked');
							}else{
								$("input[type=text][name='showDogBreed']").val(item);
							}
	    				});
					}
	            }
			});
            var showCategory='${groomerRegister.groomerShow.showCategory}';
            //美容师资格认证
            if(showCategory=='1'){
                $("#otherLevelO").show();
                $("#otherLevelT").hide();
                $("#otherLevelR").hide();
                $("#otherLevelNurse").hide();
            }
            //国际宠物美容师认证
            if(showCategory=='2'){
                $("#otherLevelO").hide();
                $("#otherLevelT").show();
                $("#otherLevelR").hide();
                $("#otherLevelNurse").hide();
                $("#moxing").show();
            }
            //宠物造型师&国际宠物美容师认证
            if(showCategory=='3'){
                $("#otherLevelO").hide();
                $("#otherLevelT").hide();
                $("#otherLevelR").show();
                $("#otherLevelNurse").hide();
            }
            //国际宠物洗护师
            if(showCategory=='4'){
                $("#otherLevelO").hide();
                $("#otherLevelT").hide();
                $("#otherLevelR").hide();
                $("#otherLevelNurse").show();
            }
            var showLevel= '${groomerRegister.showLevel}';
            var words  = showLevel.split(",");
            if(showCategory=='1'){
                words.forEach(function (index,item) {
                    $("input[type=checkbox][name='showLevel'][value='"+index+"']").attr("checked",'checked');
                });
            }
            //国际宠物美容师认证
            if(showCategory=='2'){
                words.forEach(function (index,item) {
                    $("#otherLevelT [type=checkbox][name='showLevel'][value='"+index+"']").attr("checked",'checked');
                });
            }
            //宠物造型师&国际宠物美容师认证
            if(showCategory=='3'){
                words.forEach(function (index,item) {
                    $("#otherLevelR [type=checkbox][name='showLevel'][value='"+index+"']").attr("checked",'checked');
                });
            }
            //宠物造型师&国际宠物美容师认证
            if(showCategory=='4'){
                words.forEach(function (index,item) {
                    $("#otherLevelNurse [type=radio][name='showLevel'][value='"+index+"']").attr("checked",'checked');
                });
            }

		});
	</script>
</head>
<body>
	<ul class="nav nav-tabs">
		<li class="active"><shiro:hasPermission name="groomer:groomerRegister:view"><a href="${ctx}/groomer/groomerRegister/view?id=${groomerRegister.id}">报名信息查看</a></shiro:hasPermission></li>
		<li>
			<shiro:hasPermission name="groomer:groomerRegister:view">
				<a href="${ctx}/groomer/groomerWrittenExamInfo/gradeDetail?id=${groomerRegister.id}">成绩查看</a>
			</shiro:hasPermission>
		</li>

	</ul>
	<form:form id="inputForm" modelAttribute="groomerRegister"  class="form-horizontal">
		<form:hidden path="id"/>
		<sys:message content="${message}"/>
		<h3>会员基本信息</h3>
		<div class="control-group">
			<label class="control-label">会员号：</label>
			<div class="controls">
				${fns:escapeHtml(groomerRegister.memberCode) }
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">姓名：</label>
			<div class="controls">
				${fns:escapeHtml(groomerRegister.name) }
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">手机号：</label> 
			<div class="controls">
				${fns:escapeHtml(groomerRegister.mobile) }
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">性别：</label> 
			<div class="controls">
				${fns:getDictLabel(groomerRegister.gender, 'user_gender', '')}
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">培训机构：</label>
			<div class="controls">
				${fns:escapeHtml(groomerRegister.schoolNameCn) }
			</div>
		</div>
		<div style="clear:both;"></div>
		<h3>赛事信息</h3>	
		<div class="control-group">
			<label class="control-label">赛事名称：</label>
			<div class="controls">
				${fns:escapeHtml(groomerRegister.groomerShow.showName) }
			</div>
		</div>	
		<div class="control-group">
			<label class="control-label">赛事编号：</label>
			<div class="controls">
				${fns:escapeHtml(groomerRegister.showCode) }
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">活动分类：</label>
			<div class="controls">
					${fns:getDictLabel(groomerRegister.groomerShow.showCategory, 'groomer_show_category', '')}
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">参赛级别：</label>
            <div class="controls">
           		<c:set var="showCategory" value="${groomerRegister.groomerShow.showCategory}"></c:set>
				<c:choose>
				    <c:when test="${showCategory eq '1'}">
						<input name="showLevel" maxlength="50" class="disabled" type="radio" value="none"  ${fns:splitContains(groomerRegister.showLevel,"none",",")?"checked":""}/>
						<label>无</label>
						<input  name="showLevel" maxlength="50" class="disabled" type="radio" value="C"  ${fns:splitContains(groomerRegister.showLevel,"C",",")?"checked":""}/>
						<label>C</label>
						<input  name="showLevel" maxlength="50" class="disabled" type="radio" value="B"  ${fns:splitContains(groomerRegister.showLevel,"B",",")?"checked":""}/>
						<label>B</label>
						<input name="showLevel" maxlength="50" class="disabled" type="radio" value="A"  ${fns:splitContains(groomerRegister.showLevel,"A",",")?"checked":""}/>
						<label>A</label>
						<input name="showLevel" maxlength="50" class="disabled" type="radio" value="MASTER"  ${fns:splitContains(groomerRegister.showLevel,"MASTER",",")?"checked":""}/>
						<label>教师</label>
				    </c:when>
				    <c:when test="${showCategory eq '2'}">
				    	<input name="showLevel" maxlength="50" class="disabled" type="radio" value="国际宠物美容师"  ${fns:splitContains(groomerRegister.showLevel,"国际宠物美容师",",")?"checked":""}/>
						<label>国际宠物美容师</label>
				    </c:when>
				    <c:when test="${showCategory eq '3'}">
				    	<input name="showLevel" maxlength="50" class="disabled" type="radio" value="国际宠物美容师"  ${fns:splitContains(groomerRegister.showLevel,"国际宠物美容师",",")?"checked":""}/>
						<label>国际宠物美容师</label>
						<input  name="showLevel" maxlength="50" class="disabled" type="radio" value="宠物造型师&国际宠物美容师"  ${fns:splitContains(groomerRegister.showLevel,"宠物造型师&国际宠物美容师",",")?"checked":""}/>
						<label>宠物造型师&国际宠物美容师</label>
				    </c:when>
				    <c:when test="${showCategory eq '4'}">
				    	<oa:dictRadios name="showLevel" value="${groomerRegister.showLevel}" cssClass="input-xlarge required" type="groomer_nurse_level" readonly="true" rangeItems="${groomerRegister.groomerShow.testLevel}"></oa:dictRadios>
				    </c:when>
					<c:when test="${showCategory eq '6'}">
						<input  name="showLevel" maxlength="50" class="disabled" type="radio" value="C"  ${fns:splitContains(groomerRegister.showLevel,"C",",")?"checked":""}/>
						<label>C</label>
						<input  name="showLevel" maxlength="50" class="disabled" type="radio" value="B"  ${fns:splitContains(groomerRegister.showLevel,"B",",")?"checked":""}/>
						<label>B</label>
						<input name="showLevel" maxlength="50" class="disabled" type="radio" value="A"  ${fns:splitContains(groomerRegister.showLevel,"A",",")?"checked":""}/>
						<label>A</label>
					</c:when>
					<c:when test="${showCategory eq '8'}">
						<oa:dictRadios name="showLevel" value="${groomerRegister.showLevel}" cssClass="input-xlarge required" type="groomer_cat_nurse_level" readonly="true" rangeItems="${groomerRegister.groomerShow.testLevel}"></oa:dictRadios>
					</c:when>
				    <c:otherwise>
				    	活动类型错误
				    </c:otherwise>
				</c:choose>
            </div>
        </div>
		<div class="control-group">
			<label class="control-label">请假及取消：</label>
			<div id="leaveCancel"  class="controls">
	            <c:if test="${groomerRegister.leaveCancel=='0'}">
				否&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
				</c:if>
				<c:if test="${groomerRegister.leaveCancel=='1'}">
				是&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
				</c:if>
				<label  style="margin-left:20px;color:red; ">（关联报名统计中“赛前请假人数”）</label>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">赛场请假：</label>
			<div id="showLeave" class="controls">
				 <c:if test="${groomerRegister.showLeave=='0'}">
				否&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
				</c:if>
				<c:if test="${groomerRegister.showLeave=='1'}">
				是&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
				</c:if>
				<label style="margin-left:20px;color:red; ">（关联报名统计中“赛前退赛人数”）</label>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">比赛犬种：</label>
			<div class="controls">
				${fns:substringAfter(groomerRegister.showDogBreed,",")}
				${not empty groomerRegister.showDogBreedExtra?"# ":""}
				${fns:substringAfter(groomerRegister.showDogBreedExtra,",")}
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">备注信息：</label>
			<div class="controls">
				${fns:escapeHtml(groomerRegister.remarks) }
			</div>
		</div>
		<div class="form-actions">
			<input id="btnCancel" class="btn" type="button" value="返 回" onclick="history.go(-1)"/>
		</div>
	</form:form>
</body>
</html>