<%@ page contentType="text/html;charset=UTF-8" %>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<c:set var="ctxStatic" value="${pageContext.request.contextPath}/static"/>
<c:if test="${!empty errorMsg}">
${errorMsg}
</c:if>
<c:if test="${empty errorMsg}">
<tr id="${partId}" class="refund-body">
	<td class="col-xs-6">
		<input name="orderCode" value="${order.orderCode}" class="input-large" type="hidden" readonly="readonly">
		<div class="input-small">${order.orderCode}</div>
	</td>
	<td>
		<input name="memberCode" value="${order.memberCode}" class="input-medium" type="hidden">
		<input name="memberName" value="${order.memberName}" class="input-medium" type="hidden">
		<div class="input-small">${order.memberName}${empty order.memberCode? '' :'（ '.concat(order.memberCode.concat(' ）'))}</div>
	</td>
	<td>
		<input id="totalPrice${partId}" name="totalPrice" value="${order.totalPrice}" class="input-mini" type="hidden" style="margin-top:10px;" readonly="readonly">
		<div class="input-mini">${order.totalPrice}</div>
	</td>
	<td>
		<input id="partRefundFlag${partId}" name="partRefundFlag" value="false" class="input-medium" type="hidden">
        <span><input onclick="partRefundChange(this,'${partId}');" name="partRefundFlagRadio${partId}" type="radio" value="true"><label>是</label></span>
        <span><input onclick="partRefundChange(this,'${partId}');" name="partRefundFlagRadio${partId}" type="radio" value="false" checked="checked"><label>否</label></span>
	</td>
	<td>
		<input id="partRefundPrice${partId}" name="partRefundPrice" value="${order.totalPrice}" placeholder="该金额应小于订单金额" class="input-medium" type="number" min="1" max="${order.totalPrice}" style="margin-top:10px;" readonly="true">
	</td>
	<td> 
		<input id="chargingItemName${partId}" name="chargingItemName" value="" class="input-medium" type="hidden">
		<select id="chargingItemId${partId}" name="chargingItemId" class="input-medium" onchange="chargingItemChange(this,'${partId}');">
			<option value="">请选择</option>
			<c:forEach items="${itemList}" var="item">
	        	<option value="${item.id}">${item.name}</option>
			</c:forEach>
        </select>
        <span id="chargingItemIdReq${partId}" style="display: none;" class="help-inline"><font color="red">*</font> </span>
	</td>
	<td>
		<input name="refundRemark" placeholder="请输入备注信息" type="text" value="${order.refundRemark}" style="margin-top:10px;width:320px;">
	</td>
	<td>
		<image src="${ctxStatic}/img/remove.png" onclick="deleteContent(this)" style="cursor:pointer;width: 16px;height:16px;padding:0px 5px 0px 5px;z-index:10;box-sizing:initial;"/>
	</td>
</tr>
</c:if>
