<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp" %>
<html>
<head>
    <title>会员账户资金收支明细</title>
    <meta name="decorator" content="default"/>
    <script type="text/javascript">
        $(document).ready(function () {
            $("#btnExport").click(function () {
                var memberCode = $("#memberCode").val();
                var startDate = $("#startDate").val();
                var endDate = $("#endDate").val();
                if (memberCode == "" || memberCode == null || endDate == "" || startDate == "") {
                    $.jBox.alert("会员号、起止时间不能为空");
                } else {
                    top.$.jBox.confirm("确认要导出数据吗？", "系统提示", function (v, h, f) {
                        if (v == "ok") {
                            $("#searchForm").attr("action", "${ctx}/finance/memberAccount/export");
                            $("#searchForm").submit();
                        }
                    }, {buttonsFocus: 1});
                    top.$('.jbox-body .jbox-icon').css('top', '55px');
                }
            });
        });

        function page(n, s) {
            if (n) $("#pageNo").val(n);
            if (s) $("#pageSize").val(s);
            $("#searchForm").attr("action", "${ctx}/finance/memberAccount/");
            $("#searchForm").submit();
            $("#btnSubmit").attr('disabled', "true");
            return false;
        }

        function updatePaymentRemarks(runningNumber, memberCode) {
            parent.layer.open({
                type: 2,
                title: ['修改会员支付备注', 'font-size:18px;text-align: center;'],
                shadeClose: false,
                shade: [0.8, '#393D49'],
                maxmin: false, //开启最大化最小化按钮
                area: ['600px', '360px'],
                content: "${ctx}/finance/memberAccount/editRemark/form?runningNumber=" + runningNumber + "&memberCode=" + memberCode,
            });
            return false;
        }

        function bindUserCallback(data) {
            window.location.reload();
        }

    </script>
</head>
<body>
<ul class="nav nav-tabs">
    <li class="active"><a href="${ctx}/finance/memberAccount/">会员账户资金收支明细</a></li>
    <li><a href="${ctx}/finance/memberAccount/org">地方俱乐部代办明细</a></li>
    <li><a href="${ctx}/finance/memberAccount/training">美容学校代办明细</a></li>
    <shiro:hasPermission name="finance:memberAccount:recharge">
        <li><a href="${ctx}/finance/memberAccount/form">会员账户充值</a></li>
        <li><a href="${ctx}/finance/memberAccount/formReserve">会员账户反向充值</a></li>
    </shiro:hasPermission>
    <li><a href="${ctx}/finance/saPaymentDetailTotal">会员充值消费明细</a></li>
</ul>
<form:form id="searchForm" modelAttribute="memberAccount" action="${ctx}/finance/memberAccount/" method="post"
           class="breadcrumb form-search">
    <input id="pageNo" name="pageNo" type="hidden" value="${page.pageNo}"/>
    <input id="pageSize" name="pageSize" type="hidden" value="${page.pageSize}"/>
    <ul class="ul-form">
        <li><label>流水号：</label>
            <form:input path="runningNumber" htmlEscape="false" maxlength="60" class="input-medium"/>
        </li>
        <li><label>付款会员号：</label>
            <form:input path="cmember" htmlEscape="false" maxlength="60" class="input-medium"/>
        </li>
        <li><label>会员号：</label>
            <form:input path="memberCode" id="memberCode" htmlEscape="false" maxlength="60" class="input-medium"/>
        </li>
        <li><label>会员名称：</label>
            <form:input path="memberName" id="memberName" htmlEscape="false" maxlength="60" class="input-medium"/>
        </li>
        <li><label>部门：</label>
            <sys:treeselect id="office" name="chargingItemOfficeId" value="${memberAccount.chargingItemOfficeId}"
                            labelName="chargingItemOfficeName" labelValue="${memberAccount.chargingItemOfficeName}"
                            title="部门" url="/sys/office/treeData?type=2" cssClass="input-small" allowClear="true"
                            notAllowSelectParent="true"/>
        </li>
        <li><label>支付方式：</label>
            <form:select path="paymentWay" class="input-medium">
                <form:option value="" label="全部"></form:option>
                <form:options items="${fns:getDictList('payment_way')}" itemLabel="label" itemValue="value"
                              htmlEscape="false"></form:options>
            </form:select>
        </li>
        <li><label>收支类型：</label>
            <form:select id="" path="chargingItemId" class="input-medium">
                <form:option value="" label="全部"/>
                <c:forEach items="${chargingItems}" var="item">
                    <form:option value="${item.id}" label="${item.name}" htmlEscape="false"/>
                </c:forEach>
            </form:select>
        </li>
        <li><label>操作人：</label>
            <sys:treeselect id="updateBy" name="updateBy.id" value="${memberAccount.updateBy.id}"
                            labelName="updateBy.name" labelValue="${memberAccount.updateBy.name}" title="用户"
                            url="/sys/office/treeData?type=3" cssClass="input-small" allowClear="true"
                            notAllowSelectParent="true"/>
        </li>
        <li><label>实付金额：</label>
            <form:input path="paymentAmount" htmlEscape="false" maxlength="60" class="input-medium"/>
        </li>
        <li><label>备注：</label>
            <form:input path="paymentRemarks" htmlEscape="false" maxlength="60" class="input-medium"/>
        </li>
        <li><label>开始时间：</label>
            <input id="startDate" name="paymentTimeStart" type="text" readonly="readonly" maxlength="20"
                   class="input-medium Wdate "
                   value="<fmt:formatDate value="${memberAccount.paymentTimeStart}" pattern="yyyy-MM-dd HH:mm:ss"/>"
                   onclick="WdatePicker({dateFmt:'yyyy-MM-dd HH:mm:ss',isShowClear:true});"/>-
            <input id="endDate" name="paymentTimeEnd" type="text" readonly="readonly" maxlength="20"
                   class="input-medium Wdate "
                   value="<fmt:formatDate value="${memberAccount.paymentTimeEnd}" pattern="yyyy-MM-dd HH:mm:ss"/>"
                   onclick="WdatePicker({dateFmt:'yyyy-MM-dd HH:mm:ss',isShowClear:true});"/>
        </li>
        <li class="btns"><input id="btnSubmit" class="btn btn-primary" type="submit" value="查询"
                                onclick="return page();"/></li>
        <li class="btns">
            <button id="btnExport" type="button" class="btn btn-primary">导出</button>
        </li>
        <li class="clearfix"></li>
    </ul>
</form:form>
<sys:message content="${message}"/>
<div class="alert" role="alert" style="text-align: right;">余额总计：${countPrice}元</div>
<table id="contentTable" class="table table-striped table-bordered table-condensed">
    <thead>
    <tr>
        <th>流水号</th>
        <th>会员号</th>
        <th>姓名</th>
        <th>付款人会员号</th>
        <th>充值金额</th>
        <th>订单金额</th>
        <th>账户余额</th>
        <th>记录余额*</th>
        <th>部门</th>
        <th>收支类型</th>
        <th>支付方式</th>
        <c:if test="${payType!=null&&payType=='3'||payType=='23'||payType=='21'||payType=='8'}">
            <th>凭证编号</th>
        </c:if>

        <th>缴费时间</th>
        <th>退款状态</th>
        <th>备注</th>
        <th>操作人</th>
        <th>操作</th>
    </tr>
    </thead>
    <tbody>

    <c:forEach items="${page.list}" var="memberAccount">
        <tr>
            <td>
                    ${fns:escapeHtml(memberAccount.runningNumber)}
            </td>
            <td>
                    ${fns:escapeHtml(memberAccount.memberCode)}
            </td>
            <td>
                    ${fns:escapeHtml(memberAccount.memberName)}
            </td>
            <td>
                <c:if test="${memberAccount.cmember!=null}">${fns:escapeHtml(memberAccount.cmember)}</c:if>
                <c:if test="${memberAccount.cmember==null&&memberAccount.orgmember!=null}">${fns:escapeHtml(memberAccount.orgmember)}</c:if>
                <c:if test="${memberAccount.cmember==null&& memberAccount.orgmember==null }">${fns:escapeHtml(memberAccount.memberCode)}</c:if>
            </td>
            <td>
                <c:if test="${memberAccount.chargingItemName=='账号充值'}">
                    ${fns:escapeHtml(memberAccount.paymentAmount)}
                </c:if>
            </td>
            <td>
                <c:if test="${memberAccount.chargingItemName!='账号充值'}">
                    ${fns:escapeHtml(memberAccount.paymentAmount)}
                </c:if>
                    <%--	${fns:escapeHtml(memberAccount.paymentAmount)}--%>
            </td>
            <td>
                    ${fns:escapeHtml(memberAccount.balanceMoney)}
            </td>
            <td>
                    ${fns:escapeHtml(memberAccount.balanceMoneyReal)}
            </td>

            <td>
                    ${fns:escapeHtml(memberAccount.chargingItemOfficeName)}
            </td>
            <td>
                    ${fns:escapeHtml(memberAccount.chargingItemName)}
            </td>

				<td>
					${fns:getDictLabel(memberAccount.paymentWay, 'payment_way', '')}
				</td>
				<c:if test="${payType!=null&&payType=='3'||payType=='23'||payType=='21'||payType=='8'}">
					<td>
							${memberAccount.voucherCode}
					</td>
				</c:if>
				<td>
					<fmt:formatDate value="${memberAccount.paymentTime}" pattern="yyyy-MM-dd HH:mm:ss"/>
				</td>
				<td>
					<c:choose>
						<c:when test="${memberAccount.orderCancelStatus == '1'}">
							作废
						</c:when>
						<c:otherwise>
							<c:if test="${memberAccount.businessRefundState==1}">退款审核中</c:if>
							<c:if test="${memberAccount.businessRefundState==2}">未通过</c:if>
							<c:if test="${memberAccount.businessRefundState==3}">通过</c:if>
						</c:otherwise>
					</c:choose>


				</td>
				<td>
					${fns:escapeHtml(memberAccount.paymentRemarks)}
					<c:if test="${memberAccount.owner==true}">
					<%--
					    <a href="${ctx}/finance/memberAccount/editRemark/form?runningNumber=${memberAccount.runningNumber}&memberCode=${memberAccount.memberCode}">编辑</a>
					--%>
					    <a href="javascript:;" onclick="updatePaymentRemarks('${memberAccount.runningNumber}', '${memberAccount.memberCode}')">编辑</a>
					</c:if>

            </td>
            <td>
                    ${fns:escapeHtml(memberAccount.updateBy.name)}
            </td>
            <td>
                <a href="${ctx}/finance/paymentOrder/form?orderCode=${memberAccount.runningNumber}">详情</a>
            </td>
        </tr>
    </c:forEach>
    </tbody>
</table>
<div class="pagination">${page}</div>
</body>
</html>